/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.LongSupplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import org.jetbrains.annotations.NotNull;

public class CachedFailedInsertInventoryHandler
implements SlottedStackStorage {
    private final SlottedStackStorage wrapped;
    private final LongSupplier timeSupplier;
    private long currentCacheTime = 0L;
    private final Set<Integer> failedInsertStackHashes = new HashSet<Integer>();

    public CachedFailedInsertInventoryHandler(SlottedStackStorage wrapped, LongSupplier timeSupplier) {
        this.wrapped = wrapped;
        this.timeSupplier = timeSupplier;
    }

    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        this.wrapped.setStackInSlot(slot, stack);
    }

    public int getSlotCount() {
        return this.wrapped.getSlotCount();
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return this.wrapped.getSlot(slot);
    }

    @NotNull
    public class_1799 getStackInSlot(int slot) {
        return this.wrapped.getStackInSlot(slot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        long inserted;
        if (this.currentCacheTime != this.timeSupplier.getAsLong()) {
            this.failedInsertStackHashes.clear();
            this.currentCacheTime = this.timeSupplier.getAsLong();
        }
        boolean hashCalculated = false;
        int stackHash = 0;
        if (!this.failedInsertStackHashes.isEmpty()) {
            stackHash = ItemStackKey.getHashCode(resource);
            hashCalculated = true;
            if (this.failedInsertStackHashes.contains(stackHash)) {
                return 0L;
            }
        }
        if ((inserted = this.wrapped.insert((Object)resource, maxAmount, ctx)) == 0L) {
            if (!hashCalculated) {
                stackHash = ItemStackKey.getHashCode(resource);
            }
            this.failedInsertStackHashes.add(stackHash);
        }
        return inserted;
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        long inserted;
        if (this.currentCacheTime != this.timeSupplier.getAsLong()) {
            this.failedInsertStackHashes.clear();
            this.currentCacheTime = this.timeSupplier.getAsLong();
        }
        boolean hashCalculated = false;
        int stackHash = 0;
        if (!this.failedInsertStackHashes.isEmpty()) {
            stackHash = ItemStackKey.getHashCode(resource);
            hashCalculated = true;
            if (this.failedInsertStackHashes.contains(stackHash)) {
                return 0L;
            }
        }
        if ((inserted = this.wrapped.insertSlot(slot, resource, maxAmount, ctx)) == 0L) {
            if (!hashCalculated) {
                stackHash = ItemStackKey.getHashCode(resource);
            }
            this.failedInsertStackHashes.add(stackHash);
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.wrapped.extract((Object)resource, maxAmount, ctx);
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.wrapped.extractSlot(slot, resource, maxAmount, ctx);
    }

    public int getSlotLimit(int slot) {
        return this.wrapped.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemVariant resource, int count) {
        return this.wrapped.isItemValid(slot, resource, count);
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return this.wrapped.iterator();
    }
}

