/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.p3pp3rf1y.porting_lib.transfer.items.SCItemStackHandler;
import net.p3pp3rf1y.porting_lib.transfer.items.SCItemStackHandlerSlot;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandlerSlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ISlotLimitUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;

public abstract class InventoryHandler
extends SCItemStackHandler
implements ITrackedContentsItemHandler {
    public static final String INVENTORY_TAG = "inventory";
    private static final String PARTITIONER_TAG = "partitioner";
    private static final String REAL_COUNT_TAG = "realCount";
    protected final IStorageWrapper storageWrapper;
    private final class_2487 contentsNbt;
    private final Runnable saveHandler;
    private final List<IntConsumer> onContentsChangedListeners = new ArrayList<IntConsumer>();
    private boolean persistent = true;
    private final Map<Integer, class_2487> stackNbts = new LinkedHashMap<Integer, class_2487>();
    private ISlotTracker slotTracker = new ISlotTracker.Noop();
    private int baseSlotLimit;
    private int slotLimit;
    private int maxStackSizeMultiplier;
    private boolean isInitializing;
    private final StackUpgradeConfig stackUpgradeConfig;
    private final InventoryPartitioner inventoryPartitioner;
    private Consumer<Set<class_1792>> filterItemsChangeListener = s -> {};
    private final Map<class_1792, Set<Integer>> filterItemSlots = new HashMap<class_1792, Set<Integer>>();
    private BooleanSupplier shouldInsertIntoEmpty = () -> true;
    private boolean slotLimitInitialized = false;

    protected InventoryHandler(int numberOfInventorySlots, IStorageWrapper storageWrapper, class_2487 contentsNbt, Runnable saveHandler, int baseSlotLimit, StackUpgradeConfig stackUpgradeConfig) {
        super(numberOfInventorySlots);
        this.stackUpgradeConfig = stackUpgradeConfig;
        this.isInitializing = true;
        this.storageWrapper = storageWrapper;
        this.contentsNbt = contentsNbt;
        this.saveHandler = saveHandler;
        this.setBaseSlotLimit(baseSlotLimit);
        this.deserializeNBT(contentsNbt.method_10562(INVENTORY_TAG));
        this.inventoryPartitioner = new InventoryPartitioner(contentsNbt.method_10562(PARTITIONER_TAG), this, () -> storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
        this.initStackNbts();
        this.isInitializing = false;
    }

    public ISlotTracker getSlotTracker() {
        this.initSlotTracker();
        return this.slotTracker;
    }

    @Override
    public void setSize(int size) {
        super.setSize(this.getSlotCount());
    }

    private void initStackNbts() {
        for (int slot = 0; slot < this.getSlotCount(); ++slot) {
            class_1799 slotStack = this.getSlotStack(slot);
            if (slotStack.method_7960()) continue;
            this.stackNbts.put(slot, this.getSlotsStackNbt(slot, slotStack));
        }
    }

    @Override
    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.persistent && this.updateSlotNbt(slot)) {
            this.saveInventory();
            this.triggerOnChangeListeners(slot);
        }
    }

    public void triggerOnChangeListeners(int slot) {
        for (IntConsumer onContentsChangedListener : this.onContentsChangedListeners) {
            onContentsChangedListener.accept(slot);
        }
    }

    private boolean updateSlotNbt(int slot) {
        class_1799 slotStack = this.getSlotStack(slot);
        if (slotStack.method_7960()) {
            if (this.stackNbts.containsKey(slot)) {
                this.stackNbts.remove(slot);
                return true;
            }
        } else {
            class_2487 itemTag = this.getSlotsStackNbt(slot, slotStack);
            if (!this.stackNbts.containsKey(slot) || !this.stackNbts.get(slot).equals((Object)itemTag)) {
                this.stackNbts.put(slot, itemTag);
                return true;
            }
        }
        return false;
    }

    private class_2487 getSlotsStackNbt(int slot, class_1799 slotStack) {
        class_2487 itemTag = new class_2487();
        itemTag.method_10569("Slot", slot);
        itemTag.method_10569(REAL_COUNT_TAG, slotStack.method_7947());
        slotStack.method_7953(itemTag);
        return itemTag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.slotTracker.clear();
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.getSlotCount());
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slotIndex = itemTags.method_10550("Slot");
            if (slotIndex < 0 || slotIndex >= this.getSlotCount()) continue;
            class_1799 slotStack = class_1799.method_7915((class_2487)itemTags);
            if (itemTags.method_10545(REAL_COUNT_TAG)) {
                slotStack.method_7939(itemTags.method_10550(REAL_COUNT_TAG));
            }
            this.getSlot(slotIndex).load(slotStack);
        }
        this.slotTracker.refreshSlotIndexesFrom(this);
        this.onLoad();
    }

    public int getBaseSlotLimit() {
        return this.baseSlotLimit;
    }

    @Override
    public int getInternalSlotLimit(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getSlotLimit(slot);
    }

    @Override
    public int getSlotLimit(int slot) {
        if (!this.slotLimitInitialized) {
            this.slotLimitInitialized = true;
            this.updateSlotLimit();
            this.inventoryPartitioner.onSlotLimitChange();
        }
        return this.slotLimit > this.baseSlotLimit ? this.slotLimit : this.inventoryPartitioner.getPartBySlot(slot).getSlotLimit(slot);
    }

    public int getBaseStackLimit(ItemVariant resource) {
        if (!this.stackUpgradeConfig.canStackItem(resource.getItem())) {
            return resource.getItem().method_7882();
        }
        int limit = MathHelper.intMaxCappedMultiply(resource.getItem().method_7882(), this.baseSlotLimit / 64);
        int remainder = this.baseSlotLimit % 64;
        if (remainder > 0) {
            limit = MathHelper.intMaxCappedAddition(limit, remainder * resource.getItem().method_7882() / 64);
        }
        return limit;
    }

    @Override
    public int getStackLimit(int slot, ItemVariant resource) {
        return this.inventoryPartitioner.getPartBySlot(slot).getStackLimit(slot, resource);
    }

    public class_1792 getFilterItem(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getFilterItem(slot);
    }

    public boolean isFilterItem(class_1792 item) {
        return this.inventoryPartitioner.isFilterItem(item);
    }

    public void setBaseSlotLimit(int baseSlotLimit) {
        this.slotLimitInitialized = false;
        this.baseSlotLimit = baseSlotLimit;
        this.maxStackSizeMultiplier = baseSlotLimit / 64;
        if (this.inventoryPartitioner != null) {
            this.inventoryPartitioner.onSlotLimitChange();
        }
        if (!this.isInitializing) {
            this.slotTracker.refreshSlotIndexesFrom(this);
        }
    }

    private void updateSlotLimit() {
        AtomicInteger slotLimitOverride = new AtomicInteger(this.baseSlotLimit);
        this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(ISlotLimitUpgrade.class).forEach(slu -> {
            if (slu.getSlotLimit() > slotLimitOverride.get()) {
                slotLimitOverride.set(slu.getSlotLimit());
            }
        });
        this.slotLimit = slotLimitOverride.get();
    }

    public long extractItemInternal(int slot, ItemVariant resource, long amount, TransactionContext ctx) {
        long extracted = super.extractSlot(slot, resource, amount, ctx);
        TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
            this.slotTracker.removeAndSetSlotIndexes(this, slot, this.getSlotStack(slot));
            this.onContentsChanged(slot);
        });
        return extracted;
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        return this.inventoryPartitioner.getPartBySlot(slot).extractItem(slot, resource, maxAmount, ctx);
    }

    public class_1799 getSlotStack(int slot) {
        return ((InventoryHandlerSlot)this.getSlot(slot)).getInternalStack();
    }

    public void setSlotStack(int slot, class_1799 stack) {
        ((InventoryHandlerSlot)this.getSlot(slot)).setInternalNewStack(stack);
        this.slotTracker.removeAndSetSlotIndexes(this, slot, stack);
        this.onContentsChanged(slot);
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        this.initSlotTracker();
        return maxAmount - this.slotTracker.insertItemIntoHandler(this, this::insertItemInternal, this::triggerOverflowUpgrades, slot, resource, maxAmount, ctx);
    }

    public long insertItemOnlyToSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        this.initSlotTracker();
        if (class_1799.method_31577((class_1799)this.getStackInSlot(slot), (class_1799)resource.toStack())) {
            return maxAmount - (long)this.triggerOverflowUpgrades(resource.toStack((int)(maxAmount - this.insertItemInternal(slot, resource, maxAmount, ctx)))).method_7947();
        }
        return this.insertItemInternal(slot, resource, maxAmount, ctx);
    }

    private void initSlotTracker() {
        if (!(this.slotTracker instanceof InventoryHandlerSlotTracker)) {
            this.slotTracker = new InventoryHandlerSlotTracker(this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), this.filterItemSlots);
            this.slotTracker.refreshSlotIndexesFrom(this);
            this.slotTracker.setShouldInsertIntoEmpty(this.shouldInsertIntoEmpty);
        }
    }

    private long insertItemInternal(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        long remaining = this.runOnBeforeInsert(slot, resource, maxAmount, ctx, this, this.storageWrapper);
        if (remaining <= 0L) {
            return maxAmount;
        }
        TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.slotTracker.removeAndSetSlotIndexes(this, slot, this.getStackInSlot(slot)));
        if ((remaining -= this.inventoryPartitioner.getPartBySlot(slot).insertItem(slot, resource, maxAmount, ctx, (Function4<Integer, ItemVariant, Long, TransactionContext, Long>)((Function4)(x$0, x$1, x$2, x$3) -> super.insertSlot(x$0, x$1, x$2, x$3)))) == maxAmount) {
            return 0L;
        }
        this.runOnAfterInsert(slot, ctx, this, this.storageWrapper);
        return maxAmount - remaining;
    }

    private class_1799 triggerOverflowUpgrades(class_1799 ret) {
        IOverflowResponseUpgrade overflowUpgrade;
        Iterator<IOverflowResponseUpgrade> iterator = this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(IOverflowResponseUpgrade.class).iterator();
        while (iterator.hasNext() && !(ret = (overflowUpgrade = iterator.next()).onOverflow(ret)).method_7960()) {
        }
        return ret;
    }

    private void runOnAfterInsert(int slot, TransactionContext ctx, IItemHandlerSimpleInserter handler, IStorageWrapper storageWrapper) {
        storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(IInsertResponseUpgrade.class).forEach(u -> u.onAfterInsert(handler, slot, ctx));
    }

    private long runOnBeforeInsert(int slot, ItemVariant resource, long maxAmount, TransactionContext ctx, IItemHandlerSimpleInserter handler, IStorageWrapper storageWrapper) {
        List<IInsertResponseUpgrade> wrappers = storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(IInsertResponseUpgrade.class);
        long toInsert = maxAmount;
        for (IInsertResponseUpgrade upgrade : wrappers) {
            toInsert = upgrade.onBeforeInsert(handler, slot, resource, toInsert, ctx);
            if (toInsert > 0L) continue;
            return 0L;
        }
        return toInsert;
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        this.inventoryPartitioner.getPartBySlot(slot).setStackInSlot(slot, stack, (x$0, x$1) -> super.setStackInSlot((int)x$0, (class_1799)x$1));
        this.slotTracker.removeAndSetSlotIndexes(this, slot, stack);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isItemValid(int slot, ItemVariant resource, int count) {
        return this.inventoryPartitioner.getPartBySlot(slot).isItemValid(slot, resource, count) && this.isAllowed(resource) && this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).matchesFilter(slot, resource);
    }

    @Override
    @Nonnull
    public ItemVariant getVariantInSlot(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getVariantInSlot(slot, x$0 -> super.getVariantInSlot(x$0));
    }

    @Override
    @Nonnull
    public class_1799 getStackInSlot(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getStackInSlot(slot, x$0 -> super.getStackInSlot(x$0));
    }

    protected abstract boolean isAllowed(ItemVariant var1);

    public void saveInventory() {
        this.contentsNbt.method_10566(INVENTORY_TAG, (class_2520)this.serializeNBT());
        if (this.inventoryPartitioner != null) {
            this.contentsNbt.method_10566(PARTITIONER_TAG, (class_2520)this.inventoryPartitioner.serializeNBT());
        }
        this.saveHandler.run();
    }

    @Nullable
    public Pair<class_2960, class_2960> getNoItemIcon(int slotIndex) {
        return this.inventoryPartitioner.getNoItemIcon(slotIndex);
    }

    public void copyStacksTo(InventoryHandler otherHandler) {
        InventoryHelper.copyTo(this, otherHandler);
    }

    public void addListener(IntConsumer onContentsChanged) {
        this.onContentsChangedListeners.add(onContentsChanged);
    }

    public void clearListeners() {
        this.onContentsChangedListeners.clear();
    }

    @Override
    public class_2487 serializeNBT() {
        class_2499 nbtTagList = new class_2499();
        nbtTagList.addAll(this.stackNbts.values());
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.getSlotCount());
        return nbt;
    }

    public int getStackSizeMultiplier() {
        return this.maxStackSizeMultiplier;
    }

    @Override
    public long insert(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        this.initSlotTracker();
        return maxAmount - this.slotTracker.insertItemIntoHandler(this, this::insertItemInternal, this::triggerOverflowUpgrades, resource, maxAmount, ctx);
    }

    @Override
    public long extract(ItemVariant resource, long maxAmount, TransactionContext ctx) {
        long remaining = maxAmount;
        for (int i = 0; i < this.getSlotCount() && remaining > 0L; ++i) {
            if (!this.getVariantInSlot(i).equals((Object)resource)) continue;
            remaining -= this.extractSlot(i, resource, remaining, ctx);
        }
        return maxAmount - remaining;
    }

    public void changeSlots(int diff) {
        ArrayList<SingleSlotStorage<ItemVariant>> previousSlots = new ArrayList<SingleSlotStorage<ItemVariant>>(this.getSlots());
        super.setSize(previousSlots.size() + diff);
        for (int i = 0; i < previousSlots.size() && i < this.getSlotCount(); ++i) {
            this.getSlot(i).load(((SCItemStackHandlerSlot)previousSlots.get(i)).getStack());
        }
        this.initStackNbts();
        this.saveInventory();
        this.slotTracker.refreshSlotIndexesFrom(this);
    }

    @Override
    public Set<ItemStackKey> getTrackedStacks() {
        this.initSlotTracker();
        HashSet<ItemStackKey> ret = new HashSet<ItemStackKey>(this.slotTracker.getFullStacks());
        ret.addAll(this.slotTracker.getPartialStacks());
        return ret;
    }

    @Override
    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.initSlotTracker();
        this.slotTracker.registerListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
    }

    @Override
    public void unregisterStackKeyListeners() {
        this.slotTracker.unregisterStackKeyListeners();
    }

    @Override
    public boolean hasEmptySlots() {
        return this.slotTracker.hasEmptySlots();
    }

    public InventoryPartitioner getInventoryPartitioner() {
        return this.inventoryPartitioner;
    }

    public boolean isSlotAccessible(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).isSlotAccessible(slot);
    }

    public Set<Integer> getNoSortSlots() {
        return this.inventoryPartitioner.getNoSortSlots();
    }

    public void onSlotFilterChanged(int slot) {
        this.inventoryPartitioner.getPartBySlot(slot).onSlotFilterChanged(slot);
    }

    public void registerFilterItemsChangeListener(Consumer<Set<class_1792>> listener) {
        this.filterItemsChangeListener = listener;
    }

    public void unregisterFilterItemsChangeListener() {
        this.filterItemsChangeListener = s -> {};
    }

    public void initFilterItems() {
        this.filterItemSlots.putAll(this.inventoryPartitioner.getFilterItems());
    }

    public void onFilterItemsChanged() {
        if (this.inventoryPartitioner == null) {
            return;
        }
        this.filterItemSlots.clear();
        this.filterItemSlots.putAll(this.inventoryPartitioner.getFilterItems());
        this.filterItemsChangeListener.accept(this.filterItemSlots.keySet());
    }

    public Set<class_1792> getFilterItems() {
        return this.filterItemSlots.keySet();
    }

    public void onInit() {
        if (this.inventoryPartitioner == null) {
            return;
        }
        this.inventoryPartitioner.onInit();
        this.slotTracker = new ISlotTracker.Noop();
    }

    public void setShouldInsertIntoEmpty(BooleanSupplier shouldInsertIntoEmpty) {
        this.shouldInsertIntoEmpty = shouldInsertIntoEmpty;
        this.slotTracker.setShouldInsertIntoEmpty(shouldInsertIntoEmpty);
    }

    @Override
    protected SCItemStackHandlerSlot makeSlot(int index, class_1799 stack) {
        return new InventoryHandlerSlot(index, this, stack);
    }

    public class InventoryHandlerSlot
    extends SCItemStackHandlerSlot {
        public InventoryHandlerSlot(int index, InventoryHandler handler, class_1799 initial) {
            super(index, handler, initial);
            super.setStack(initial);
        }

        protected class_1799 getInternalStack() {
            return super.getStack();
        }

        protected void setInternalNewStack(class_1799 stack) {
            super.setStack(stack);
            this.onFinalCommit();
        }

        @Override
        public class_1799 getStack() {
            if (InventoryHandler.this.inventoryPartitioner == null) {
                return super.getStack();
            }
            return InventoryHandler.this.inventoryPartitioner.getPartBySlot(this.getIndex()).getStackInSlot(this.getIndex(), s -> super.getStack());
        }

        @Override
        protected void setStack(class_1799 stack) {
            if (InventoryHandler.this.inventoryPartitioner == null) {
                super.setStack(stack);
                return;
            }
            InventoryHandler.this.inventoryPartitioner.getPartBySlot(this.getIndex()).setStackInSlot(this.getIndex(), stack, (slot, stck) -> super.setStack(stack));
        }

        @Override
        public ItemVariant getResource() {
            return InventoryHandler.this.inventoryPartitioner.getPartBySlot(this.getIndex()).getVariantInSlot(this.getIndex(), slot -> super.getResource());
        }

        @Override
        public void load(class_1799 stack) {
            super.setStack(stack);
            this.onStackChange();
        }
    }
}

