/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.renderdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public abstract class RenderInfo {
    private static final String TANKS_TAG = "tanks";
    private static final String BATTERY_TAG = "battery";
    private static final String TANK_POSITION_TAG = "position";
    private static final String TANK_INFO_TAG = "info";
    private static final String ITEM_DISPLAY_TAG = "itemDisplay";
    private static final String UPGRADES_TAG = "upgrades";
    private static final String UPGRADE_ITEMS_TAG = "upgradeItems";
    private static final Map<String, UpgradeRenderDataType<?>> RENDER_DATA_TYPES = Map.of(CookingUpgradeRenderData.TYPE.getName(), CookingUpgradeRenderData.TYPE, JukeboxUpgradeRenderData.TYPE.getName(), JukeboxUpgradeRenderData.TYPE);
    private ItemDisplayRenderInfo itemDisplayRenderInfo;
    private final Supplier<Runnable> getSaveHandler;
    private final List<class_1799> upgradeItems = new ArrayList<class_1799>();
    private final Map<UpgradeRenderDataType<?>, IUpgradeRenderData> upgradeData = new HashMap();
    private final Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = new LinkedHashMap<TankPosition, IRenderedTankUpgrade.TankRenderInfo>();
    @Nullable
    private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;
    private Consumer<RenderInfo> changeListener = ri -> {};

    protected RenderInfo(Supplier<Runnable> getSaveHandler) {
        this.getSaveHandler = getSaveHandler;
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo();
    }

    public ItemDisplayRenderInfo getItemDisplayRenderInfo() {
        return this.itemDisplayRenderInfo;
    }

    public void setUpgradeItems(List<class_1799> upgradeItems) {
        this.upgradeItems.clear();
        this.upgradeItems.addAll(upgradeItems);
        this.serializeUpgradeItems();
        this.save();
    }

    private void serializeUpgradeItems() {
        class_2487 renderInfo = this.getRenderInfoTag().orElse(new class_2487());
        class_2499 upgradeItemsTag = new class_2499();
        for (class_1799 upgradeItem : this.upgradeItems) {
            upgradeItemsTag.add((Object)upgradeItem.method_7953(new class_2487()));
        }
        renderInfo.method_10566(UPGRADE_ITEMS_TAG, (class_2520)upgradeItemsTag);
        this.serializeRenderInfo(renderInfo);
    }

    public <T extends IUpgradeRenderData> void setUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType, T renderData) {
        this.upgradeData.put(upgradeRenderDataType, renderData);
        this.serializeUpgradeData(upgrades -> upgrades.method_10566(upgradeRenderDataType.getName(), (class_2520)renderData.serializeNBT()));
        this.save();
    }

    public <T extends IUpgradeRenderData> Optional<T> getUpgradeRenderData(UpgradeRenderDataType<T> upgradeRenderDataType) {
        if (!this.upgradeData.containsKey(upgradeRenderDataType)) {
            return Optional.empty();
        }
        return upgradeRenderDataType.cast(this.upgradeData.get(upgradeRenderDataType));
    }

    private void serializeUpgradeData(Consumer<class_2487> modifyUpgradesTag) {
        class_2487 renderInfo = this.getRenderInfoTag().orElse(new class_2487());
        class_2487 upgrades = renderInfo.method_10562(UPGRADES_TAG);
        modifyUpgradesTag.accept(upgrades);
        renderInfo.method_10566(UPGRADES_TAG, (class_2520)upgrades);
        this.serializeRenderInfo(renderInfo);
    }

    public void refreshItemDisplayRenderInfo(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots) {
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo(displayItems, inaccessibleSlots);
        class_2487 renderInfo = this.getRenderInfoTag().orElse(new class_2487());
        renderInfo.method_10566(ITEM_DISPLAY_TAG, (class_2520)this.itemDisplayRenderInfo.serialize());
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public void setChangeListener(Consumer<RenderInfo> changeListener) {
        this.changeListener = changeListener;
    }

    protected void save(boolean triggerChangeListener) {
        this.getSaveHandler.get().run();
        if (triggerChangeListener) {
            this.changeListener.accept(this);
        }
    }

    protected void save() {
        this.save(false);
    }

    protected abstract void serializeRenderInfo(class_2487 var1);

    protected void deserialize() {
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            this.deserializeItemDisplay((class_2487)renderInfoTag);
            this.deserializeUpgradeItems((class_2487)renderInfoTag);
            this.deserializeUpgradeData((class_2487)renderInfoTag);
            this.deserializeTanks((class_2487)renderInfoTag);
            this.deserializeBattery((class_2487)renderInfoTag);
        });
        this.changeListener.accept(this);
    }

    private void deserializeUpgradeItems(class_2487 renderInfoTag) {
        class_2499 upgradeItemsTag = renderInfoTag.method_10554(UPGRADE_ITEMS_TAG, 10);
        this.upgradeItems.clear();
        for (int i = 0; i < upgradeItemsTag.size(); ++i) {
            this.upgradeItems.add(class_1799.method_7915((class_2487)upgradeItemsTag.method_10602(i)));
        }
    }

    private void deserializeItemDisplay(class_2487 renderInfoTag) {
        this.itemDisplayRenderInfo = ItemDisplayRenderInfo.deserialize(renderInfoTag.method_10562(ITEM_DISPLAY_TAG));
    }

    protected abstract Optional<class_2487> getRenderInfoTag();

    public Map<UpgradeRenderDataType<?>, IUpgradeRenderData> getUpgradeRenderData() {
        return this.upgradeData;
    }

    public void removeUpgradeRenderData(UpgradeRenderDataType<?> type) {
        this.upgradeData.remove(type);
        this.serializeUpgradeData(upgrades -> upgrades.method_10551(type.getName()));
        this.save();
    }

    private void deserializeUpgradeData(class_2487 renderInfoTag) {
        class_2487 upgrades = renderInfoTag.method_10562(UPGRADES_TAG).method_10553();
        upgrades.method_10541().forEach(key -> {
            if (RENDER_DATA_TYPES.containsKey(key)) {
                UpgradeRenderDataType<?> upgradeRenderDataType = RENDER_DATA_TYPES.get(key);
                this.upgradeData.put(upgradeRenderDataType, (IUpgradeRenderData)upgradeRenderDataType.deserialize(upgrades.method_10562(key)));
            }
        });
    }

    public class_2487 getNbt() {
        return this.getRenderInfoTag().orElse(new class_2487());
    }

    public void deserializeFrom(class_2487 renderInfoNbt) {
        this.resetUpgradeInfo(false);
        this.upgradeData.clear();
        this.serializeRenderInfo(renderInfoNbt);
        this.deserialize();
    }

    public void resetUpgradeInfo(boolean triggerChangeListener) {
        this.tankRenderInfos.clear();
        this.batteryRenderInfo = null;
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            renderInfoTag.method_10551(TANKS_TAG);
            renderInfoTag.method_10551(BATTERY_TAG);
        });
        this.save(triggerChangeListener);
    }

    public void setTankRenderInfo(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        this.tankRenderInfos.put(tankPosition, tankRenderInfo);
        this.serializeTank(tankPosition, tankRenderInfo);
        this.save();
    }

    private void deserializeTanks(class_2487 renderInfoTag) {
        class_2499 tanks = renderInfoTag.method_10554(TANKS_TAG, 10);
        for (int i = 0; i < tanks.size(); ++i) {
            class_2487 tank = tanks.method_10602(i);
            this.tankRenderInfos.put(TankPosition.valueOf(tank.method_10558(TANK_POSITION_TAG).toUpperCase(Locale.ENGLISH)), IRenderedTankUpgrade.TankRenderInfo.deserialize(tank.method_10562(TANK_INFO_TAG)));
        }
    }

    private void deserializeBattery(class_2487 renderInfoTag) {
        this.batteryRenderInfo = NBTHelper.getCompound(renderInfoTag, BATTERY_TAG).map(IRenderedBatteryUpgrade.BatteryRenderInfo::deserialize).orElse(null);
    }

    private void serializeTank(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        class_2487 tankInfo = tankRenderInfo.serialize();
        class_2487 renderInfo = this.getRenderInfoTag().orElse(new class_2487());
        class_2499 tanks = renderInfo.method_10554(TANKS_TAG, 10);
        boolean infoSet = false;
        for (int i = 0; i < tanks.size(); ++i) {
            class_2487 tank = tanks.method_10602(i);
            if (!tank.method_10558(TANK_POSITION_TAG).equals(tankPosition.method_15434())) continue;
            tank.method_10566(TANK_INFO_TAG, (class_2520)tankInfo);
            infoSet = true;
        }
        if (!infoSet) {
            class_2487 tankPositionInfo = new class_2487();
            tankPositionInfo.method_10582(TANK_POSITION_TAG, tankPosition.method_15434());
            tankPositionInfo.method_10566(TANK_INFO_TAG, (class_2520)tankInfo);
            tanks.add((Object)tankPositionInfo);
            renderInfo.method_10566(TANKS_TAG, (class_2520)tanks);
        }
        this.serializeRenderInfo(renderInfo);
    }

    public Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> getTankRenderInfos() {
        return this.tankRenderInfos;
    }

    public Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> getBatteryRenderInfo() {
        return Optional.ofNullable(this.batteryRenderInfo);
    }

    public void setBatteryRenderInfo(IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo) {
        this.batteryRenderInfo = batteryRenderInfo;
        class_2487 batteryInfo = batteryRenderInfo.serialize();
        class_2487 renderInfo = this.getRenderInfoTag().orElse(new class_2487());
        renderInfo.method_10566(BATTERY_TAG, (class_2520)batteryInfo);
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public List<class_1799> getUpgradeItems() {
        return this.upgradeItems;
    }

    public static class ItemDisplayRenderInfo {
        private static final String ITEMS_TAG = "items";
        private static final String INACCESSIBLE_SLOTS_TAG = "inaccessibleSlots";
        private final List<DisplayItem> displayItems;
        private final List<Integer> inaccessibleSlots;

        private ItemDisplayRenderInfo(DisplayItem displayItem, List<Integer> inaccessibleSlots) {
            this(List.of(displayItem), inaccessibleSlots);
        }

        private ItemDisplayRenderInfo(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots) {
            this.displayItems = displayItems;
            this.inaccessibleSlots = inaccessibleSlots;
        }

        public ItemDisplayRenderInfo() {
            this(new ArrayList<DisplayItem>(), new ArrayList<Integer>());
        }

        public class_2487 serialize() {
            class_2487 ret = new class_2487();
            if (this.displayItems.size() == 1) {
                this.displayItems.get(0).serialize(ret);
            } else if (this.displayItems.size() > 1) {
                NBTHelper.putList(ret, ITEMS_TAG, this.displayItems, displayItem -> displayItem.serialize(new class_2487()));
            }
            NBTHelper.putList(ret, INACCESSIBLE_SLOTS_TAG, this.inaccessibleSlots, class_2497::method_23247);
            return ret;
        }

        public static ItemDisplayRenderInfo deserialize(class_2487 tag) {
            List inaccessibleSlots = NBTHelper.getCollection(tag, INACCESSIBLE_SLOTS_TAG, (byte)3, t -> Optional.of(((class_2497)t).method_10701()), ArrayList::new).orElseGet(ArrayList::new);
            if (tag.method_10545("item")) {
                return new ItemDisplayRenderInfo(DisplayItem.deserialize(tag), (List<Integer>)inaccessibleSlots);
            }
            if (tag.method_10545(ITEMS_TAG)) {
                List items = NBTHelper.getCollection(tag, ITEMS_TAG, (byte)10, stackTag -> Optional.of(DisplayItem.deserialize((class_2487)stackTag)), ArrayList::new).orElseGet(ArrayList::new);
                return new ItemDisplayRenderInfo(items, (List<Integer>)inaccessibleSlots);
            }
            return new ItemDisplayRenderInfo();
        }

        public Optional<DisplayItem> getDisplayItem() {
            return this.isValidIndex(this.displayItems, 0) ? Optional.of(this.displayItems.get(0)) : Optional.empty();
        }

        private boolean isValidIndex(List<?> list, int index) {
            return index >= 0 && index < list.size();
        }

        public List<DisplayItem> getDisplayItems() {
            return this.displayItems;
        }

        public List<Integer> getInaccessibleSlots() {
            return this.inaccessibleSlots;
        }
    }

    public static class DisplayItem {
        private static final String ITEM_TAG = "item";
        private static final String ROTATION_TAG = "rotation";
        private static final String SLOT_INDEX_TAG = "slotIndex";
        private class_1799 item;
        private int rotation;
        private int slotIndex;

        public DisplayItem(class_1799 item, int rotation, int slotIndex) {
            this.item = item;
            this.rotation = rotation;
            this.slotIndex = slotIndex;
        }

        private class_2487 serialize(class_2487 tag) {
            tag.method_10566(ITEM_TAG, (class_2520)this.item.method_7953(new class_2487()));
            tag.method_10569(ROTATION_TAG, this.rotation);
            tag.method_10569(SLOT_INDEX_TAG, this.slotIndex);
            return tag;
        }

        private static DisplayItem deserialize(class_2487 tag) {
            return new DisplayItem(class_1799.method_7915((class_2487)tag.method_10562(ITEM_TAG)), tag.method_10550(ROTATION_TAG), tag.method_10550(SLOT_INDEX_TAG));
        }

        public class_1799 getItem() {
            return this.item;
        }

        public int getRotation() {
            return this.rotation;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }
    }
}

