/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.battery;

import java.util.Collections;
import java.util.HashSet;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeWrapper;

public class BatteryUpgradeItem
extends UpgradeItemBase<BatteryUpgradeWrapper> {
    public static final UpgradeType<BatteryUpgradeWrapper> TYPE = new UpgradeType<BatteryUpgradeWrapper>(BatteryUpgradeWrapper::new);
    private final BatteryUpgradeConfig batteryUpgradeConfig;

    public BatteryUpgradeItem(BatteryUpgradeConfig batteryUpgradeConfig) {
        this.batteryUpgradeConfig = batteryUpgradeConfig;
    }

    public BatteryUpgradeConfig getBatteryUpgradeConfig() {
        return this.batteryUpgradeConfig;
    }

    @Override
    public UpgradeType<BatteryUpgradeWrapper> getType() {
        return TYPE;
    }

    @Override
    public int getInventoryColumnsTaken() {
        return 2;
    }

    @Override
    public UpgradeSlotChangeResult canAddUpgradeTo(IStorageWrapper storageWrapper, class_1799 upgradeStack, boolean firstLevelStorage, boolean isClientSide) {
        HashSet<Integer> errorUpgradeSlots = new HashSet<Integer>();
        storageWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof BatteryUpgradeWrapper) {
                errorUpgradeSlots.add((Integer)slot);
            }
        });
        if (!errorUpgradeSlots.isEmpty()) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.battery_exists", new Object[0]), errorUpgradeSlots, Collections.emptySet(), Collections.emptySet());
        }
        int multiplierRequired = (int)Math.ceil((float)BatteryUpgradeWrapper.getEnergyStored(upgradeStack) / (float)this.getMaxEnergyStored(storageWrapper));
        if (multiplierRequired > 1) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.battery_energy_high", multiplierRequired), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    public int getMaxEnergyStored(IStorageWrapper storageWrapper) {
        int maxEnergyBase;
        int stackMultiplier = this.getAdjustedStackMultiplier(storageWrapper);
        return Integer.MAX_VALUE / stackMultiplier < (maxEnergyBase = this.getMaxEnergyBase(storageWrapper)) ? Integer.MAX_VALUE : maxEnergyBase * stackMultiplier;
    }

    public int getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1 + (int)((Double)this.batteryUpgradeConfig.stackMultiplierRatio.get() * (double)(storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1));
    }

    public int getMaxEnergyBase(IStorageWrapper storageWrapper) {
        return (Integer)this.batteryUpgradeConfig.energyPerSlotRow.get() * storageWrapper.getNumberOfSlotRows();
    }
}

