/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static Optional<class_1799> getItemFromEitherHand(class_1657 player, class_1792 item) {
        class_1799 mainHandItem = player.method_6047();
        if (mainHandItem.method_7909() == item) {
            return Optional.of(mainHandItem);
        }
        class_1799 offhandItem = player.method_6079();
        if (offhandItem.method_7909() == item) {
            return Optional.of(offhandItem);
        }
        return Optional.empty();
    }

    public static <T> Iterator<StorageView<T>> filterViews(final Iterator<StorageView<T>> iterator, final Predicate<ResourceAmount<T>> filter) {
        return new Iterator<StorageView<T>>(){
            StorageView<T> next;
            {
                this.findNext();
            }

            private void findNext() {
                while (iterator.hasNext()) {
                    this.next = (StorageView)iterator.next();
                    if (!filter.test(new ResourceAmount(this.next.getResource(), this.next.getAmount()))) continue;
                    return;
                }
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public StorageView<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                StorageView ret = this.next;
                this.findNext();
                return ret;
            }
        };
    }

    public static boolean hasItem(SlottedStorage<ItemVariant> inventory, Predicate<class_1799> matches) {
        return InventoryHelper.filterViews(inventory.nonEmptyIterator(), resource -> matches.test(((ItemVariant)resource.resource()).toStack((int)resource.amount()))).hasNext();
    }

    public static Set<Integer> getItemSlots(SlottedStorage<ItemVariant> inventory, Predicate<class_1799> matches) {
        HashSet<Integer> slots = new HashSet<Integer>();
        for (int slotIndex = 0; slotIndex < inventory.getSlotCount(); ++slotIndex) {
            SingleSlotStorage slot = inventory.getSlot(slotIndex);
            if (slot.isResourceBlank() || !matches.test(((ItemVariant)slot.getResource()).toStack((int)slot.getAmount()))) continue;
            slots.add(slotIndex);
        }
        return slots;
    }

    public static void copyTo(SlottedStackStorage handlerA, SlottedStackStorage handlerB) {
        int slotsA = handlerA.getSlotCount();
        int slotsB = handlerB.getSlotCount();
        for (int slot = 0; slot < slotsA && slot < slotsB; ++slot) {
            class_1799 slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.method_7960()) continue;
            handlerB.setStackInSlot(slot, slotStack);
        }
    }

    public static List<class_1799> insertIntoInventory(List<class_1799> stacks, Storage<ItemVariant> inventory, TransactionContext ctx) {
        if (stacks.isEmpty()) {
            return stacks;
        }
        ArrayList<class_1799> remainingStacks = new ArrayList<class_1799>();
        for (class_1799 stack : stacks) {
            ItemVariant resource = ItemVariant.of((class_1799)stack);
            long remaining = (long)stack.method_7947() - inventory.insert((Object)resource, (long)stack.method_7947(), ctx);
            if (remaining <= 0L) continue;
            remainingStacks.add(resource.toStack((int)remaining));
        }
        return remainingStacks;
    }

    public static class_1799 simulateInsertIntoInventory(SlottedStackStorage inventory, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
        try (Transaction simulate = Transaction.openNested((TransactionContext)ctx);){
            class_1799 class_17992 = InventoryHelper.insertIntoInventory(inventory, resource, maxAmount, (TransactionContext)simulate);
            return class_17992;
        }
    }

    public static class_1799 insertIntoInventory(SlottedStackStorage inventory, ItemVariant resource, long maxAmount, TransactionContext ctx) {
        long remaining = maxAmount;
        int slots = inventory.getSlotCount();
        for (int slot = 0; slot < slots && remaining > 0L; remaining -= inventory.insertSlot(slot, resource, remaining, ctx), ++slot) {
        }
        return resource.toStack((int)remaining);
    }

    public static class_1799 runPickupOnPickupResponseUpgrades(class_1937 world, UpgradeHandler upgradeHandler, class_1799 remainingStack, TransactionContext ctx) {
        return InventoryHelper.runPickupOnPickupResponseUpgrades(world, null, upgradeHandler, remainingStack, ctx);
    }

    public static class_1799 runPickupOnPickupResponseUpgrades(class_1937 world, @Nullable class_1657 player, UpgradeHandler upgradeHandler, class_1799 remainingStack, TransactionContext ctx) {
        List<IPickupResponseUpgrade> pickupUpgrades = upgradeHandler.getWrappersThatImplement(IPickupResponseUpgrade.class);
        for (IPickupResponseUpgrade pickupUpgrade : pickupUpgrades) {
            int countBeforePickup = remainingStack.method_7947();
            try (Transaction pickupTransaction = Transaction.openNested((TransactionContext)ctx);){
                class_1799 finalRemainingStack = remainingStack = pickupUpgrade.pickup(world, remainingStack, (TransactionContext)pickupTransaction);
                TransactionCallback.onSuccess((TransactionContext)pickupTransaction, () -> {
                    if (player != null && finalRemainingStack.method_7947() != countBeforePickup) {
                        InventoryHelper.playPickupSound(world, player);
                    }
                });
                pickupTransaction.commit();
            }
            if (!remainingStack.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remainingStack;
    }

    private static void playPickupSound(class_1937 level, @Nonnull class_1657 player) {
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, RandHelper.getRandomMinusOneToOne(level.field_9229) * 1.4f + 2.0f);
    }

    public static <T> T iterate(SlottedStorage<ItemVariant> handler, BiFunction<Integer, class_1799, T> getFromSlotStack, Supplier<T> supplyDefault, Predicate<T> shouldExit) {
        T ret = supplyDefault.get();
        int slots = handler.getSlotCount();
        for (int slot = 0; slot < slots; ++slot) {
            SingleSlotStorage storage = handler.getSlot(slot);
            class_1799 stack = ((ItemVariant)storage.getResource()).toStack((int)storage.getAmount());
            ret = getFromSlotStack.apply(slot, stack);
            if (shouldExit.test(ret)) break;
        }
        return ret;
    }

    public static int getCountMissingInHandler(Storage<ItemVariant> itemHandler, class_1799 filter, int expectedCount) {
        StorageView view;
        class_1799 stack;
        int missingCount = expectedCount;
        Iterator iterator = itemHandler.nonEmptyViews().iterator();
        while (iterator.hasNext() && (!class_1799.method_31577((class_1799)(stack = ((ItemVariant)(view = (StorageView)iterator.next()).getResource()).toStack((int)view.getAmount())), (class_1799)filter) || (missingCount -= Math.min(stack.method_7947(), missingCount)) != 0)) {
        }
        return missingCount;
    }

    public static void transfer(Storage<ItemVariant> handlerA, Storage<ItemVariant> handlerB, Consumer<Supplier<class_1799>> onInserted, @Nullable TransactionContext ctx) {
        if (handlerA == null || handlerB == null) {
            return;
        }
        try (Transaction outer = Transaction.openNested((TransactionContext)ctx);){
            for (StorageView view : handlerA.nonEmptyViews()) {
                long maxExtracted;
                ItemVariant resource = (ItemVariant)view.getResource();
                try (Transaction extractionTestTransaction = outer.openNested();){
                    maxExtracted = view.extract((Object)resource, view.getAmount(), (TransactionContext)extractionTestTransaction);
                }
                Transaction transferTransaction = outer.openNested();
                try {
                    long accepted = handlerB.insert((Object)resource, maxExtracted, (TransactionContext)transferTransaction);
                    if (accepted <= 0L || view.extract((Object)resource, accepted, (TransactionContext)transferTransaction) != accepted) continue;
                    TransactionCallback.onSuccess((TransactionContext)transferTransaction, () -> onInserted.accept(() -> resource.toStack((int)accepted)));
                    transferTransaction.commit();
                }
                finally {
                    if (transferTransaction == null) continue;
                    transferTransaction.close();
                }
            }
            outer.commit();
        }
        catch (Exception e) {
            class_128 report = class_128.method_560((Throwable)e, (String)"Moving resources between storages");
            report.method_562("Move details").method_577("Input storage", () -> handlerA.toString()).method_577("Output storage", () -> handlerB.toString());
            throw new class_148(report);
        }
    }

    public static class_1799 getAndRemove(SlottedStorage<ItemVariant> itemHandler, int slotIndex) {
        if (slotIndex >= itemHandler.getSlotCount()) {
            return class_1799.field_8037;
        }
        SingleSlotStorage slot = itemHandler.getSlot(slotIndex);
        ItemVariant resource = (ItemVariant)slot.getResource();
        return resource.toStack((int)slot.extract((Object)resource, Long.MAX_VALUE, null));
    }

    public static void insertOrDropItem(class_1657 player, class_1799 stack, Storage<ItemVariant> ... inventories) {
        ItemVariant resource = ItemVariant.of((class_1799)stack);
        long toInsert = stack.method_7947();
        for (Storage<ItemVariant> inventory : inventories) {
            try (Transaction ctx = Transaction.openOuter();){
                toInsert -= inventory.insert((Object)resource, toInsert, (TransactionContext)ctx);
                ctx.commit();
            }
            if (toInsert != 0L) continue;
            return;
        }
        if (toInsert > 0L) {
            player.method_7328(resource.toStack((int)toInsert), true);
        }
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(SlottedStorage<ItemVariant> handler) {
        return InventoryHelper.getCompactedStacks(handler, new HashSet<Integer>());
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(SlottedStorage<ItemVariant> handler, Set<Integer> ignoreSlots) {
        HashMap<ItemStackKey, Integer> ret = new HashMap<ItemStackKey, Integer>();
        for (int slotIndex = 0; slotIndex < handler.getSlotCount(); ++slotIndex) {
            SingleSlotStorage slot = handler.getSlot(slotIndex);
            if (slot.isResourceBlank() || ignoreSlots.contains(slotIndex)) continue;
            ItemStackKey itemStackKey = ItemStackKey.of(((ItemVariant)slot.getResource()).toStack());
            ret.put(itemStackKey, ret.computeIfAbsent(itemStackKey, fs -> 0) + (int)slot.getAmount());
        }
        return ret;
    }

    public static List<class_1799> getCompactedStacksSortedByCount(SlottedStorage<ItemVariant> handler) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks(handler);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(InventorySorter.BY_COUNT);
        ArrayList<class_1799> ret = new ArrayList<class_1799>();
        sortedList.forEach(e -> {
            class_1799 stackCopy = ((ItemStackKey)e.getKey()).getStack().method_7972();
            stackCopy.method_7939(((Integer)e.getValue()).intValue());
            ret.add(stackCopy);
        });
        return ret;
    }

    public static Set<ItemStackKey> getUniqueStacks(SlottedStorage<ItemVariant> handler) {
        HashSet<ItemStackKey> uniqueStacks = new HashSet<ItemStackKey>();
        for (StorageView view : handler.nonEmptyViews()) {
            class_1799 stack = ((ItemVariant)view.getResource()).toStack((int)view.getAmount());
            if (stack.method_7960()) continue;
            ItemStackKey itemStackKey = ItemStackKey.of(stack);
            uniqueStacks.add(itemStackKey);
        }
        return uniqueStacks;
    }

    public static List<Integer> getEmptySlotsRandomized(SlottedStorage<ItemVariant> inventory) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.getSlotCount(); ++i) {
            if (!inventory.getSlot(i).isResourceBlank()) continue;
            list.add(i);
        }
        Collections.shuffle(list, new Random());
        return list;
    }

    public static void shuffleItems(List<class_1799> stacks, int emptySlotsCount, class_5819 rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<class_1799> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            class_1799 itemstack = iterator.next();
            if (itemstack.method_7960()) {
                iterator.remove();
                continue;
            }
            if (itemstack.method_7947() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (emptySlotsCount - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            class_1799 itemstack2 = (class_1799)list.remove(class_3532.method_15395((class_5819)rand, (int)0, (int)(list.size() - 1)));
            int i = class_3532.method_15395((class_5819)rand, (int)1, (int)(itemstack2.method_7947() / 2));
            class_1799 itemstack1 = itemstack2.method_7971(i);
            if (itemstack2.method_7947() > 1 && rand.method_43056()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.method_7947() > 1 && rand.method_43056()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, new Random());
    }

    public static void dropItems(SlottedStackStorage inventoryHandler, class_1937 level, class_2338 pos) {
        InventoryHelper.dropItems(inventoryHandler, level, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static void dropItems(SlottedStackStorage inventoryHandler, class_1937 level, double x, double y, double z) {
        for (StorageView view : inventoryHandler.nonEmptyViews()) {
            long extracted;
            ItemVariant resource = (ItemVariant)view.getResource();
            try (Transaction ctx = Transaction.openOuter();){
                extracted = view.extract((Object)resource, view.getAmount(), (TransactionContext)ctx);
                ctx.commit();
            }
            class_1799 extractedStack = resource.toStack((int)extracted);
            while (!extractedStack.method_7960()) {
                class_1264.method_5449((class_1937)level, (double)x, (double)y, (double)z, (class_1799)extractedStack.method_7971(Math.min(extractedStack.method_7947(), extractedStack.method_7914())));
            }
        }
    }

    public static int getAnalogOutputSignal(ITrackedContentsItemHandler handler) {
        double totalFilled = 0.0;
        boolean isEmpty = true;
        for (int slot = 0; slot < handler.getSlotCount(); ++slot) {
            class_1799 stack = handler.getStackInSlot(slot);
            if (stack.method_7960()) continue;
            int slotLimit = handler.getInternalSlotLimit(slot);
            totalFilled += (double)((float)stack.method_7947() / ((float)slotLimit / (64.0f / (float)stack.method_7914())));
            isEmpty = false;
        }
        double percentFilled = totalFilled / (double)handler.getSlotCount();
        return class_3532.method_15357((double)(percentFilled * 14.0)) + (isEmpty ? 0 : 1);
    }
}

