/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class InventorySorter {
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_NAME = Comparator.comparing(o -> InventorySorter.getRegistryName((ItemStackKey)o.getKey()));
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_COUNT = (first, second) -> {
        int ret = ((Integer)second.getValue()).compareTo((Integer)first.getValue());
        return ret != 0 ? ret : InventorySorter.getRegistryName((ItemStackKey)first.getKey()).compareTo(InventorySorter.getRegistryName((ItemStackKey)second.getKey()));
    };
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_TAGS = new Comparator<Map.Entry<ItemStackKey, Integer>>(){

        @Override
        public int compare(Map.Entry<ItemStackKey, Integer> first, Map.Entry<ItemStackKey, Integer> second) {
            class_1799 secondStack;
            class_1792 secondItem;
            class_1799 firstStack = first.getKey().getStack();
            class_1792 firstItem = firstStack.method_7909();
            if (firstItem == (secondItem = (secondStack = second.getKey().getStack()).method_7909())) {
                return 0;
            }
            int ret = this.compareTags(firstStack.method_40133().collect(Collectors.toSet()), secondStack.method_40133().collect(Collectors.toSet()));
            return ret != 0 ? ret : InventorySorter.getRegistryName(first.getKey()).compareTo(InventorySorter.getRegistryName(second.getKey()));
        }

        private int compareTags(Set<class_6862<class_1792>> firstTags, Set<class_6862<class_1792>> secondTags) {
            int ret = Integer.compare(secondTags.size(), firstTags.size());
            if (ret != 0) {
                return ret;
            }
            if (firstTags.size() == 1) {
                return firstTags.iterator().next().comp_327().method_12833(secondTags.iterator().next().comp_327());
            }
            ArrayList<class_6862<class_1792>> firstTagsSorted = new ArrayList<class_6862<class_1792>>(firstTags);
            ArrayList<class_6862<class_1792>> secondTagsSorted = new ArrayList<class_6862<class_1792>>(secondTags);
            firstTagsSorted.sort(Comparator.comparing(class_6862::comp_327));
            secondTagsSorted.sort(Comparator.comparing(class_6862::comp_327));
            for (int i = 0; i < firstTagsSorted.size(); ++i) {
                ret = firstTagsSorted.get(i).comp_327().method_12833(secondTagsSorted.get(i).comp_327());
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    };

    private InventorySorter() {
    }

    private static String getRegistryName(ItemStackKey itemStackKey) {
        return class_7923.field_41178.method_10221((Object)itemStackKey.getStack().method_7909()).toString();
    }

    public static void sortHandler(SlottedStackStorage handler, Comparator<? super Map.Entry<ItemStackKey, Integer>> comparator, Set<Integer> noSortSlots) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks((SlottedStorage<ItemVariant>)handler, noSortSlots);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(comparator);
        int slots = handler.getSlotCount();
        Iterator it = sortedList.iterator();
        ItemStackKey current = null;
        int count = 0;
        for (int slot = 0; slot < slots; ++slot) {
            if (noSortSlots.contains(slot)) continue;
            if ((current == null || count <= 0) && it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                current = (ItemStackKey)entry.getKey();
                count = (Integer)entry.getValue();
            }
            if (current != null && count > 0) {
                count -= InventorySorter.placeStack(handler, current, count, slot);
                continue;
            }
            InventorySorter.emptySlot(handler, slot);
        }
    }

    private static void emptySlot(SlottedStackStorage handler, int slot) {
        if (!handler.getStackInSlot(slot).method_7960()) {
            handler.setStackInSlot(slot, class_1799.field_8037);
        }
    }

    private static int placeStack(SlottedStackStorage handler, ItemStackKey current, int count, int slot) {
        int n;
        class_1799 copy = current.getStack().method_7972();
        if (handler instanceof InventoryHandler) {
            InventoryHandler inventoryHandler = (InventoryHandler)handler;
            n = inventoryHandler.getStackLimit(slot, ItemVariant.of((class_1799)copy));
        } else {
            n = handler.getSlotLimit(slot);
        }
        int slotLimit = n;
        int countPlaced = Math.min(count, slotLimit);
        copy.method_7939(countPlaced);
        if (!class_1799.method_7973((class_1799)handler.getStackInSlot(slot), (class_1799)copy)) {
            handler.setStackInSlot(slot, copy);
        }
        return countPlaced;
    }
}

