/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_7833;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.LimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LimitedBarrelBlock
extends BarrelBlock {
    public static final class_2753 HORIZONTAL_FACING = class_2741.field_12481;
    public static final class_2754<VerticalFacing> VERTICAL_FACING = class_2754.method_11850((String)"vertical_facing", VerticalFacing.class);
    private final Supplier<Integer> getBaseStackSizeMultiplier;

    public LimitedBarrelBlock(int numberOfInventorySlots, Supplier<Integer> getBaseStackSizeMultiplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, class_4970.class_2251 properties) {
        super(() -> numberOfInventorySlots, numberOfUpgradeSlotsSupplier, properties, (class_2689<class_2248, class_2680> stateDef) -> (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)stateDef.method_11664()).method_11657((class_2769)HORIZONTAL_FACING, (Comparable)class_2350.field_11043)).method_11657(VERTICAL_FACING, (Comparable)((Object)VerticalFacing.NO))).method_11657((class_2769)TICKING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FLAT_TOP, (Comparable)Boolean.valueOf(false)));
        this.getBaseStackSizeMultiplier = getBaseStackSizeMultiplier;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (this.getVerticalFacing(state) != VerticalFacing.NO) {
            return state;
        }
        return (class_2680)state.method_11657((class_2769)HORIZONTAL_FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)));
    }

    @Override
    public VerticalFacing getVerticalFacing(class_2680 state) {
        return (VerticalFacing)((Object)state.method_11654(VERTICAL_FACING));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HORIZONTAL_FACING, VERTICAL_FACING, TICKING, FLAT_TOP});
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        class_2350 direction = blockPlaceContext.method_7715().method_10153();
        class_2350 horizontalDirection = blockPlaceContext.method_8042().method_10153();
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)HORIZONTAL_FACING, (Comparable)horizontalDirection)).method_11657(VERTICAL_FACING, (Comparable)((Object)VerticalFacing.fromDirection(direction)))).method_11657((class_2769)FLAT_TOP, (Comparable)Boolean.valueOf(BarrelBlockItem.isFlatTop(blockPlaceContext.method_8041())));
    }

    @Override
    public class_2350 getFacing(class_2680 state) {
        VerticalFacing verticalFacing = this.getVerticalFacing(state);
        return verticalFacing == VerticalFacing.NO ? (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING) : verticalFacing.getDirection();
    }

    @Override
    public class_2350 getHorizontalDirection(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
    }

    @Override
    public int getBaseStackSizeMultiplier() {
        return this.getBaseStackSizeMultiplier.get();
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flat) {
        int numberOfInventorySlots = this.getNumberOfInventorySlots();
        String translationKey = numberOfInventorySlots == 1 ? "limited_barrel_singular" : "limited_barrel_plural";
        tooltip.add((class_2561)class_2561.method_43469((String)StorageTranslationHelper.INSTANCE.translBlockTooltipKey(translationKey), (Object[])new Object[]{String.valueOf(numberOfInventorySlots), String.valueOf(this.getBaseStackSizeMultiplier())}).method_27692(class_124.field_1063));
    }

    @Override
    @Nullable
    public StorageBlockEntity newBlockEntity(class_2338 pos, class_2680 state) {
        return new LimitedBarrelBlockEntity(pos, state);
    }

    @Override
    protected class_2591<? extends StorageBlockEntity> getBlockEntityType() {
        return ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE;
    }

    @Override
    protected boolean tryItemInteraction(class_1657 player, class_1268 hand, WoodStorageBlockEntity b, class_1799 stackInHand, class_2350 facing, class_3965 hitResult) {
        if (super.tryItemInteraction(player, hand, b, stackInHand, facing, hitResult)) {
            return true;
        }
        if (hitResult.method_17780() != facing || player.method_5715()) {
            return false;
        }
        int slot = this.getInteractionSlot(b.method_11016(), b.method_11010(), hitResult);
        if (b instanceof LimitedBarrelBlockEntity) {
            class_1769 dyeItem;
            LimitedBarrelBlockEntity limitedBarrelBlockEntity = (LimitedBarrelBlockEntity)b;
            if (b.isPacked()) {
                return false;
            }
            if (limitedBarrelBlockEntity.depositItem(player, hand, stackInHand, slot)) {
                return true;
            }
            class_1792 class_17922 = stackInHand.method_7909();
            if (class_17922 instanceof class_1769 && limitedBarrelBlockEntity.applyDye(slot, stackInHand, (dyeItem = (class_1769)class_17922).method_7802(), player.method_5715())) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean trySneakItemInteraction(class_1657 player, class_1268 hand, class_2680 state, class_1937 level, class_2338 pos, class_3965 hitVec, class_1799 itemInHand) {
        if (super.trySneakItemInteraction(player, hand, state, level, pos, hitVec, itemInHand)) {
            return true;
        }
        return this.tryToDyeAll(state, level, pos, hitVec, itemInHand);
    }

    public boolean tryToDyeAll(class_2680 state, class_1937 level, class_2338 pos, class_3965 hitVec, class_1799 itemStack) {
        if (hitVec.method_17780() != this.getFacing(state) || !(itemStack.method_7909() instanceof class_1769)) {
            return false;
        }
        return WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, LimitedBarrelBlockEntity.class).map(barrel -> barrel.applyDye(0, itemStack, ((class_1769)itemStack.method_7909()).method_7802(), true)).orElse(false);
    }

    private int getInteractionSlot(class_2338 pos, class_2680 state, class_3965 hitResult) {
        boolean right;
        int invSlots = this.getNumberOfInventorySlots();
        if (invSlots == 1) {
            return 0;
        }
        Vector3f blockCoords = hitResult.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_46409();
        blockCoords.add(-0.5f, -0.5f, -0.5f);
        VerticalFacing verticalFacing = this.getVerticalFacing(state);
        if (verticalFacing != VerticalFacing.NO) {
            blockCoords.rotate((Quaternionfc)LimitedBarrelBlock.getNorthBasedRotation((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)));
            blockCoords.rotate((Quaternionfc)LimitedBarrelBlock.getNorthBasedRotation(verticalFacing.getDirection().method_10153()));
        } else {
            blockCoords.rotate((Quaternionfc)LimitedBarrelBlock.getNorthBasedRotation(((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)).method_10153()));
        }
        blockCoords.add(0.5f, 0.5f, 0.5f);
        boolean top = blockCoords.y() > 0.5f;
        boolean bl = right = blockCoords.x() > 0.5f;
        if (invSlots == 2) {
            return top ? 0 : 1;
        }
        if (invSlots == 3) {
            if (top) {
                return 0;
            }
            return right ? 2 : 1;
        }
        if (top) {
            return right ? 1 : 0;
        }
        return right ? 3 : 2;
    }

    @Override
    protected StorageContainerMenu instantiateContainerMenu(int w, class_1657 pl, class_2338 pos) {
        return new LimitedBarrelContainerMenu(w, pl, pos);
    }

    public static Quaternionf getNorthBasedRotation(class_2350 dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> {
                Quaternionf quaternion = class_7833.field_40714.rotationDegrees(90.0f);
                quaternion.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                yield quaternion;
            }
            case class_2350.field_11036 -> {
                Quaternionf quaternion = class_7833.field_40714.rotationDegrees(-90.0f);
                quaternion.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                yield quaternion;
            }
            case class_2350.field_11043 -> new Quaternionf();
            case class_2350.field_11035 -> class_7833.field_40716.rotationDegrees(180.0f);
            case class_2350.field_11039 -> class_7833.field_40716.rotationDegrees(-90.0f);
            case class_2350.field_11034 -> class_7833.field_40716.rotationDegrees(90.0f);
        };
    }

    private Optional<class_3965> getHitResult(class_1657 player) {
        Optional<class_3965> optional;
        class_239 hitResult = player.method_5745(player.method_7337() ? 5.0 : 4.5, 0.0f, false);
        if (hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            optional = Optional.of(blockHitResult);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        if (level.method_8608()) {
            return;
        }
        this.tryToTakeItem(state, level, pos, player);
    }

    public boolean tryToTakeItem(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        return WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, LimitedBarrelBlockEntity.class).map(be -> this.tryToTakeItem(state, level, pos, player, (LimitedBarrelBlockEntity)be)).orElse(false);
    }

    private boolean tryToTakeItem(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, LimitedBarrelBlockEntity be) {
        return this.getHitResult(player).map(blockHitResult -> {
            if (!blockHitResult.method_17777().equals((Object)pos) || level.method_8320(pos) != state || blockHitResult.method_17780() != this.getFacing(state)) {
                return false;
            }
            return !be.isPacked() && be.tryToTakeItem(player, this.getInteractionSlot(pos, state, (class_3965)blockHitResult));
        }).orElse(false);
    }

    public boolean isLookingAtFront(class_1657 player, class_2338 pos, class_2680 state) {
        return this.getHitResult(player).map(blockHitResult -> blockHitResult.method_17777().equals((Object)pos) && blockHitResult.method_17780() == this.getFacing(state)).orElse(false);
    }

    @Override
    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, LimitedBarrelBlockEntity.class).ifPresent(be -> {
            StorageWrapper storageWrapper = be.getStorageWrapper();
            SettingsHandler settingsHandler = storageWrapper.getSettingsHandler();
            ((ItemDisplaySettingsCategory)settingsHandler.getTypeCategory(ItemDisplaySettingsCategory.class)).selectSlots(0, storageWrapper.getNumberOfInventorySlots());
            ((NoSortSettingsCategory)settingsHandler.getTypeCategory(NoSortSettingsCategory.class)).selectSlots(0, storageWrapper.getNumberOfInventorySlots());
            ((MemorySettingsCategory)settingsHandler.getTypeCategory(MemorySettingsCategory.class)).setIgnoreNbt(false);
        });
    }

    @Override
    public int getDisplayItemsCount(List<RenderInfo.DisplayItem> displayItems) {
        return this.getNumberOfInventorySlots();
    }

    @Override
    public boolean hasFixedIndexDisplayItems() {
        return true;
    }
}

