/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class LimitedBarrelBlockEntity
extends BarrelBlockEntity
implements ICountDisplay {
    private static final String SLOT_COUNTS_TAG = "slotCounts";
    private static final Consumer<VoidUpgradeWrapper> VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT = voidUpgrade -> {
        voidUpgrade.getFilterLogic().setAllowByDefault(false);
        voidUpgrade.setShouldVoidOverflowDefaultOrLoadFromNbt(true);
    };
    private long lastDepositTime = -100L;
    private final List<Integer> slotCounts = new ArrayList<Integer>();
    private Map<Integer, class_1767> slotColors = new HashMap<Integer, class_1767>();
    private boolean showCounts = true;

    public LimitedBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, (class_2591<? extends BarrelBlockEntity>)ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE);
        this.registerUpgradeDefaults();
        this.registerClientNotificationOnCountChange();
    }

    private void registerUpgradeDefaults() {
        this.getStorageWrapper().registerUpgradeDefaultsHandler(VoidUpgradeWrapper.class, VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT);
    }

    private void registerClientNotificationOnCountChange() {
        this.getStorageWrapper().getInventoryHandler().addListener(slot -> WorldHelper.notifyBlockUpdate((class_2586)this));
    }

    @Override
    protected void onUpgradeCachesInvalidated() {
        super.onUpgradeCachesInvalidated();
        this.registerClientNotificationOnCountChange();
    }

    @Override
    public boolean shouldShowCounts() {
        return this.showCounts;
    }

    @Override
    public boolean memorizesItemsWhenLocked() {
        return true;
    }

    @Override
    public boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return false;
    }

    @Override
    public void toggleCountVisibility() {
        this.showCounts = !this.showCounts;
        this.method_5431();
        WorldHelper.notifyBlockUpdate((class_2586)this);
    }

    @Override
    public List<Integer> getSlotCounts() {
        return this.slotCounts;
    }

    public boolean applyDye(int slot, class_1799 dyeStack, class_1767 dyeColor, boolean applyToAll) {
        if (slot < 0 || slot >= this.getStorageWrapper().getInventoryHandler().getSlotCount()) {
            return false;
        }
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        if (applyToAll) {
            boolean success = false;
            for (int i = 0; i < invHandler.getSlotCount(); ++i) {
                success |= this.applyDye(i, dyeColor, invHandler);
            }
            if (!success) {
                return false;
            }
        } else if (!this.applyDye(slot, dyeColor, invHandler)) {
            return false;
        }
        this.method_5431();
        dyeStack.method_7934(1);
        WorldHelper.notifyBlockUpdate((class_2586)this);
        return true;
    }

    private boolean applyDye(int slot, class_1767 dyeColor, InventoryHandler invHandler) {
        class_1799 stackInSlot = invHandler.getStackInSlot(slot);
        if (stackInSlot.method_7960() || dyeColor.equals((Object)this.slotColors.get(slot))) {
            return false;
        }
        this.slotColors.put(slot, dyeColor);
        return true;
    }

    public int getSlotColor(int slot) {
        return this.slotColors.getOrDefault(slot, class_1767.field_7952).method_16357();
    }

    public boolean depositItem(class_1657 player, class_1268 hand, class_1799 stackInHand, int slot) {
        long gameTime = this.method_10997().method_8510();
        boolean doubleClick = gameTime - this.lastDepositTime < 10L;
        this.lastDepositTime = gameTime;
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        class_1799 stackInSlot = invHandler.getStackInSlot(slot);
        MemorySettingsCategory memorySettings = (MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
        if (doubleClick) {
            return this.depositFromAllOfPlayersInventory(player, slot, invHandler, stackInSlot, memorySettings);
        }
        SingleSlotStorage handSlot = PlayerInventoryStorage.of((class_1657)player).getHandSlot(hand);
        ItemVariant resource = (ItemVariant)handSlot.getResource();
        try (Transaction ctx = Transaction.openOuter();){
            long extracted;
            long simulatedInsert;
            try (Transaction simulate = Transaction.openNested((TransactionContext)ctx);){
                simulatedInsert = invHandler.insertItemOnlyToSlot(slot, resource, handSlot.getAmount(), (TransactionContext)simulate);
            }
            if (simulatedInsert > 0L && (extracted = handSlot.extract((Object)resource, simulatedInsert, (TransactionContext)ctx)) > 0L) {
                invHandler.insertItemOnlyToSlot(slot, resource, extracted, (TransactionContext)ctx);
                if (this.isLocked()) {
                    memorySettings.selectSlot(slot);
                }
                ctx.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean depositFromAllOfPlayersInventory(class_1657 player, int slot, InventoryHandler invHandler, class_1799 stackInSlot, MemorySettingsCategory memorySettings) {
        boolean success = false;
        Predicate<class_1799> memoryItemMatches = itemStack -> memorySettings.isSlotSelected(slot) && memorySettings.matchesFilter(slot, itemStack);
        PlayerInventoryStorage playerInventory = PlayerInventoryStorage.of((class_1657)player);
        for (StorageView view : playerInventory.nonEmptyViews()) {
            ItemVariant resource = (ItemVariant)view.getResource();
            if ((!stackInSlot.method_7960() || !memoryItemMatches.test(resource.toStack()) && !invHandler.isFilterItem(resource.getItem())) && (resource.isBlank() || !class_1799.method_31577((class_1799)stackInSlot, (class_1799)resource.toStack((int)view.getAmount())))) continue;
            Transaction ctx = Transaction.openOuter();
            try {
                long extracted;
                long simulatedInsert;
                try (Transaction simulate = Transaction.openNested((TransactionContext)ctx);){
                    simulatedInsert = invHandler.insertItemOnlyToSlot(slot, resource, view.getAmount(), (TransactionContext)simulate);
                }
                if (simulatedInsert <= 0L || (extracted = view.extract((Object)resource, simulatedInsert, (TransactionContext)ctx)) <= 0L) continue;
                invHandler.insertItemOnlyToSlot(slot, resource, extracted, (TransactionContext)ctx);
                success = true;
                ctx.commit();
            }
            finally {
                if (ctx == null) continue;
                ctx.close();
            }
        }
        return success;
    }

    boolean tryToTakeItem(class_1657 player, int slot) {
        long extracted;
        InventoryHandler inventoryHandler = this.getStorageWrapper().getInventoryHandler();
        class_1799 stackInSlot = inventoryHandler.getStackInSlot(slot);
        if (stackInSlot.method_7960()) {
            return false;
        }
        ItemVariant resource = ItemVariant.of((class_1799)stackInSlot);
        int countToTake = player.method_5715() ? Math.min(stackInSlot.method_7914(), stackInSlot.method_7947()) : 1;
        try (Transaction ctx = Transaction.openOuter();){
            extracted = inventoryHandler.extractSlot(slot, resource, (long)countToTake, (TransactionContext)ctx);
            ctx.commit();
        }
        if (player.method_31548().method_7394(resource.toStack((int)extracted))) {
            this.method_10997().method_8396(null, this.method_11016(), class_3417.field_15197, class_3419.field_15248, 0.2f, (RandHelper.getRandomMinusOneToOne((class_5819)this.method_10997().field_9229) * 0.7f + 1.0f) * 2.0f);
        } else {
            player.method_7328(resource.toStack((int)extracted), false);
        }
        return true;
    }

    @Override
    void updateOpenBlockState(class_2680 state, boolean open) {
    }

    @Override
    public class_2487 method_16887() {
        class_2487 updateTag = super.method_16887();
        ArrayList<Integer> sc = new ArrayList<Integer>();
        InventoryHandler inventoryHandler = this.getStorageWrapper().getInventoryHandler();
        for (int slot = 0; slot < inventoryHandler.getSlotCount(); ++slot) {
            class_1799 stack = inventoryHandler.getStackInSlot(slot);
            sc.add(slot, stack.method_7947());
        }
        updateTag.method_10572(SLOT_COUNTS_TAG, sc);
        return updateTag;
    }

    @Override
    public void loadSynchronizedData(class_2487 tag) {
        super.loadSynchronizedData(tag);
        if (tag.method_10545(SLOT_COUNTS_TAG)) {
            int[] countsArray = tag.method_10561(SLOT_COUNTS_TAG);
            if (this.slotCounts.size() != countsArray.length) {
                this.slotCounts.clear();
                for (int i = 0; i < countsArray.length; ++i) {
                    this.slotCounts.add(i, countsArray[i]);
                }
            } else {
                for (int i = 0; i < countsArray.length; ++i) {
                    this.slotCounts.set(i, countsArray[i]);
                }
            }
        }
        this.showCounts = NBTHelper.getBoolean((class_2487)tag, (String)"showCounts").orElse(true);
        this.slotColors = NBTHelper.getMap((class_2487)tag, (String)"slotColors", Integer::valueOf, (tagName, t) -> Optional.of(class_1767.method_7791((int)((class_2497)t).method_10701()))).orElseGet(HashMap::new);
    }

    @Override
    protected void saveSynchronizedData(class_2487 tag) {
        super.saveSynchronizedData(tag);
        if (!this.showCounts) {
            tag.method_10556("showCounts", this.showCounts);
        }
        if (!this.slotColors.isEmpty()) {
            NBTHelper.putMap((class_2487)tag, (String)"slotColors", this.slotColors, String::valueOf, color -> class_2497.method_23247((int)color.method_7789()));
        }
    }
}

