/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.BlockBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ISneakItemInteractionBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class StorageBlockBase
extends BlockBase
implements IStorageBlock,
ISneakItemInteractionBlock,
class_2343 {
    public static final class_2746 TICKING = class_2746.method_11825((String)"ticking");
    protected final Supplier<Integer> numberOfInventorySlotsSupplier;
    protected final Supplier<Integer> numberOfUpgradeSlotsSupplier;

    protected StorageBlockBase(class_4970.class_2251 properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties);
        this.numberOfInventorySlotsSupplier = numberOfInventorySlotsSupplier;
        this.numberOfUpgradeSlotsSupplier = numberOfUpgradeSlotsSupplier;
    }

    public abstract StorageBlockEntity newBlockEntity(class_2338 var1, class_2680 var2);

    public void addCreativeTabItems(Consumer<class_1799> itemConsumer) {
        itemConsumer.accept(new class_1799((class_1935)this));
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> createTickerHelper(class_2591<A> typePassedIn, class_2591<E> typeExpected, class_5558<? super E> blockEntityTicker) {
        return typeExpected == typePassedIn ? blockEntityTicker : null;
    }

    protected static void renderUpgrades(class_1937 level, class_5819 rand, class_2338 pos, class_2350 facing, RenderInfo renderInfo) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        HashMap<UpgradeRenderDataType, IUpgradeRenderData> upgradeRenderData = new HashMap<UpgradeRenderDataType, IUpgradeRenderData>(renderInfo.getUpgradeRenderData());
        upgradeRenderData.forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> StorageBlockBase.renderUpgrade(renderer, level, rand, pos, facing, type, data)));
    }

    private static Vector3f getMiddleFacePoint(class_2338 pos, class_2350 facing, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        point.add(0.0f, 0.0f, 0.6f);
        point.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
        point.rotate((Quaternionfc)facing.method_23224());
        point.add((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f);
        return point;
    }

    private static <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, class_1937 level, class_5819 rand, class_2338 pos, class_2350 facing, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(level, rand, vector -> StorageBlockBase.getMiddleFacePoint(pos, facing, vector), renderData));
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        if (!world.field_9236 && entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            WorldHelper.getBlockEntity((class_1922)world, (class_2338)pos, StorageBlockEntity.class).ifPresent(te -> this.tryToPickup(world, itemEntity, te.getStorageWrapper()));
        }
    }

    private void tryToPickup(class_1937 world, class_1542 itemEntity, IStorageWrapper w) {
        class_1799 remainingStack = itemEntity.method_6983().method_7972();
        try (Transaction ctx = Transaction.openOuter();){
            remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((class_1937)world, (UpgradeHandler)w.getUpgradeHandler(), (class_1799)remainingStack, (TransactionContext)ctx);
            ctx.commit();
        }
        if (remainingStack.method_7947() < itemEntity.method_6983().method_7947()) {
            itemEntity.method_6979(remainingStack);
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return !level.field_9236 && Boolean.TRUE.equals(state.method_11654((class_2769)TICKING)) ? StorageBlockBase.createTickerHelper(blockEntityType, this.getBlockEntityType(), (l, blockPos, blockState, storageBlockEntity) -> StorageBlockEntity.serverTick(l, blockPos, storageBlockEntity)) : null;
    }

    protected abstract class_2591<? extends StorageBlockEntity> getBlockEntityType();

    @Override
    public int getNumberOfInventorySlots() {
        return this.numberOfInventorySlotsSupplier.get();
    }

    @Override
    public int getNumberOfUpgradeSlots() {
        return this.numberOfUpgradeSlotsSupplier.get();
    }

    @Override
    public void setTicking(class_1937 level, class_2338 pos, class_2680 currentState, boolean ticking) {
        level.method_8501(pos, (class_2680)currentState.method_11657((class_2769)TICKING, (Comparable)Boolean.valueOf(ticking)));
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 pos) {
        return WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).map(be -> InventoryHelper.getAnalogOutputSignal((ITrackedContentsItemHandler)be.getStorageWrapper().getInventoryForInputOutput())).orElse(0);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).ifPresent(b -> {
                b.removeFromController();
                if (b.shouldDropContents()) {
                    b.dropContents();
                }
                level.method_8455(pos, (class_2248)this);
            });
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    public void method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        super.method_9576(pLevel, pPos, pState, pPlayer);
        WorldHelper.getBlockEntity((class_1922)pLevel, (class_2338)pPos, StorageBlockEntity.class).ifPresent(IControllableStorage::removeFromController);
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 rand) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).ifPresent(be -> {
            RenderInfo renderInfo = be.getStorageWrapper().getRenderInfo();
            StorageBlockBase.renderUpgrades(level, rand, pos, this.getFacing(state), renderInfo);
        });
    }

    public VerticalFacing getVerticalFacing(class_2680 state) {
        class_2350 facing = this.getFacing(state);
        if (facing == class_2350.field_11036) {
            return VerticalFacing.UP;
        }
        if (facing == class_2350.field_11033) {
            return VerticalFacing.DOWN;
        }
        return VerticalFacing.NO;
    }

    public class_2350 getHorizontalDirection(class_2680 state) {
        class_2350 facing = this.getFacing(state);
        if (facing == class_2350.field_11036) {
            return class_2350.field_11043;
        }
        if (facing == class_2350.field_11033) {
            return class_2350.field_11035;
        }
        return facing;
    }

    public abstract class_2350 getFacing(class_2680 var1);

    public int getDisplayItemsCount(List<RenderInfo.DisplayItem> displayItems) {
        return displayItems.size();
    }

    public boolean hasFixedIndexDisplayItems() {
        return false;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighborBlock, class_2338 neighborPos, boolean movedByPiston) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).ifPresent(be -> be.onNeighborChange(neighborPos));
    }

    protected boolean tryAddUpgrade(class_1657 player, class_1268 hand, StorageBlockEntity b, class_1799 itemInHand, class_2350 facing, class_3965 hitResult) {
        if (player.method_37908().field_9236) {
            return true;
        }
        if (hitResult.method_17780() != facing) {
            return false;
        }
        return this.tryAddSingleUpgrade(player, hand, b, itemInHand);
    }

    private static boolean isStorageUpgrade(class_1799 itemInHand) {
        UpgradeItemBase upgradeItem;
        class_1792 class_17922 = itemInHand.method_7909();
        return class_17922 instanceof UpgradeItemBase && RegistryHelper.getRegistryName((class_2378)class_7923.field_41178, (Object)(upgradeItem = (UpgradeItemBase)class_17922)).map(r -> r.method_12836().equals("sophisticatedstorage")).orElse(false) != false;
    }

    public boolean tryAddSingleUpgrade(class_1657 player, class_1268 hand, StorageBlockEntity b, class_1799 itemInHand) {
        ItemVariant resource;
        UpgradeHandler upgradeHandler;
        if (StorageBlockBase.isStorageUpgrade(itemInHand) && InventoryHelper.simulateInsertIntoInventory((SlottedStackStorage)(upgradeHandler = b.getStorageWrapper().getUpgradeHandler()), (ItemVariant)(resource = ItemVariant.of((class_1799)itemInHand)), (long)1L, null).method_7947() != 0) {
            try (Transaction ctx = Transaction.openOuter();){
                InventoryHelper.insertIntoInventory((SlottedStackStorage)upgradeHandler, (ItemVariant)resource, (long)1L, (TransactionContext)ctx);
                ctx.commit();
            }
            itemInHand.method_7934(1);
            if (itemInHand.method_7960()) {
                player.method_6122(hand, class_1799.field_8037);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean trySneakItemInteraction(class_1657 player, class_1268 hand, class_2680 state, class_1937 level, class_2338 pos, class_3965 hitVec, class_1799 itemInHand) {
        if (level.method_8608() || hitVec.method_17780() != this.getFacing(state)) {
            return false;
        }
        return this.tryFillUpgrades(player, hand, level, pos, itemInHand);
    }

    public boolean tryFillUpgrades(class_1657 player, class_1268 hand, class_1937 level, class_2338 pos, class_1799 itemInHand) {
        return WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, StorageBlockEntity.class).map(b -> {
            boolean result = false;
            while (!itemInHand.method_7960() && this.tryAddSingleUpgrade(player, hand, (StorageBlockEntity)b, itemInHand)) {
                result = true;
            }
            return result;
        }).orElse(false);
    }
}

