/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class WoodStorageBlockBase
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final Map<class_4719, class_5794> CUSTOM_TEXTURE_WOOD_TYPES = Map.of(class_4719.field_21679, class_5793.field_28500, class_4719.field_21678, class_5793.field_28501, class_4719.field_22183, class_5793.field_28502, class_4719.field_21681, class_5793.field_28505, class_4719.field_21680, class_5793.field_28503, class_4719.field_21676, class_5793.field_28504, class_4719.field_21677, class_5793.field_28506, class_4719.field_22184, class_5793.field_28507, class_4719.field_37657, class_5793.field_38007);

    protected WoodStorageBlockBase(class_4970.class_2251 properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties, numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
    }

    public void addNameWoodAndTintData(class_1799 stack, class_1922 level, class_2338 pos) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, WoodStorageBlockEntity.class).ifPresent(be -> this.addNameWoodAndTintData(stack, (WoodStorageBlockEntity)be));
    }

    @Override
    public void addDropData(class_1799 stack, StorageBlockEntity be) {
        if (be instanceof WoodStorageBlockEntity) {
            WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)be;
            this.addNameWoodAndTintData(stack, wbe);
            if (wbe.isPacked()) {
                StorageWrapper storageWrapper = be.getStorageWrapper();
                UUID storageUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
                class_2487 storageContents = wbe.getStorageContentsTag();
                if (!storageContents.method_33133()) {
                    ItemContentsStorage.get().setStorageContents(storageUuid, storageContents);
                    NBTHelper.setUniqueId((class_1799)stack, (String)"uuid", (UUID)storageUuid);
                }
                WoodStorageBlockItem.setPacked(stack, true);
                StorageBlockItem.setShowsTier(stack, be.shouldShowTier());
            }
        }
    }

    private void addNameWoodAndTintData(class_1799 stack, WoodStorageBlockEntity wbe) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ITintableBlockItem) {
            int accentColor;
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
            int mainColor = wbe.getStorageWrapper().getMainColor();
            if (mainColor > -1) {
                tintableBlockItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = wbe.getStorageWrapper().getAccentColor()) > -1) {
                tintableBlockItem.setAccentColor(stack, accentColor);
            }
        }
        if (wbe.method_16914()) {
            stack.method_7977(wbe.method_5797());
        }
        wbe.getWoodType().ifPresent(n -> WoodStorageBlockItem.setWoodType(stack, n));
    }

    @Override
    public void addCreativeTabItems(Consumer<class_1799> itemConsumer) {
        CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> itemConsumer.accept(WoodStorageBlockItem.setWoodType(new class_1799((class_1935)this), woodType)));
        if (this.isBasicTier() || Boolean.TRUE.equals(Config.CLIENT.showHigherTierTintedVariants.get())) {
            for (class_1767 color : class_1767.values()) {
                class_1799 storageStack = new class_1799((class_1935)this);
                class_1792 class_17922 = storageStack.method_7909();
                if (class_17922 instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
                    tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])color.method_7787()));
                    tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])color.method_7787()));
                }
                itemConsumer.accept(storageStack);
            }
            class_1799 storageStack = new class_1799((class_1935)this);
            class_1792 class_17923 = storageStack.method_7909();
            if (class_17923 instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17923;
                tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])class_1767.field_7947.method_7787()));
                tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])class_1767.field_7961.method_7787()));
            }
            itemConsumer.accept(storageStack);
        }
    }

    private boolean isBasicTier() {
        return this == ModBlocks.BARREL || this == ModBlocks.CHEST || this == ModBlocks.LIMITED_BARREL_1 || this == ModBlocks.LIMITED_BARREL_2 || this == ModBlocks.LIMITED_BARREL_3 || this == ModBlocks.LIMITED_BARREL_4;
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_1799 stack = new class_1799((class_1935)this);
        this.addNameWoodAndTintData(stack, level, pos);
        return stack;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, WoodStorageBlockEntity.class).ifPresent(be -> {
            NBTHelper.getUniqueId((class_1799)stack, (String)"uuid").ifPresent(uuid -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                be.method_11014(itemContentsStorage.getOrCreateStorageContents((UUID)uuid));
                itemContentsStorage.removeStorageContents((UUID)uuid);
            });
            if (stack.method_7938()) {
                be.setCustomName(stack.method_7964());
            }
            WoodStorageBlockItem.getWoodType(stack).ifPresent(be::setWoodType);
            StorageBlockItem.getMainColorFromStack(stack).ifPresent(be.getStorageWrapper()::setMainColor);
            StorageBlockItem.getAccentColorFromStack(stack).ifPresent(be.getStorageWrapper()::setAccentColor);
            be.getStorageWrapper().onInit();
            be.tryToAddToController();
            if (placer != null && placer.method_6079().method_7909() == ModItems.STORAGE_TOOL) {
                StorageToolItem.useOffHandOnPlaced(placer.method_6079(), be);
            }
        });
    }

    protected boolean tryItemInteraction(class_1657 player, class_1268 hand, WoodStorageBlockEntity b, class_1799 stackInHand, class_2350 facing, class_3965 hitResult) {
        if (stackInHand.method_7909() == ModItems.PACKING_TAPE) {
            WoodStorageBlockBase.packStorage(player, hand, b, stackInHand);
            return true;
        }
        return this.tryAddUpgrade(player, hand, b, stackInHand, facing, hitResult);
    }

    private static void packStorage(class_1657 player, class_1268 hand, WoodStorageBlockEntity b, class_1799 stackInHand) {
        if (!player.method_7337()) {
            stackInHand.method_7974(stackInHand.method_7919() + 1);
            if (stackInHand.method_7919() >= stackInHand.method_7936()) {
                player.method_6122(hand, class_1799.field_8037);
            }
        }
        b.setPacked(true);
        b.removeFromController();
        WorldHelper.notifyBlockUpdate((class_2586)b);
    }
}

