/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client;

import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.RegisterGeometryLoadersCallback;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3675;
import net.minecraft.class_3695;
import net.minecraft.class_437;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.p3pp3rf1y.sophisticatedcore.event.client.ClientLifecycleEvent;
import net.p3pp3rf1y.sophisticatedcore.event.client.ClientRawInputEvent;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleIdentifiablePrepareableReloadListener;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.ToolInfoOverlay;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModItemColors;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ClientStorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ControllerRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LimitedBarrelDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LimitedBarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.SimpleCompositeModel;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.mixin.client.accessor.MultiPlayerGameModeAccessor;
import net.p3pp3rf1y.sophisticatedstorage.network.ScrolledToolMessage;
import net.p3pp3rf1y.sophisticatedstorage.network.StoragePacketHandler;

public class ClientEventHandler {
    private static final String KEYBIND_SOPHISTICATEDSTORAGE_CATEGORY = "keybind.sophisticatedstorage.category";
    private static final int MIDDLE_BUTTON = 2;
    public static final class_304 SORT_KEYBIND = new class_304(StorageTranslationHelper.INSTANCE.translKeybind("sort"), class_3675.class_307.field_1672, 2, "keybind.sophisticatedstorage.category");
    private static final class_2960 CHEST_RL = new class_2960("sophisticatedstorage", "chest");
    public static final class_5601 CHEST_LAYER = new class_5601(CHEST_RL, "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        RegisterGeometryLoadersCallback.EVENT.register(ClientEventHandler::onModelRegistry);
        ClientEventHandler.registerLayer();
        ClientEventHandler.registerTooltipComponent();
        ClientEventHandler.registerOverlay();
        ClientEventHandler.registerEntityRenderers();
        ClientEventHandler.registerItemRenderers();
        ClientEventHandler.registerKeyMappings();
        ClientEventHandler.registerStorageLayerLoader();
        ClientEventHandler.onRegisterReloadListeners();
        PreparableModelLoadingPlugin.register((resourceManager, executor) -> CompletableFuture.completedFuture(resourceManager), (resourceManager, context) -> ClientEventHandler.onRegisterAdditionalModels(resourceManager, xva$0 -> context.addModels(new class_2960[]{xva$0})));
        ModParticles.registerProviders();
        ModItemColors.registerItemColorHandlers();
        ModBlockColors.registerBlockColorHandlers();
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(ClientStorageContentsTooltip::onWorldLoad);
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            ScreenKeyboardEvents.allowKeyPress((class_437)screen).register(ClientEventHandler::handleGuiKeyPress);
            ScreenMouseEvents.allowMouseClick((class_437)screen).register(ClientEventHandler::handleGuiMouseKeyPress);
        });
        AttackBlockCallback.EVENT.register(ClientEventHandler::onLimitedBarrelClicked);
        ClientRawInputEvent.MOUSE_SCROLLED.register(ClientEventHandler::onMouseScrolled);
    }

    private static void onRegisterAdditionalModels(class_3300 manager, Consumer<class_2960> out) {
        ClientEventHandler.addBarrelPartModelsToBake(manager, out);
    }

    private static void addBarrelPartModelsToBake(class_3300 manager, Consumer<class_2960> out) {
        Map models = manager.method_14488("models/block/barrel_part", fileName -> fileName.method_12832().endsWith(".json"));
        models.forEach((modelName, resource) -> {
            if (modelName.method_12836().equals("sophisticatedstorage")) {
                out.accept(new class_2960(modelName.method_12836(), modelName.method_12832().substring("models/".length()).replace(".json", "")));
            }
        });
    }

    private static class_1269 onMouseScrolled(class_310 mc, double delta) {
        if (mc.field_1755 != null) {
            return class_1269.field_5811;
        }
        class_746 player = mc.field_1724;
        if (player == null || !player.method_5715()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_6047();
        if (stack.method_7909() != ModItems.STORAGE_TOOL) {
            return class_1269.field_5811;
        }
        StoragePacketHandler.sendToServer((Object)new ScrolledToolMessage(delta > 0.0));
        return class_1269.field_5812;
    }

    private static class_1269 onLimitedBarrelClicked(class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, class_2350 direction) {
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof LimitedBarrelBlock)) {
            return class_1269.field_5811;
        }
        LimitedBarrelBlock limitedBarrel = (LimitedBarrelBlock)class_22482;
        if (limitedBarrel.isLookingAtFront(player, pos, state)) {
            if (player.method_7337()) {
                return class_1269.field_5812;
            }
            if (player.method_7351(state) < 2.0f) {
                ((MultiPlayerGameModeAccessor)class_310.method_1551().field_1761).setDestroyDelay(5);
                state.method_26204().method_9606(state, level, pos, player);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static boolean handleGuiKeyPress(class_437 screen, int key, int scancode, int modifiers) {
        return !SORT_KEYBIND.method_1434() || !ClientEventHandler.tryCallSort(screen);
    }

    public static boolean handleGuiMouseKeyPress(class_437 screen, double mouseX, double mouseY, int button) {
        return !SORT_KEYBIND.method_1433(button) || !ClientEventHandler.tryCallSort(screen);
    }

    private static void registerStorageLayerLoader() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)StorageTextureManager.INSTANCE);
    }

    private static boolean tryCallSort(class_437 gui) {
        class_1703 class_17032;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && (class_17032 = mc.field_1724.field_7512) instanceof StorageContainerMenu) {
            double mouseY;
            class_312 mh;
            double mouseX;
            StorageScreen screen;
            class_1735 selectedSlot;
            StorageContainerMenu container = (StorageContainerMenu)class_17032;
            if (gui instanceof StorageScreen && (selectedSlot = (screen = (StorageScreen)gui).method_2386(mouseX = (mh = mc.field_1729).method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480(), mouseY = mh.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507())) != null && container.isNotPlayersInventorySlot(selectedSlot.field_7874)) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static void onModelRegistry(Map<class_2960, IGeometryLoader<?>> loaders) {
        loaders.put(SophisticatedStorage.getRL("barrel"), BarrelDynamicModel.Loader.INSTANCE);
        loaders.put(SophisticatedStorage.getRL("limited_barrel"), LimitedBarrelDynamicModel.Loader.INSTANCE);
        loaders.put(SophisticatedStorage.getRL("chest"), ChestDynamicModel.Loader.INSTANCE);
        loaders.put(SophisticatedStorage.getRL("shulker_box"), ShulkerBoxDynamicModel.Loader.INSTANCE);
        loaders.put(SophisticatedStorage.getRL("simple_composite"), SimpleCompositeModel.Loader.INSTANCE);
    }

    private static void onRegisterReloadListeners() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleIdentifiablePrepareableReloadListener<Object>(SophisticatedStorage.getRL("main")){

            protected void method_18788(Object object, class_3300 resourceManager, class_3695 profiler) {
                BarrelDynamicModelBase.invalidateCache();
                BarrelBakedModelBase.invalidateCache();
            }
        });
    }

    public static void registerLayer() {
        EntityModelLayerRegistry.registerModelLayer((class_5601)CHEST_LAYER, () -> ChestRenderer.createSingleBodyLayer(true));
    }

    private static void registerKeyMappings() {
        KeyBindingHelper.registerKeyBinding((class_304)SORT_KEYBIND);
    }

    private static void registerTooltipComponent() {
        TooltipComponentCallback.EVENT.register(ClientEventHandler::registerTooltipComponent);
    }

    @Nullable
    private static class_5684 registerTooltipComponent(class_5632 data) {
        if (data instanceof StorageContentsTooltip) {
            StorageContentsTooltip storageContentsTooltip = (StorageContentsTooltip)data;
            return new ClientStorageContentsTooltip(storageContentsTooltip);
        }
        return null;
    }

    private static void registerOverlay() {
        HudRenderCallback.EVENT.register((Object)ToolInfoOverlay.HUD_TOOL_INFO);
    }

    private static void registerEntityRenderers() {
        class_5616.method_32144(ModBlocks.BARREL_BLOCK_ENTITY_TYPE, context -> new BarrelRenderer());
        class_5616.method_32144(ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE, context -> new LimitedBarrelRenderer());
        class_5616.method_32144(ModBlocks.CHEST_BLOCK_ENTITY_TYPE, ChestRenderer::new);
        class_5616.method_32144(ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE, ShulkerBoxRenderer::new);
        class_5616.method_32144(ModBlocks.CONTROLLER_BLOCK_ENTITY_TYPE, context -> new ControllerRenderer());
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), ModBlocks.getBlocksByPredicate((id, block) -> id.method_12832().contains("barrel")).toArray(new class_2248[0]));
    }

    private static void registerItemRenderers() {
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.CHEST_ITEM, ChestItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.IRON_CHEST_ITEM, ChestItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.GOLD_CHEST_ITEM, ChestItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.DIAMOND_CHEST_ITEM, ChestItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.NETHERITE_CHEST_ITEM, ChestItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.SHULKER_BOX_ITEM, ShulkerBoxItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.IRON_SHULKER_BOX_ITEM, ShulkerBoxItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.GOLD_SHULKER_BOX_ITEM, ShulkerBoxItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.DIAMOND_SHULKER_BOX_ITEM, ShulkerBoxItemRenderer::render);
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)ModBlocks.NETHERITE_SHULKER_BOX_ITEM, ShulkerBoxItemRenderer::render);
    }
}

