/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4719;
import net.minecraft.class_4730;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ChestRenderer
extends StorageRenderer<ChestBlockEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final class_630 lidPart;
    private final class_630 bottomPart;
    private final class_630 lockPart;
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.4378125, new class_243(-0.0625, 0.0, -0.0075));

    public ChestRenderer(class_5614.class_5615 context) {
        class_630 modelpart = context.method_32140(ClientEventHandler.CHEST_LAYER);
        this.bottomPart = modelpart.method_32086(BOTTOM);
        this.lidPart = modelpart.method_32086(LID);
        this.lockPart = modelpart.method_32086(LOCK);
    }

    public static class_5607 createSingleBodyLayer(boolean addLock) {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();
        partdefinition.method_32117(BOTTOM, class_5606.method_32108().method_32101(0, 19).method_32097(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), class_5603.field_27701);
        partdefinition.method_32117(LID, class_5606.method_32108().method_32101(0, 0).method_32097(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), class_5603.method_32090((float)0.0f, (float)9.0f, (float)1.0f));
        if (addLock) {
            partdefinition.method_32117(LOCK, class_5606.method_32108().method_32101(0, 0).method_32097(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), class_5603.method_32090((float)0.0f, (float)8.0f, (float)0.0f));
        }
        return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)64);
    }

    public void render(ChestBlockEntity chestEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_4588 vertexconsumer;
        class_2680 blockstate = chestEntity.method_11010();
        StorageTextureManager matManager = StorageTextureManager.INSTANCE;
        Optional<class_4719> woodType = chestEntity.getWoodType();
        Map<StorageTextureManager.ChestMaterial, class_4730> chestMaterials = matManager.getWoodChestMaterials(woodType.orElse(class_4719.field_21679));
        if (chestMaterials == null) {
            return;
        }
        poseStack.method_22903();
        class_2350 facing = (class_2350)blockstate.method_11654((class_2769)ChestBlock.FACING);
        float f = facing.method_10144();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-f));
        poseStack.method_22904(-0.5, -0.5, -0.5);
        float lidAngle = chestEntity.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle;
        float finalLidAngle = lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        StorageWrapper storageWrapper = chestEntity.getStorageWrapper();
        boolean hasMainColor = storageWrapper.hasMainColor();
        boolean hasAccentColor = storageWrapper.hasAccentColor();
        if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
            vertexconsumer = chestMaterials.get((Object)StorageTextureManager.ChestMaterial.BASE).method_24145(bufferSource, class_1921::method_23576);
            this.renderBottomAndLid(poseStack, vertexconsumer, finalLidAngle, packedLight, packedOverlay);
        }
        if (hasMainColor) {
            vertexconsumer = chestMaterials.get((Object)StorageTextureManager.ChestMaterial.TINTABLE_MAIN).method_24145(bufferSource, class_1921::method_23576);
            this.renderBottomAndLidWithTint(poseStack, vertexconsumer, lidAngle, packedLight, packedOverlay, storageWrapper.getMainColor());
        }
        if (hasAccentColor) {
            vertexconsumer = chestMaterials.get((Object)StorageTextureManager.ChestMaterial.TINTABLE_ACCENT).method_24145(bufferSource, class_1921::method_23576);
            this.renderBottomAndLidWithTint(poseStack, vertexconsumer, lidAngle, packedLight, packedOverlay, storageWrapper.getAccentColor());
        }
        class_4730 tierMaterial = this.getTierMaterial(chestMaterials, blockstate.method_26204());
        class_4588 vertexconsumer2 = tierMaterial.method_24145(bufferSource, class_1921::method_23576);
        if (chestEntity.shouldShowTier()) {
            this.renderBottomAndLid(poseStack, vertexconsumer2, lidAngle, packedLight, packedOverlay);
        } else if (this.holdsItemThatShowsHiddenTiers()) {
            this.renderHiddenTier(poseStack, bufferSource, packedLight, packedOverlay, tierMaterial);
        }
        if (storageWrapper.getRenderInfo().getItemDisplayRenderInfo().getDisplayItem().isEmpty()) {
            this.renderChestLock(poseStack, vertexconsumer2, lidAngle, packedLight, packedOverlay);
        }
        poseStack.method_22909();
        if (chestEntity.isPacked()) {
            class_4588 consumer = chestMaterials.get((Object)StorageTextureManager.ChestMaterial.PACKED).method_24145(bufferSource, class_1921::method_23576);
            poseStack.method_22903();
            poseStack.method_22904(-0.005, -0.005, -0.005);
            poseStack.method_22905(1.01f, 1.01f, 1.01f);
            this.renderBottomAndLid(poseStack, consumer, finalLidAngle, packedLight, packedOverlay);
            poseStack.method_22909();
        } else if (this.shouldRenderFrontFace(chestEntity.method_11016())) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(DisplayItemRenderer.getNorthBasedRotation(facing));
            poseStack.method_22904(-0.5, -0.5, -0.4375);
            LockRenderer.renderLock(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, 0.8125f, this::holdsToolInToggleLockOrLockDisplay);
            if (chestEntity.shouldShowUpgrades() || this.holdsItemThatShowsUpgrades()) {
                this.displayItemRenderer.renderUpgradeItems(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(chestEntity));
            }
            this.displayItemRenderer.renderDisplayItem(chestEntity, poseStack, bufferSource, packedLight, packedOverlay);
            poseStack.method_22909();
        }
    }

    private void renderHiddenTier(class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_4730 tierMaterial) {
        class_1058 sprite = tierMaterial.method_24148();
        class_4588 translucentConsumer = sprite.method_24108(bufferSource.getBuffer(class_1921.method_23580((class_2960)sprite.method_45852())));
        poseStack.method_22903();
        poseStack.method_22904(-0.005, -0.005, -0.005);
        poseStack.method_22905(1.01f, 1.01f, 1.01f);
        this.lidPart.method_22699(poseStack, translucentConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.5f);
        this.bottomPart.method_22699(poseStack, translucentConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.5f);
        poseStack.method_22909();
    }

    private boolean shouldRenderFrontFace(class_2338 chestPos) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        return class_243.method_24953((class_2382)chestPos).method_24802((class_2374)camera.method_19326(), 32.0);
    }

    private void renderBottomAndLid(class_4587 poseStack, class_4588 consumer, float lidAngle, int packedLight, int packedOverlay) {
        this.lidPart.field_3654 = -(lidAngle * 1.5707964f);
        this.lidPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
        this.bottomPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
    }

    private void renderBottomAndLidWithTint(class_4587 poseStack, class_4588 consumer, float lidAngle, int packedLight, int packedOverlay, int tint) {
        float tintRed = (float)(tint >> 16 & 0xFF) / 255.0f;
        float tingGreen = (float)(tint >> 8 & 0xFF) / 255.0f;
        float tintBlue = (float)(tint & 0xFF) / 255.0f;
        this.lidPart.field_3654 = -(lidAngle * 1.5707964f);
        this.lidPart.method_22699(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
        this.bottomPart.method_22699(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
    }

    private void renderChestLock(class_4587 poseStack, class_4588 consumer, float lidAngle, int packedLight, int packedOverlay) {
        this.lockPart.field_3654 = -(lidAngle * 1.5707964f);
        this.lockPart.method_22698(poseStack, consumer, packedLight, packedOverlay);
    }

    private class_4730 getTierMaterial(Map<StorageTextureManager.ChestMaterial, class_4730> chestMaterials, class_2248 block) {
        if (block == ModBlocks.IRON_CHEST) {
            return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.IRON_TIER);
        }
        if (block == ModBlocks.GOLD_CHEST) {
            return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.GOLD_TIER);
        }
        if (block == ModBlocks.DIAMOND_CHEST) {
            return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.DIAMOND_TIER);
        }
        if (block == ModBlocks.NETHERITE_CHEST) {
            return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.NETHERITE_TIER);
        }
        return chestMaterials.get((Object)StorageTextureManager.ChestMaterial.WOOD_TIER);
    }
}

