/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import org.joml.Vector3f;

public class LimitedBarrelRenderer
extends BarrelRenderer<LimitedBarrelBlockEntity> {
    private static final float MULTIPLE_ITEMS_FONT_SCALE = 0.010416667f;
    private static final float SINGLE_ITEM_FONT_SCALE = 0.020833334f;
    private static final class_2583 COUNT_DISPLAY_STYLE = class_2583.field_24360.method_27704(class_310.field_24211).method_10982(Boolean.valueOf(true));
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new class_243(0.0, 0.0, -0.0625));
    private final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, class_243.field_1353);

    @Override
    public void render(LimitedBarrelBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_2680 blockState = blockEntity.method_11010();
        if (blockEntity.isPacked() || !(blockState.method_26204() instanceof StorageBlockBase) || !blockEntity.hasDynamicRenderer() && !blockEntity.shouldShowCounts() && !this.holdsItemThatShowsUpgrades() && !blockEntity.shouldShowUpgrades()) {
            return;
        }
        boolean flatTop = (Boolean)blockState.method_11654((class_2769)BarrelBlock.FLAT_TOP);
        class_2350 horizontalFacing = (class_2350)blockState.method_11654((class_2769)LimitedBarrelBlock.HORIZONTAL_FACING);
        this.renderItemCounts(blockEntity, poseStack, bufferSource, packedLight, flatTop, horizontalFacing, (VerticalFacing)((Object)blockState.method_11654(LimitedBarrelBlock.VERTICAL_FACING)));
        this.renderFrontFace(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, blockState, flatTop, horizontalFacing);
        this.renderHiddenTier(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderHiddenLock(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderFrontFace(LimitedBarrelBlockEntity blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_2680 blockState, boolean flatTop, class_2350 horizontalFacing) {
        if (blockEntity.hasDynamicRenderer() || this.holdsItemThatShowsUpgrades() || blockEntity.shouldShowUpgrades()) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.5, 0.5);
            poseStack.method_22907(DisplayItemRenderer.getNorthBasedRotation(horizontalFacing));
            VerticalFacing verticalFacing = (VerticalFacing)((Object)blockState.method_11654(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != VerticalFacing.NO) {
                poseStack.method_22907(DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection()));
            }
            poseStack.method_22904(-0.5, -0.5, -(0.5 - (double)(flatTop ? 0.0f : 0.0625f)));
            if (blockEntity.hasDynamicRenderer()) {
                this.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop);
            }
            boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
            if (blockEntity.shouldShowUpgrades() || holdsItemThatShowsUpgrades) {
                this.renderUpgrades(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop, holdsItemThatShowsUpgrades);
            }
            poseStack.method_22909();
        }
    }

    private void renderUpgrades(LimitedBarrelBlockEntity blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, boolean flatTop, boolean holdsItemThatShowsUpgrades) {
        if (flatTop) {
            this.flatDisplayItemRenderer.renderUpgradeItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
        } else {
            this.displayItemRenderer.renderUpgradeItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(blockEntity));
        }
    }

    private void renderDisplayItems(LimitedBarrelBlockEntity blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, boolean flatTop) {
        if (flatTop) {
            this.flatDisplayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        } else {
            this.displayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        }
    }

    private void renderItemCounts(LimitedBarrelBlockEntity blockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, boolean flatTop, class_2350 horizontalFacing, VerticalFacing verticalFacing) {
        if (!blockEntity.shouldShowCounts()) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(DisplayItemRenderer.getNorthBasedRotation(horizontalFacing.method_10153()));
        if (verticalFacing != VerticalFacing.NO) {
            poseStack.method_22907(DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection().method_10153()));
        }
        poseStack.method_22904(0.5, -0.5, 0.5);
        List<Integer> slotCounts = blockEntity.getSlotCounts();
        float countDisplayYOffset = -(slotCounts.size() == 1 ? 0.25f : 0.11f);
        for (int displayItemIndex = 0; displayItemIndex < slotCounts.size(); ++displayItemIndex) {
            int count = slotCounts.get(displayItemIndex);
            if (count <= 0) continue;
            poseStack.method_22903();
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, slotCounts.size());
            double xTranslation = -frontOffset.x();
            float yTranslation = frontOffset.y() + countDisplayYOffset;
            double zTranslation = 0.001 - (flatTop ? 0.0 : 0.046875);
            poseStack.method_22904(xTranslation, (double)yTranslation, zTranslation);
            float scale = slotCounts.size() == 1 ? 0.020833334f : 0.010416667f;
            poseStack.method_22905(scale, -scale, scale);
            class_5250 countString = class_2561.method_43470((String)CountAbbreviator.abbreviate((int)count, (int)(slotCounts.size() == 1 ? 6 : 5))).method_27696(COUNT_DISPLAY_STYLE);
            class_327 font = class_310.method_1551().field_1772;
            float countDisplayXOffset = -font.method_27527().method_27488((class_5348)countString) / 2.0f;
            poseStack.method_46416(countDisplayXOffset, 0.0f, 0.0f);
            font.method_30882((class_2561)countString, 0.0f, 0.0f, blockEntity.getSlotColor(displayItemIndex), false, poseStack.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33993, 0, packedLight);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }
}

