/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common;

import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class CapabilityStorageWrapper {
    public static final ItemApiLookup<StorageWrapper, Void> STORAGE_WRAPPER_CAPABILITY = ItemApiLookup.get((class_2960)SophisticatedStorage.getRL("storage_wrapper"), StorageWrapper.class, Void.class);
    private static final Map<class_1799, StorageWrapper> cachedStorageWrappers = new MapMaker().weakKeys().weakValues().makeMap();

    public static Optional<StorageWrapper> get(class_1799 provider) {
        return Optional.ofNullable((StorageWrapper)STORAGE_WRAPPER_CAPABILITY.find(provider, null));
    }

    public static void invalidateCache(UUID uuid) {
        Set<Map.Entry<class_1799, StorageWrapper>> entries = cachedStorageWrappers.entrySet();
        entries.stream().filter(entry -> ((StorageWrapper)entry.getValue()).getContentsUuid().isPresent() && ((StorageWrapper)entry.getValue()).getContentsUuid().get() == uuid).forEach(entries::remove);
    }

    public static void register() {
        ItemStorage.SIDED.registerForBlockEntities((be, dir) -> (Storage)((StorageBlockEntity)be).getCapability(ItemStorage.SIDED, dir), new class_2591[]{ModBlocks.BARREL_BLOCK_ENTITY_TYPE, ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE, ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE, ModBlocks.CHEST_BLOCK_ENTITY_TYPE});
        STORAGE_WRAPPER_CAPABILITY.registerForItems((stack, c) -> {
            if (stack.method_7947() == 1) {
                return cachedStorageWrappers.computeIfAbsent(stack, WoodStorageBlockItem::initWrapper);
            }
            return null;
        }, new class_1935[]{ModBlocks.BARREL_ITEM, ModBlocks.IRON_BARREL_ITEM, ModBlocks.GOLD_BARREL_ITEM, ModBlocks.DIAMOND_BARREL_ITEM, ModBlocks.NETHERITE_BARREL_ITEM, ModBlocks.LIMITED_BARREL_1_ITEM, ModBlocks.LIMITED_IRON_BARREL_1_ITEM, ModBlocks.LIMITED_GOLD_BARREL_1_ITEM, ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM, ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM, ModBlocks.LIMITED_BARREL_2_ITEM, ModBlocks.LIMITED_IRON_BARREL_2_ITEM, ModBlocks.LIMITED_GOLD_BARREL_2_ITEM, ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM, ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM, ModBlocks.LIMITED_BARREL_3_ITEM, ModBlocks.LIMITED_IRON_BARREL_3_ITEM, ModBlocks.LIMITED_GOLD_BARREL_3_ITEM, ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM, ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM, ModBlocks.LIMITED_BARREL_4_ITEM, ModBlocks.LIMITED_IRON_BARREL_4_ITEM, ModBlocks.LIMITED_GOLD_BARREL_4_ITEM, ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM, ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM, ModBlocks.CHEST_ITEM, ModBlocks.IRON_CHEST_ITEM, ModBlocks.GOLD_CHEST_ITEM, ModBlocks.DIAMOND_CHEST_ITEM, ModBlocks.NETHERITE_CHEST_ITEM});
        STORAGE_WRAPPER_CAPABILITY.registerForItems((stack, c) -> {
            if (stack.method_7947() == 1) {
                return cachedStorageWrappers.computeIfAbsent(stack, ShulkerBoxItem::initWrapper);
            }
            return null;
        }, new class_1935[]{ModBlocks.SHULKER_BOX_ITEM, ModBlocks.IRON_SHULKER_BOX_ITEM, ModBlocks.GOLD_SHULKER_BOX_ITEM, ModBlocks.DIAMOND_SHULKER_BOX_ITEM, ModBlocks.NETHERITE_SHULKER_BOX_ITEM});
    }
}

