/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class BarrelBlockItem
extends WoodStorageBlockItem {
    private static final String FLAT_TOP_TAG = "flatTop";
    private static final String MATERIALS_TAG = "materials";

    public BarrelBlockItem(class_2248 block) {
        this(block, new class_1792.class_1793());
    }

    public BarrelBlockItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public static void toggleFlatTop(class_1799 stack) {
        boolean flatTop = BarrelBlockItem.isFlatTop(stack);
        BarrelBlockItem.setFlatTop(stack, !flatTop);
    }

    public static void setFlatTop(class_1799 stack, boolean flatTop) {
        if (flatTop) {
            NBTHelper.setBoolean((class_1799)stack, (String)FLAT_TOP_TAG, (boolean)true);
        } else {
            NBTHelper.removeTag((class_1799)stack, (String)FLAT_TOP_TAG);
        }
    }

    public static boolean isFlatTop(class_1799 stack) {
        return NBTHelper.getBoolean((class_1799)stack, (String)FLAT_TOP_TAG).orElse(false);
    }

    public static void setMaterials(class_1799 barrel, Map<BarrelMaterial, class_2960> materials) {
        NBTHelper.putMap((class_2487)barrel.method_7948(), (String)MATERIALS_TAG, materials, BarrelMaterial::method_15434, resourceLocation -> class_2519.method_23256((String)resourceLocation.toString()));
    }

    public static Map<BarrelMaterial, class_2960> getMaterials(class_1799 barrel) {
        return NBTHelper.getMap((class_1799)barrel, (String)MATERIALS_TAG, BarrelMaterial::fromName, (bm, tag) -> Optional.of(new class_2960(tag.method_10714()))).orElse(Map.of());
    }

    public static void removeMaterials(class_1799 stack) {
        NBTHelper.removeTag((class_1799)stack, (String)MATERIALS_TAG);
    }

    @Override
    public class_2561 method_7864(class_1799 stack) {
        class_2561 name = BarrelBlockItem.getMaterials(stack).isEmpty() ? super.method_7864(stack) : BarrelBlockItem.getDisplayName(this.method_7876(), null);
        if (BarrelBlockItem.isFlatTop(stack)) {
            return name.method_27661().method_10852((class_2561)class_2561.method_43471((String)(StorageTranslationHelper.INSTANCE.translBlockTooltipKey("barrel") + ".flat_top")));
        }
        return name;
    }

    @Override
    public boolean isTintable(class_1799 stack) {
        return BarrelBlockItem.getMaterials(stack).isEmpty();
    }
}

