/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3719;
import net.minecraft.class_4719;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.mixin.common.accessor.BarrelBlockEntityAccessor;
import net.p3pp3rf1y.sophisticatedstorage.mixin.common.accessor.ChestBlockEntityAccessor;
import net.p3pp3rf1y.sophisticatedstorage.mixin.common.accessor.ShulkerBoxBlockEntityAccessor;

public class StorageTierUpgradeItem
extends ItemBase {
    private final TierUpgrade tier;
    private final boolean hasTooltip;

    public StorageTierUpgradeItem(TierUpgrade tier) {
        this(tier, false);
    }

    public StorageTierUpgradeItem(TierUpgrade tier, boolean hasTooltip) {
        super(new class_1792.class_1793());
        this.tier = tier;
        this.hasTooltip = hasTooltip;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        if (this.hasTooltip) {
            tooltipComponents.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(stack.method_7909().method_7876() + ".tooltip", null, new class_124[]{class_124.field_1063}));
        }
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
    }

    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        class_1937 level = context.method_8045();
        if (level.field_9236) {
            return class_1269.field_5811;
        }
        class_2338 pos = context.method_8037();
        class_2680 state = level.method_8320(pos);
        class_1657 player = context.method_8036();
        return this.tryUpgradeStorage(stack, level, pos, state, player);
    }

    public class_1269 tryUpgradeStorage(class_1799 stack, class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1657 player) {
        return this.tier.getBlockUpgradeDefinition(state.method_26204()).map(def -> WorldHelper.getBlockEntity((class_1922)level, (class_2338)pos, def.blockEntityClass()).map(be -> this.tryUpgradeStorage(stack, pos, level, state, (TierUpgradeDefinition)def, (class_2586)be, player)).orElse(class_1269.field_5811)).orElse(class_1269.field_5811);
    }

    public <B extends class_2586> class_1269 tryUpgradeStorage(class_1799 stack, class_2338 pos, class_1937 level, class_2680 state, TierUpgradeDefinition<B> def, class_2586 blockEntity, @Nullable class_1657 player) {
        class_2586 be = (class_2586)def.blockEntityClass().cast(blockEntity);
        if (def.isUpgradingBlocked().test(be)) {
            return class_1269.field_5811;
        }
        if (player == null) {
            return class_1269.field_5811;
        }
        if (!def.upgradeStorage(player, pos, level, state, be)) {
            return class_1269.field_5811;
        }
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        return class_1269.field_5812;
    }

    private static Map<class_2248, TierUpgradeDefinition<?>> getVanillaShulkerBoxTierUpgradeDefinitions(ShulkerBoxBlock toShulkerBox) {
        return new ImmutableMap.Builder().put((Object)class_2246.field_10603, new VanillaTierUpgradeDefinition<class_2627>(class_2627.class, shulkerBoxBlockEntity -> ((ShulkerBoxBlockEntityAccessor)shulkerBoxBlockEntity).getOpenCount() > 0, (StorageBlockBase)toShulkerBox, null, new class_2769[]{class_2480.field_11496})).put((Object)class_2246.field_10199, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7952, toShulkerBox)).put((Object)class_2246.field_10407, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7946, toShulkerBox)).put((Object)class_2246.field_10063, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7958, toShulkerBox)).put((Object)class_2246.field_10203, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7951, toShulkerBox)).put((Object)class_2246.field_10600, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7947, toShulkerBox)).put((Object)class_2246.field_10275, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7961, toShulkerBox)).put((Object)class_2246.field_10051, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7954, toShulkerBox)).put((Object)class_2246.field_10140, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7944, toShulkerBox)).put((Object)class_2246.field_10320, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7967, toShulkerBox)).put((Object)class_2246.field_10532, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7955, toShulkerBox)).put((Object)class_2246.field_10268, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7945, toShulkerBox)).put((Object)class_2246.field_10605, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7966, toShulkerBox)).put((Object)class_2246.field_10373, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7957, toShulkerBox)).put((Object)class_2246.field_10055, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7942, toShulkerBox)).put((Object)class_2246.field_10068, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7964, toShulkerBox)).put((Object)class_2246.field_10371, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767.field_7963, toShulkerBox)).build();
    }

    public static enum TierUpgrade {
        BASIC(new HashMap<class_2248, TierUpgradeDefinition<?>>((Map<class_2248, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)class_2246.field_16328, new VanillaTierUpgradeDefinition<class_3719>(class_3719.class, blockEntity -> ((BarrelBlockEntityAccessor)blockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.BARREL, class_4719.field_21677, new class_2769[]{class_2741.field_12525})).put((Object)class_2246.field_10034, new VanillaTierUpgradeDefinition<class_2595>(class_2595.class, chestBlockEntity -> ((ChestBlockEntityAccessor)chestBlockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.CHEST, class_4719.field_21676, new class_2769[]{class_2741.field_12481, class_2741.field_12508})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.SHULKER_BOX)).build())),
        BASIC_TO_IRON(new HashMap<class_2248, TierUpgradeDefinition<?>>((Map<class_2248, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)class_2246.field_16328, new VanillaTierUpgradeDefinition<class_3719>(class_3719.class, blockEntity -> ((BarrelBlockEntityAccessor)blockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.IRON_BARREL, class_4719.field_21677, new class_2769[]{class_2741.field_12525})).put((Object)class_2246.field_10034, new VanillaTierUpgradeDefinition<class_2595>(class_2595.class, chestBlockEntity -> ((ChestBlockEntityAccessor)chestBlockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.IRON_CHEST, class_4719.field_21676, new class_2769[]{class_2741.field_12481, class_2741.field_12508})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.IRON_SHULKER_BOX)).put((Object)ModBlocks.BARREL, (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)ModBlocks.CHEST, (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508})).put((Object)ModBlocks.SHULKER_BOX, (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_SHULKER_BOX, new class_2769[]{class_2741.field_12525})).put((Object)ModBlocks.LIMITED_BARREL_1, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_1)).put((Object)ModBlocks.LIMITED_BARREL_2, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_2)).put((Object)ModBlocks.LIMITED_BARREL_3, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_3)).put((Object)ModBlocks.LIMITED_BARREL_4, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_4)).build())),
        BASIC_TO_GOLD(new HashMap<class_2248, TierUpgradeDefinition<?>>((Map<class_2248, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)class_2246.field_16328, new VanillaTierUpgradeDefinition<class_3719>(class_3719.class, blockEntity -> ((BarrelBlockEntityAccessor)blockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.GOLD_BARREL, class_4719.field_21677, new class_2769[]{class_2741.field_12525})).put((Object)class_2246.field_10034, new VanillaTierUpgradeDefinition<class_2595>(class_2595.class, chestBlockEntity -> ((ChestBlockEntityAccessor)chestBlockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.GOLD_CHEST, class_4719.field_21676, new class_2769[]{class_2741.field_12481, class_2741.field_12508})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.GOLD_SHULKER_BOX)).put((Object)ModBlocks.BARREL, (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)ModBlocks.CHEST, (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508})).put((Object)ModBlocks.SHULKER_BOX, (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_SHULKER_BOX, new class_2769[]{class_2741.field_12525})).put((Object)ModBlocks.LIMITED_BARREL_1, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_1)).put((Object)ModBlocks.LIMITED_BARREL_2, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_2)).put((Object)ModBlocks.LIMITED_BARREL_3, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_3)).put((Object)ModBlocks.LIMITED_BARREL_4, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_4)).build())),
        BASIC_TO_DIAMOND(new HashMap<class_2248, TierUpgradeDefinition<?>>((Map<class_2248, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)class_2246.field_16328, new VanillaTierUpgradeDefinition<class_3719>(class_3719.class, blockEntity -> ((BarrelBlockEntityAccessor)blockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.DIAMOND_BARREL, class_4719.field_21677, new class_2769[]{class_2741.field_12525})).put((Object)class_2246.field_10034, new VanillaTierUpgradeDefinition<class_2595>(class_2595.class, chestBlockEntity -> ((ChestBlockEntityAccessor)chestBlockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.DIAMOND_CHEST, class_4719.field_21676, new class_2769[]{class_2741.field_12481, class_2741.field_12508})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.DIAMOND_SHULKER_BOX)).put((Object)ModBlocks.BARREL, (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)ModBlocks.CHEST, (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508})).put((Object)ModBlocks.SHULKER_BOX, (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX, new class_2769[]{class_2741.field_12525})).put((Object)ModBlocks.LIMITED_BARREL_1, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1)).put((Object)ModBlocks.LIMITED_BARREL_2, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2)).put((Object)ModBlocks.LIMITED_BARREL_3, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3)).put((Object)ModBlocks.LIMITED_BARREL_4, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4)).build())),
        BASIC_TO_NETHERITE(new HashMap<class_2248, TierUpgradeDefinition<?>>((Map<class_2248, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)class_2246.field_16328, new VanillaTierUpgradeDefinition<class_3719>(class_3719.class, blockEntity -> ((BarrelBlockEntityAccessor)blockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.NETHERITE_BARREL, class_4719.field_21677, new class_2769[]{class_2741.field_12525})).put((Object)class_2246.field_10034, new VanillaTierUpgradeDefinition<class_2595>(class_2595.class, chestBlockEntity -> ((ChestBlockEntityAccessor)chestBlockEntity).getOpenersCounter().method_31678() > 0, (StorageBlockBase)ModBlocks.NETHERITE_CHEST, class_4719.field_21676, new class_2769[]{class_2741.field_12481, class_2741.field_12508})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.NETHERITE_SHULKER_BOX)).put((Object)ModBlocks.BARREL, (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)ModBlocks.CHEST, (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508})).put((Object)ModBlocks.SHULKER_BOX, (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX, new class_2769[]{class_2741.field_12525})).put((Object)ModBlocks.LIMITED_BARREL_1, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1)).put((Object)ModBlocks.LIMITED_BARREL_2, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2)).put((Object)ModBlocks.LIMITED_BARREL_3, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3)).put((Object)ModBlocks.LIMITED_BARREL_4, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4)).build())),
        IRON_TO_GOLD(Map.of(ModBlocks.IRON_BARREL, new StorageTierUpgradeDefinition(ModBlocks.GOLD_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), ModBlocks.IRON_CHEST, new StorageTierUpgradeDefinition(ModBlocks.GOLD_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508}), ModBlocks.IRON_SHULKER_BOX, new StorageTierUpgradeDefinition(ModBlocks.GOLD_SHULKER_BOX, new class_2769[]{class_2741.field_12525}), ModBlocks.LIMITED_IRON_BARREL_1, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_1), ModBlocks.LIMITED_IRON_BARREL_2, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_2), ModBlocks.LIMITED_IRON_BARREL_3, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_3), ModBlocks.LIMITED_IRON_BARREL_4, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_4))),
        IRON_TO_DIAMOND(new HashMap<class_2248, TierUpgradeDefinition<?>>((Map<class_2248, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)ModBlocks.IRON_BARREL, (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)ModBlocks.IRON_CHEST, (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508})).put((Object)ModBlocks.IRON_SHULKER_BOX, (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX, new class_2769[]{class_2741.field_12525})).put((Object)ModBlocks.LIMITED_IRON_BARREL_1, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1)).put((Object)ModBlocks.LIMITED_IRON_BARREL_2, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2)).put((Object)ModBlocks.LIMITED_IRON_BARREL_3, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3)).put((Object)ModBlocks.LIMITED_IRON_BARREL_4, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4)).build())),
        IRON_TO_NETHERITE(new HashMap<class_2248, TierUpgradeDefinition<?>>((Map<class_2248, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)ModBlocks.IRON_BARREL, (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)ModBlocks.IRON_CHEST, (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508})).put((Object)ModBlocks.IRON_SHULKER_BOX, (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX, new class_2769[]{class_2741.field_12525})).put((Object)ModBlocks.LIMITED_IRON_BARREL_1, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1)).put((Object)ModBlocks.LIMITED_IRON_BARREL_2, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2)).put((Object)ModBlocks.LIMITED_IRON_BARREL_3, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3)).put((Object)ModBlocks.LIMITED_IRON_BARREL_4, (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4)).build())),
        GOLD_TO_DIAMOND(Map.of(ModBlocks.GOLD_BARREL, new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), ModBlocks.GOLD_CHEST, new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508}), ModBlocks.GOLD_SHULKER_BOX, new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX, new class_2769[]{class_2741.field_12525}), ModBlocks.LIMITED_GOLD_BARREL_1, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1), ModBlocks.LIMITED_GOLD_BARREL_2, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2), ModBlocks.LIMITED_GOLD_BARREL_3, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3), ModBlocks.LIMITED_GOLD_BARREL_4, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4))),
        GOLD_TO_NETHERITE(Map.of(ModBlocks.GOLD_BARREL, new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), ModBlocks.GOLD_CHEST, new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508}), ModBlocks.GOLD_SHULKER_BOX, new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX, new class_2769[]{class_2741.field_12525}), ModBlocks.LIMITED_GOLD_BARREL_1, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1), ModBlocks.LIMITED_GOLD_BARREL_2, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2), ModBlocks.LIMITED_GOLD_BARREL_3, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3), ModBlocks.LIMITED_GOLD_BARREL_4, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4))),
        DIAMOND_TO_NETHERITE(Map.of(ModBlocks.DIAMOND_BARREL, new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL, new class_2769[]{class_2741.field_12525, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), ModBlocks.DIAMOND_CHEST, new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST, new class_2769[]{class_2741.field_12481, StorageBlockBase.TICKING, class_2741.field_12508}), ModBlocks.DIAMOND_SHULKER_BOX, new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX, new class_2769[]{class_2741.field_12525}), ModBlocks.LIMITED_DIAMOND_BARREL_1, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1), ModBlocks.LIMITED_DIAMOND_BARREL_2, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2), ModBlocks.LIMITED_DIAMOND_BARREL_3, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3), ModBlocks.LIMITED_DIAMOND_BARREL_4, new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4)));

        private final Map<class_2248, TierUpgradeDefinition<?>> blockUpgradeDefinitions;

        private TierUpgrade(Map<class_2248, TierUpgradeDefinition<?>> blockUpgradeDefinitions) {
            this.blockUpgradeDefinitions = blockUpgradeDefinitions;
        }

        public void addTierUpgradeDefinition(class_2248 block, TierUpgradeDefinition<?> tierUpgradeDefinition) {
            this.blockUpgradeDefinitions.put(block, tierUpgradeDefinition);
        }

        public Optional<TierUpgradeDefinition<?>> getBlockUpgradeDefinition(class_2248 block) {
            return Optional.ofNullable(this.blockUpgradeDefinitions.get(block));
        }
    }

    private static abstract class TierUpgradeDefinition<B extends class_2586> {
        private final List<class_2769<?>> propertiesToCopy;
        private final Class<B> blockEntityClass;
        private final Predicate<B> isUpgradingBlocked;
        private final StorageBlockBase newBlock;

        private TierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, class_2769<?> ... propertiesToCopy) {
            this.propertiesToCopy = Arrays.stream(propertiesToCopy).toList();
            this.blockEntityClass = blockEntityClass;
            this.isUpgradingBlocked = isUpgradingBlocked;
            this.newBlock = newBlock;
        }

        public List<class_2769<?>> getPropertiesToCopy() {
            return this.propertiesToCopy;
        }

        public Class<B> blockEntityClass() {
            return this.blockEntityClass;
        }

        public Predicate<B> isUpgradingBlocked() {
            return this.isUpgradingBlocked;
        }

        public StorageBlockBase newBlock() {
            return this.newBlock;
        }

        abstract boolean upgradeStorage(@Nullable class_1657 var1, class_2338 var2, class_1937 var3, class_2680 var4, B var5);

        protected class_2680 getBlockState(class_2680 state) {
            class_2680 newBlockState = this.newBlock().method_9564();
            for (class_2769<?> property : this.getPropertiesToCopy()) {
                newBlockState = this.setProperty(newBlockState, state, property);
            }
            return newBlockState;
        }

        private <T extends Comparable<T>> class_2680 setProperty(class_2680 newBlockState, class_2680 state, class_2769<T> property) {
            return (class_2680)newBlockState.method_11657(property, state.method_11654(property));
        }
    }

    public static class VanillaTierUpgradeDefinition<B extends class_2621>
    extends TierUpgradeDefinition<B> {
        @Nullable
        private final class_4719 woodType;
        private final int color;

        public VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable class_4719 woodType, class_2769<?> ... propertiesToCopy) {
            this(blockEntityClass, isUpgradingBlocked, newBlock, woodType, -1, propertiesToCopy);
        }

        private VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable class_4719 woodType, class_1767 color, class_2769<?> ... propertiesToCopy) {
            this(blockEntityClass, isUpgradingBlocked, newBlock, woodType, ColorHelper.getColor((float[])color.method_7787()), propertiesToCopy);
        }

        private VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable class_4719 woodType, int color, class_2769<?> ... propertiesToCopy) {
            super(blockEntityClass, isUpgradingBlocked, newBlock, propertiesToCopy);
            this.woodType = woodType;
            this.color = color;
        }

        @Nullable
        public class_4719 woodType() {
            return this.woodType;
        }

        @Override
        boolean upgradeStorage(@Nullable class_1657 player, class_2338 pos, class_1937 level, class_2680 state, B be) {
            if (player == null || !be.method_17489(player)) {
                return false;
            }
            class_2561 customName = be.method_5797();
            class_2371 items = class_2371.method_10211();
            for (int slot = 0; slot < be.method_5439(); ++slot) {
                items.add(slot, (Object)be.method_5438(slot));
            }
            class_2680 newBlockState = this.getBlockState(state);
            StorageBlockEntity newBlockEntity = this.newBlock().newBlockEntity(pos, newBlockState);
            this.setStorageItemsNameAndWoodType(newBlockEntity, customName, (class_2371<class_1799>)items, this.woodType());
            newBlockEntity.setUpdateBlockRender();
            this.replaceBlockAndBlockEntity(newBlockState, newBlockEntity, pos, level);
            newBlockEntity.tryToAddToController();
            WorldHelper.notifyBlockUpdate((class_2586)newBlockEntity);
            return true;
        }

        private void replaceBlockAndBlockEntity(class_2680 newBlockState, class_2586 newBlockEntity, class_2338 pos, class_1937 level) {
            level.method_8544(pos);
            level.method_8650(pos, false);
            level.method_8652(pos, newBlockState, 3);
            level.method_8438(newBlockEntity);
        }

        private void setStorageItemsNameAndWoodType(StorageBlockEntity newBe, @Nullable class_2561 customName, class_2371<class_1799> items, @Nullable class_4719 woodType) {
            StorageWrapper storageWrapper;
            InventoryHandler inventoryHandler;
            if (customName != null) {
                newBe.setCustomName(customName);
            }
            if ((inventoryHandler = (storageWrapper = newBe.getStorageWrapper()).getInventoryHandler()).getSlotCount() < items.size()) {
                inventoryHandler.setSize(items.size());
            }
            for (int slot = 0; slot < items.size(); ++slot) {
                inventoryHandler.setStackInSlot(slot, (class_1799)items.get(slot));
            }
            if (woodType != null && newBe instanceof WoodStorageBlockEntity) {
                WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)newBe;
                wbe.setWoodType(woodType);
            }
            if (this.color > -1) {
                storageWrapper.setMainColor(this.color);
                storageWrapper.setAccentColor(this.color);
            }
        }
    }

    private static class VanillaTintedShulkerBoxTierUpgradeDefinition
    extends VanillaTierUpgradeDefinition<class_2627> {
        private VanillaTintedShulkerBoxTierUpgradeDefinition(class_1767 color, ShulkerBoxBlock newBlock) {
            super(class_2627.class, (B shulkerBoxBlockEntity) -> ((ShulkerBoxBlockEntityAccessor)shulkerBoxBlockEntity).getOpenCount() > 0, (StorageBlockBase)newBlock, null, color, new class_2769[]{class_2480.field_11496, StorageBlockBase.TICKING});
        }
    }

    private static class LimitedBarrelTierUpgradeDefinition
    extends StorageTierUpgradeDefinition {
        private LimitedBarrelTierUpgradeDefinition(StorageBlockBase newBlock) {
            super(newBlock, new class_2769[]{LimitedBarrelBlock.HORIZONTAL_FACING, LimitedBarrelBlock.VERTICAL_FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP});
        }
    }

    private static class StorageTierUpgradeDefinition
    extends TierUpgradeDefinition<StorageBlockEntity> {
        private StorageTierUpgradeDefinition(StorageBlockBase newBlock, class_2769<?> ... propertiesToCopy) {
            super(StorageBlockEntity.class, (B storageBlockEntity) -> {
                WoodStorageBlockEntity wbe;
                return storageBlockEntity.isOpen() || storageBlockEntity instanceof WoodStorageBlockEntity && (wbe = (WoodStorageBlockEntity)storageBlockEntity).isPacked();
            }, newBlock, propertiesToCopy);
        }

        @Override
        boolean upgradeStorage(@Nullable class_1657 player, class_2338 pos, class_1937 level, class_2680 state, StorageBlockEntity blockEntity) {
            class_2487 beTag = new class_2487();
            blockEntity.method_11007(beTag);
            class_2680 newBlockState = this.getBlockState(state);
            StorageBlockEntity newBlockEntity = this.newBlock().newBlockEntity(pos, newBlockState);
            int newInventorySize = newBlockEntity.getStorageWrapper().getInventoryHandler().getSlotCount();
            int newUpgradeSize = newBlockEntity.getStorageWrapper().getUpgradeHandler().getSlotCount();
            newBlockEntity.method_11014(beTag);
            blockEntity.setBeingUpgraded();
            level.method_8544(pos);
            level.method_8650(pos, false);
            level.method_8652(pos, newBlockState, 3);
            level.method_8438((class_2586)newBlockEntity);
            newBlockEntity.increaseStorageSize(newInventorySize - newBlockEntity.getStorageWrapper().getInventoryHandler().getSlotCount(), newUpgradeSize - newBlockEntity.getStorageWrapper().getUpgradeHandler().getSlotCount());
            WorldHelper.notifyBlockUpdate((class_2586)newBlockEntity);
            return true;
        }
    }
}

