/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4719;
import net.minecraft.class_5632;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.common.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;

public class WoodStorageBlockItem
extends StorageBlockItem {
    public static final String WOOD_TYPE_TAG = "woodType";
    public static final String PACKED_TAG = "packed";

    public WoodStorageBlockItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public static void setPacked(class_1799 storageStack, boolean packed) {
        storageStack.method_7948().method_10556(PACKED_TAG, packed);
    }

    public static boolean isPacked(class_1799 storageStack) {
        return NBTHelper.getBoolean((class_1799)storageStack, (String)PACKED_TAG).orElse(false);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        if (WoodStorageBlockItem.isPacked(stack)) {
            if (flagIn == class_1836.class_1837.field_41071) {
                CapabilityStorageWrapper.get(stack).flatMap(IStorageWrapper::getContentsUuid).ifPresent(uuid -> tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + String.valueOf(uuid))).method_27692(class_124.field_1063)));
            }
            if (!class_437.method_25442()) {
                tooltip.add((class_2561)class_2561.method_43469((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
            }
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!WoodStorageBlockItem.isPacked(stack)) {
            return Optional.empty();
        }
        StorageContentsTooltip ret = null;
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_310 mc = class_310.method_1551();
            if (class_437.method_25442() || mc.field_1724 != null && !mc.field_1724.field_7512.method_34255().method_7960()) {
                ret = new StorageContentsTooltip(stack);
            }
        }
        return Optional.ofNullable(ret);
    }

    @Override
    public void setMainColor(class_1799 storageStack, int mainColor) {
        if (StorageBlockItem.getAccentColorFromStack(storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setMainColor(storageStack, mainColor);
    }

    @Override
    public void setAccentColor(class_1799 storageStack, int accentColor) {
        if (StorageBlockItem.getMainColorFromStack(storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setAccentColor(storageStack, accentColor);
    }

    private void removeWoodType(class_1799 storageStack) {
        storageStack.method_7948().method_10551(WOOD_TYPE_TAG);
    }

    public static Optional<class_4719> getWoodType(class_1799 storageStack) {
        return NBTHelper.getString((class_1799)storageStack, (String)WOOD_TYPE_TAG).flatMap(woodType -> class_4719.method_24026().filter(wt -> wt.comp_1299().equals(woodType)).findFirst());
    }

    public static StorageWrapper initWrapper(class_1799 stack) {
        UUID uuid = NBTHelper.getUniqueId((class_1799)stack, (String)"uuid").orElse(null);
        StackStorageWrapper storageWrapper = new StackStorageWrapper(stack){

            @Override
            protected boolean isAllowedInStorage(class_1799 stack) {
                return false;
            }
        };
        if (uuid != null) {
            class_2487 compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).method_10562("storageWrapper");
            storageWrapper.load(compoundtag);
            ((StorageWrapper)storageWrapper).setContentsUuid(uuid);
        }
        return storageWrapper;
    }

    public static class_1799 setWoodType(class_1799 storageStack, class_4719 woodType) {
        storageStack.method_7948().method_10582(WOOD_TYPE_TAG, woodType.comp_1299());
        return storageStack;
    }

    public class_2561 method_7864(class_1799 stack) {
        return WoodStorageBlockItem.getDisplayName(this.method_7876(), WoodStorageBlockItem.getWoodType(stack).orElse(null));
    }

    public static class_2561 getDisplayName(String descriptionId, @Nullable class_4719 woodType) {
        if (woodType == null) {
            return class_2561.method_43469((String)descriptionId, (Object[])new Object[]{"", ""});
        }
        return class_2561.method_43469((String)descriptionId, (Object[])new Object[]{class_2561.method_43471((String)("wood_name.sophisticatedstorage." + woodType.comp_1299().toLowerCase(Locale.ROOT))), " "});
    }
}

