/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import com.google.common.collect.MapMaker;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeItem;

public class HopperUpgradeWrapper
extends UpgradeWrapperBase<HopperUpgradeWrapper, HopperUpgradeItem>
implements ITickableUpgrade,
INeighborChangeListenerUpgrade {
    private Set<class_2350> pullDirections = new LinkedHashSet<class_2350>();
    private Set<class_2350> pushDirections = new LinkedHashSet<class_2350>();
    private final Map<class_2350, BlockApiCache<Storage<ItemVariant>, class_2350>> handlerCache = new MapMaker().weakKeys().weakValues().makeMap();
    private final ContentsFilterLogic inputFilterLogic;
    private final ContentsFilterLogic outputFilterLogic;
    private long coolDownTime = 0L;

    protected HopperUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputFilterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getInputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), "inputFilter");
        this.outputFilterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getOutputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), "outputFilter");
        this.deserialize();
    }

    public void tick(@Nullable class_1309 entity, class_1937 level, class_2338 pos) {
        this.initDirections(level, pos);
        if (this.coolDownTime > level.method_8510()) {
            return;
        }
        for (class_2350 pushDirection : this.pushDirections) {
            if (this.getItemHandler(level, pos, pushDirection).map(this::pushItems).orElse(false).booleanValue()) break;
        }
        for (class_2350 pullDirection : this.pullDirections) {
            if (this.getItemHandler(level, pos, pullDirection).map(this::pullItems).orElse(false).booleanValue()) break;
        }
        this.coolDownTime = level.method_8510() + ((HopperUpgradeItem)this.upgradeItem).getTransferSpeedTicks();
    }

    private void initDirections(class_1937 level, class_2338 pos) {
        if (this.upgrade.method_7985()) {
            return;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)class_22482;
            class_2350 horizontalDirection = storageBlock.getHorizontalDirection(state);
            VerticalFacing verticalFacing = storageBlock.getVerticalFacing(state);
            this.initDirections(BlockSide.BOTTOM.toDirection(horizontalDirection, verticalFacing), BlockSide.TOP.toDirection(horizontalDirection, verticalFacing));
        }
    }

    private boolean pullItems(Storage<ItemVariant> fromHandler) {
        return this.moveItems(fromHandler, (Storage<ItemVariant>)this.storageWrapper.getInventoryForUpgradeProcessing(), (FilterLogic)this.inputFilterLogic);
    }

    private boolean pushItems(Storage<ItemVariant> toHandler) {
        return this.moveItems((Storage<ItemVariant>)this.storageWrapper.getInventoryForUpgradeProcessing(), toHandler, (FilterLogic)this.outputFilterLogic);
    }

    private boolean moveItems(Storage<ItemVariant> fromHandler, Storage<ItemVariant> toHandler, FilterLogic filterLogic) {
        for (StorageView view : fromHandler.nonEmptyViews()) {
            ItemVariant resource = (ItemVariant)view.getResource();
            class_1799 slotStack = resource.toStack((int)view.getAmount());
            if (slotStack.method_7960() || !filterLogic.matchesFilter(slotStack)) continue;
            long maxExtracted = StorageUtil.simulateExtract((StorageView)view, (Object)resource, (long)((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize(), null);
            Transaction transferTransaction = Transaction.openOuter();
            try {
                long accepted = toHandler.insert((Object)resource, maxExtracted, (TransactionContext)transferTransaction);
                if (fromHandler.extract((Object)resource, accepted, (TransactionContext)transferTransaction) != accepted) continue;
                transferTransaction.commit();
                boolean bl = true;
                return bl;
            }
            finally {
                if (transferTransaction == null) continue;
                transferTransaction.close();
            }
        }
        return false;
    }

    @Override
    public void onNeighborChange(class_1937 level, class_2338 pos, class_2350 direction) {
        if (this.pushDirections.contains(direction) || this.pullDirections.contains(direction)) {
            this.handlerCache.put(direction, (BlockApiCache<Storage<ItemVariant>, class_2350>)BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)level), (class_2338)pos.method_10093(direction)));
        }
    }

    private Optional<Storage<ItemVariant>> getItemHandler(class_1937 level, class_2338 pos, class_2350 direction) {
        if (!this.handlerCache.containsKey(direction)) {
            this.handlerCache.put(direction, (BlockApiCache<Storage<ItemVariant>, class_2350>)BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)level), (class_2338)pos.method_10093(direction)));
        }
        return Optional.ofNullable((Storage)this.handlerCache.get(direction).find((Object)direction.method_10153()));
    }

    public ContentsFilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public ContentsFilterLogic getOutputFilterLogic() {
        return this.outputFilterLogic;
    }

    public boolean isPullingFrom(class_2350 direction) {
        return this.pullDirections.contains(direction);
    }

    public boolean isPushingTo(class_2350 direction) {
        return this.pushDirections.contains(direction);
    }

    public void setPullingFrom(class_2350 direction, boolean shouldPull) {
        if (shouldPull) {
            this.pullDirections.add(direction);
        } else {
            this.pullDirections.remove(direction);
        }
        this.serializePullDirections();
    }

    public void setPushingTo(class_2350 direction, boolean isPushing) {
        if (isPushing) {
            this.pushDirections.add(direction);
        } else {
            this.pushDirections.remove(direction);
        }
        this.serializePushDirections();
    }

    private void serializePullDirections() {
        NBTHelper.putList((class_2487)this.upgrade.method_7948(), (String)"pullDirections", this.pullDirections, d -> class_2519.method_23256((String)d.method_15434()));
        this.save();
    }

    private void serializePushDirections() {
        NBTHelper.putList((class_2487)this.upgrade.method_7948(), (String)"pushDirections", this.pushDirections, d -> class_2519.method_23256((String)d.method_15434()));
        this.save();
    }

    public void deserialize() {
        this.pullDirections.clear();
        this.pushDirections.clear();
        if (this.upgrade.method_7985()) {
            this.pullDirections = NBTHelper.getCollection((class_2487)this.upgrade.method_7948(), (String)"pullDirections", (byte)8, t -> Optional.ofNullable(class_2350.method_10168((String)t.method_10714())), HashSet::new).orElseGet(HashSet::new);
            this.pushDirections = NBTHelper.getCollection((class_2487)this.upgrade.method_7948(), (String)"pushDirections", (byte)8, t -> Optional.ofNullable(class_2350.method_10168((String)t.method_10714())), HashSet::new).orElseGet(HashSet::new);
        }
    }

    public void initDirections(class_2350 pushDirection, class_2350 pullDirection) {
        if (!this.upgrade.method_7985()) {
            this.setPushingTo(pushDirection, true);
            this.setPullingFrom(pullDirection, true);
        }
    }
}

