/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class BlackboardBlock
extends WaterBlock
implements class_2343,
IWashable {
    protected static final class_265 SHAPE_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_SOUTH = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11035);
    protected static final class_265 SHAPE_EAST = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11034);
    protected static final class_265 SHAPE_WEST = MthUtils.rotateVoxelShape((class_265)SHAPE_NORTH, (class_2350)class_2350.field_11039);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 GLOWING = ModBlockProperties.GLOWING;

    public BlackboardBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, GLOWING});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(world, pos, state, placer, stack);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BlackboardBlockTile) {
            BlackboardBlockTile tile = (BlackboardBlockTile)class_25862;
            BlockUtil.addOptionalOwnership(placer, tile);
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11039 -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public static byte colorToByte(class_1767 color) {
        return switch (color) {
            case class_1767.field_7963 -> 0;
            case class_1767.field_7952 -> 1;
            case class_1767.field_7946 -> 15;
            default -> (byte)color.method_7789();
        };
    }

    public static int colorFromByte(byte b) {
        return switch (b) {
            case 0, 1 -> 0xFFFFFF;
            case 15 -> class_1767.field_7946.method_7794().field_16011;
            default -> class_1767.method_7791((int)b).method_7794().field_16011;
        };
    }

    public static Vector2i getHitSubPixel(class_3965 hit) {
        class_243 pos = hit.method_17784();
        class_243 v = pos.method_1024(hit.method_17780().method_10144() * ((float)Math.PI / 180));
        double fx = v.field_1352 % 1.0 * 16.0;
        if (fx < 0.0) {
            fx += 16.0;
        }
        int x = class_3532.method_15340((int)((int)fx), (int)-15, (int)15);
        int y = 15 - (int)class_3532.method_15350((double)Math.abs(v.field_1351 % 1.0 * 16.0), (double)0.0, (double)15.0);
        if (pos.field_1351 < 0.0) {
            y = 15 - y;
        }
        return new Vector2i(x, y);
    }

    @Nullable
    public static class_1767 getStackChalkColor(class_1799 stack) {
        boolean hasColor = CommonConfigs.Building.BLACKBOARD_COLOR.get();
        for (class_1767 dyeColor : class_1767.values()) {
            if (!hasColor && dyeColor != class_1767.field_7952 && dyeColor != class_1767.field_7963 || !stack.method_31573(ModTags.BLACKBOARD_TAGS.get(dyeColor))) continue;
            return dyeColor;
        }
        return null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        BlackboardBlockTile te;
        class_2586 class_25862;
        if (!level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof BlackboardBlockTile && (te = (BlackboardBlockTile)class_25862).isAccessibleBy(player)) {
            class_1767 color;
            class_1799 stack = player.method_5998(hand);
            class_1269 result = te.tryWaxing(level, pos, player, hand);
            if (result.method_23665()) {
                level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)level.method_8320(pos)));
                te.method_5431();
            }
            if (result != class_1269.field_5811) {
                return result;
            }
            boolean glowChanged = false;
            if (stack.method_31574(class_1802.field_28410) && !((Boolean)state.method_11654((class_2769)GLOWING)).booleanValue()) {
                level.method_8396(null, pos, class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(true)));
                glowChanged = true;
            } else if (stack.method_31574(class_1802.field_8794) && ((Boolean)state.method_11654((class_2769)GLOWING)).booleanValue()) {
                level.method_8396(null, pos, class_3417.field_28397, class_3419.field_15245, 1.0f, 1.0f);
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(false)));
                glowChanged = true;
            }
            if (glowChanged) {
                level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)level.method_8320(pos)));
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                    player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                }
                return class_1269.field_21466;
            }
            UseMode config = CommonConfigs.Building.BLACKBOARD_MODE.get();
            if (hit.method_17780() == state.method_11654((class_2769)FACING) && config.canManualDraw() && (color = BlackboardBlock.getStackChalkColor(stack)) != null) {
                Vector2i pair = BlackboardBlock.getHitSubPixel(hit);
                int x = pair.x();
                int y = pair.y();
                byte newColor = BlackboardBlock.colorToByte(color);
                if (te.getPixel(x, y) != newColor) {
                    te.setPixel(x, y, newColor);
                    te.method_5431();
                }
                return class_1269.field_21466;
            }
            if (config.canOpenGui()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    te.tryOpeningEditGui(serverPlayer, pos, stack);
                }
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)super.method_9605(context).method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new BlackboardBlockTile(pPos, pState);
    }

    public class_1799 getBlackboardItem(BlackboardBlockTile te) {
        class_2487 tag;
        class_1799 itemstack = new class_1799((class_1935)this);
        if (!te.isEmpty() && !(tag = te.savePixels(new class_2487())).method_33133()) {
            itemstack.method_7959("BlockEntityTag", (class_2520)tag);
        }
        return itemstack;
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)class_25862;
            return this.getBlackboardItem(te);
        }
        return super.method_9574(level, pos, state);
    }

    public boolean tryWash(class_1937 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)class_25862;
            if (((Boolean)state.method_11654((class_2769)GLOWING)).booleanValue()) {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(false)));
            }
            if (te.isWaxed()) {
                te.setWaxed(false);
                te.method_5431();
                return true;
            }
            if (!te.isEmpty()) {
                te.clear();
                te.method_5431();
                return true;
            }
        }
        return false;
    }

    public static enum UseMode {
        BOTH,
        GUI,
        MANUAL;


        public boolean canOpenGui() {
            return this != MANUAL;
        }

        public boolean canManualDraw() {
            return this != GUI;
        }
    }
}

