/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.quark;

import com.google.common.base.Stopwatch;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_4208;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_6833;
import net.minecraft.class_6862;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.tools.item.PathfindersQuillItem;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class CartographersQuillItem
extends PathfindersQuillItem {
    public static final String TAG_STRUCTURE = "targetStructure";
    public static final String TAG_SKIP_KNOWN = "skinKnown";
    public static final String TAG_SEARCH_RADIUS = "maxSearchRadius";
    public static final String TAG_ZOOM = "zoomLevel";
    public static final String TAG_DECORATION = "decoration";
    public static final String TAG_NAME = "name";
    protected static final String TAG_RADIUS = "searchRadius";
    protected static final String TAG_POS_INDEX = "searchIndex";
    protected static final String TAG_WAITING = "waiting";
    private static Thread mainThread;
    private static final Map<Key, class_1271<class_2338>> RESULTS;
    private static final Set<Key> COMPUTING;
    private static final Set<class_1923> COMPUTING_CHUNKPOS;

    public CartographersQuillItem() {
        super(null, new class_1792.class_1793().method_7889(1));
    }

    public void appendHoverText(class_1799 stack, class_1937 level, List<class_2561> comps, class_1836 flags) {
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            if (ItemNBTHelper.getBoolean((class_1799)stack, (String)"isSearchingForBiome", (boolean)false)) {
                comps.add((class_2561)PathfindersQuillItem.getSearchingComponent().method_27692(class_124.field_1078));
            }
        } else {
            comps.add((class_2561)class_2561.method_43471((String)"message.supplementaries.cartographers_quill").method_27692(class_124.field_1080));
        }
    }

    protected String getFailMessage() {
        return "message.supplementaries.quill_failed";
    }

    protected String getSuccessMessage() {
        return "message.supplementaries.quill_finished";
    }

    protected String getRetryMessage() {
        return "message.supplementaries.quill_retry";
    }

    public int getIterations() {
        return 500;
    }

    public class_1271<class_1799> use(class_1937 level, class_1657 player, class_1268 hand) {
        if (level instanceof class_3218) {
            String str;
            class_3218 serverLevel = (class_3218)level;
            class_2487 tag = player.method_5998(hand).method_7948();
            if (!tag.method_10545(TAG_STRUCTURE) && (str = CartographersQuillItem.selectRandomTarget(serverLevel, ModTags.ADVENTURE_MAP_DESTINATIONS)) != null) {
                tag.method_10582(TAG_STRUCTURE, str);
            }
        }
        return super.use(level, player, hand);
    }

    @Nullable
    public class_2960 getTarget(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        String str = tag.method_10558(TAG_STRUCTURE);
        return new class_2960(str);
    }

    @Nullable
    private class_6880<class_3195> getStructureHolder(class_3218 level, class_2960 key) {
        class_2378 reg = level.method_30349().method_30530(class_7924.field_41246);
        Optional structure = reg.method_40264(class_5321.method_29179((class_5321)reg.method_30517(), (class_2960)key));
        return structure.orElse(null);
    }

    public class_1799 createMap(class_3218 level, class_2338 targetPos, class_2960 structure, class_1799 original) {
        class_2487 tag = original.method_7948();
        class_1799 m = AdventurerMapsHandler.createStructureMap(level, targetPos, this.getStructureHolder(level, structure), this.getZoomLevel(tag), this.getDecoration(tag), this.getMapName(tag), this.getColor(tag));
        if (original.method_7938()) {
            m.method_7977(original.method_7964());
        }
        return m;
    }

    protected class_1271<class_2338> searchConcurrent(class_2960 target, class_1799 stack, class_3218 level, class_1657 player) {
        class_2487 tag = stack.method_7948();
        class_6880<class_3195> structure = this.getStructureHolder(level, target);
        State state = State.get(tag);
        if (structure == null || state == null) {
            return class_1271.method_22431((Object)class_2338.field_10980);
        }
        class_2338 center = this.getOrCreateStartPos(tag, player);
        int radius = this.getSearchRadius(tag);
        boolean skipKnown = this.getSkipKnown(tag);
        Key key = new Key(class_4208.method_19443((class_5321)level.method_27983(), (class_2338)center), ((class_5321)structure.method_40230().get()).method_29177(), radius, skipKnown);
        if (COMPUTING.contains(key)) {
            return class_1271.method_22430((Object)class_2338.field_10980);
        }
        if (RESULTS.containsKey(key)) {
            class_1271<class_2338> ret = RESULTS.remove(key);
            if (ret.method_5467() == class_1269.field_5811) {
                return class_1271.method_22431((Object)class_2338.field_10980);
            }
            return ret;
        }
        class_1799 dummy = stack.method_7972();
        PathfindersQuillItem.EXECUTORS.submit(() -> {
            COMPUTING.add(key);
            RESULTS.put(key, this.searchIterative(target, dummy, level, player, Integer.MAX_VALUE));
            COMPUTING.remove(key);
        });
        return class_1271.method_22430((Object)class_2338.field_10980);
    }

    protected class_1271<class_2338> searchIterative(class_2960 target, class_1799 stack, class_3218 level, class_1657 player, int maxIter) {
        class_2487 tag = stack.method_7948();
        class_6880<class_3195> structure = this.getStructureHolder(level, target);
        State state = State.get(tag);
        if (structure == null || state == null) {
            return class_1271.method_22431((Object)class_2338.field_10980);
        }
        class_2338 center = this.getOrCreateStartPos(tag, player);
        int radius = this.getSearchRadius(tag);
        boolean skipKnown = this.getSkipKnown(tag);
        return this.findNearestMapStructure(level, structure, radius, center, skipKnown, state, maxIter);
    }

    protected class_1799 search(class_1799 stack, class_3218 level, class_1657 player, int slot) {
        if (mainThread == null) {
            mainThread = Thread.currentThread();
        }
        return super.search(stack, level, player, slot);
    }

    private class_2338 getOrCreateStartPos(class_2487 tag, class_1657 player) {
        if (tag.method_10545("searchSourceX") && tag.method_10545("searchSourceZ")) {
            int sourceX = tag.method_10550("searchSourceX");
            int sourceZ = tag.method_10550("searchSourceZ");
            return new class_2338(sourceX, 64, sourceZ);
        }
        class_2338 pos = player.method_24515();
        tag.method_10569("searchSourceX", pos.method_10263());
        tag.method_10569("searchSourceZ", pos.method_10260());
        return pos;
    }

    private int getSearchRadius(class_2487 tag) {
        if (tag.method_10545(TAG_SEARCH_RADIUS)) {
            return tag.method_10550(TAG_SEARCH_RADIUS);
        }
        return 150;
    }

    @Nullable
    private String getMapName(class_2487 tag) {
        if (tag.method_10545(TAG_NAME)) {
            return tag.method_10558(TAG_NAME);
        }
        return null;
    }

    private int getColor(class_2487 tag) {
        if (tag.method_10545("targetBiomeColor")) {
            return tag.method_10550("targetBiomeColor");
        }
        return 0;
    }

    @Nullable
    private class_2960 getDecoration(class_2487 tag) {
        if (tag.method_10545(TAG_DECORATION)) {
            return new class_2960(tag.method_10558(TAG_DECORATION));
        }
        return null;
    }

    private int getZoomLevel(class_2487 tag) {
        if (tag.method_10545(TAG_ZOOM)) {
            return tag.method_10550(TAG_ZOOM);
        }
        return 2;
    }

    private boolean getSkipKnown(class_2487 tag) {
        if (tag.method_10545(TAG_SKIP_KNOWN)) {
            return tag.method_10577(TAG_SKIP_KNOWN);
        }
        return true;
    }

    @Nullable
    public class_1271<class_2338> findNearestMapStructure(class_3218 level, class_6880<class_3195> holder, int searchRadius, class_2338 center, boolean skipKnownStructures, State state, int maxIterations) {
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return null;
        }
        class_3215 source = level.method_14178();
        class_2794 gen = source.method_12129();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        class_7869 structureState = level.method_14178().method_46642();
        for (class_6874 structurePlacement : structureState.method_46708(holder)) {
            map.computeIfAbsent(structurePlacement, ss -> new ObjectArraySet()).add(holder);
        }
        if (map.isEmpty()) {
            return class_1271.method_22431((Object)class_2338.field_10980);
        }
        double d = Double.MAX_VALUE;
        class_5138 structureManager = level.method_27056();
        ArrayList<Pair> list = new ArrayList<Pair>(map.size());
        for (Map.Entry ent : map.entrySet()) {
            class_6874 placement = (class_6874)ent.getKey();
            if (placement instanceof class_6871) {
                class_2338 blockPos;
                double e;
                class_6871 concentricRingsStructurePlacement = (class_6871)placement;
                Pair pair2 = gen.method_40148((Set)ent.getValue(), level, structureManager, center, skipKnownStructures, concentricRingsStructurePlacement);
                if (pair2 == null || !((e = center.method_10262((class_2382)(blockPos = (class_2338)pair2.getFirst()))) < d)) continue;
                return class_1271.method_22427((Object)((class_2338)pair2.getFirst()));
            }
            if (!(placement instanceof class_6872)) continue;
            class_6872 rr = (class_6872)placement;
            list.add(Pair.of((Object)rr, (Object)((Set)ent.getValue())));
        }
        if (list.isEmpty()) {
            return null;
        }
        int centerX = class_4076.method_18675((int)center.method_10263());
        int centerY = class_4076.method_18675((int)center.method_10260());
        long seed = level.method_8412();
        int currentIter = 0;
        while (state.radius <= searchRadius) {
            class_2338 found = null;
            while (state.placementInd < list.size()) {
                double f;
                Pair pl = (Pair)list.get(state.placementInd);
                class_6872 placement = (class_6872)pl.getFirst();
                Set holderSet = (Set)pl.getSecond();
                class_2338 foundPair = null;
                int spacing = placement.method_41632();
                block4: while (state.x <= state.radius) {
                    boolean onEdgeX;
                    boolean bl = onEdgeX = state.x == -state.radius || state.x == state.radius;
                    while (state.z <= state.radius) {
                        boolean onEdgeY;
                        boolean bl2 = onEdgeY = state.z == -state.radius || state.z == state.radius;
                        if (onEdgeX || onEdgeY) {
                            ++currentIter;
                            int testX = centerX + spacing * state.x;
                            int testY = centerY + spacing * state.z;
                            class_1923 chunkPos = placement.method_40169(seed, testX, testY);
                            Either<class_2338, class_1923> pair = CartographersQuillItem.getStructureGeneratingAt(holderSet, source, structureManager, skipKnownStructures, (class_6874)placement, chunkPos, state);
                            if (pair != null) {
                                Optional left = pair.left();
                                if (left.isPresent()) {
                                    foundPair = (class_2338)left.get();
                                    state.z = -state.radius;
                                    break block4;
                                }
                                return class_1271.method_22430((Object)class_2338.field_10980);
                            }
                            if (currentIter > maxIterations) {
                                return class_1271.method_22430((Object)class_2338.field_10980);
                            }
                        }
                        ++state.z;
                    }
                    state.z = -state.radius;
                    ++state.x;
                }
                state.x = -state.radius;
                if (foundPair != null && (f = center.method_10262(foundPair)) < d) {
                    d = f;
                    found = foundPair;
                }
                ++state.placementInd;
            }
            state.placementInd = 0;
            if (found != null) {
                return class_1271.method_22427(found);
            }
            ++state.radius;
        }
        return class_1271.method_22431((Object)class_2338.field_10980);
    }

    public static Either<class_2338, class_1923> getStructureGeneratingAt(Set<class_6880<class_3195>> structureHoldersSet, class_3215 chunkCache, class_5138 structureManager, boolean skipKnownStructures, class_6874 placement, class_1923 chunkPos, State state) {
        Stopwatch s2 = Stopwatch.createStarted();
        for (class_6880<class_3195> holder : structureHoldersSet) {
            class_3195 structure = (class_3195)holder.comp_349();
            class_6833 structureCheckResult = structureManager.method_39783(chunkPos, structure, skipKnownStructures);
            if (structureCheckResult == class_6833.field_36240) continue;
            if (!skipKnownStructures && structureCheckResult == class_6833.field_36239) {
                return Either.left((Object)placement.method_41636(chunkPos));
            }
            boolean shouldMultiThread = Thread.currentThread() == mainThread;
            class_2791 chunkAccess = chunkCache.method_12121(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_16423, !shouldMultiThread);
            if (chunkAccess == null && shouldMultiThread) {
                if (state.waiting && !COMPUTING_CHUNKPOS.contains(chunkPos)) {
                    state.waiting = false;
                }
                if (!state.waiting) {
                    PathfindersQuillItem.EXECUTORS.submit(() -> {
                        COMPUTING_CHUNKPOS.add(chunkPos);
                        chunkCache.method_12121(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_16423, true);
                        COMPUTING_CHUNKPOS.remove(chunkPos);
                    });
                    state.waiting = true;
                }
                if (state.z == -state.radius) {
                    ++state.z;
                    if (state.x == -state.radius) {
                        ++state.x;
                        --state.radius;
                    } else {
                        --state.x;
                    }
                } else {
                    --state.z;
                }
                Supplementaries.LOGGER.warn("E " + String.valueOf(s2.elapsed()));
                return Either.right((Object)chunkPos);
            }
            state.waiting = false;
            class_3449 structureStart = structureManager.method_26975(class_4076.method_33705((class_2791)chunkAccess), structure, (class_2810)chunkAccess);
            if (structureStart == null || !structureStart.method_16657() || skipKnownStructures && !CartographersQuillItem.tryAddReference(structureManager, structureStart)) continue;
            return Either.left((Object)placement.method_41636(structureStart.method_34000()));
        }
        return null;
    }

    private static boolean tryAddReference(class_5138 structureManager, class_3449 structureStrart) {
        if (structureStrart.method_14979()) {
            structureManager.method_39784(structureStrart);
            return true;
        }
        return false;
    }

    public static class_1799 forStructure(class_3218 level, @Nullable class_6885<class_3195> targets, int searchRadius, boolean skipKnown, int zoom, @Nullable class_20.class_21 deco, @Nullable String name, int color) {
        class_1799 stack = CartographersQuillItem.forStructure(level, targets);
        class_2487 t = stack.method_7948();
        t.method_10569(TAG_SEARCH_RADIUS, searchRadius);
        t.method_10556(TAG_SKIP_KNOWN, skipKnown);
        t.method_10569(TAG_ZOOM, zoom);
        if (deco != null) {
            t.method_10582(TAG_DECORATION, deco.toString().toLowerCase(Locale.ROOT));
        }
        if (name != null) {
            t.method_10582(TAG_NAME, name);
        }
        if (color != 0) {
            t.method_10569("targetBiomeColor", color);
        }
        return stack;
    }

    public static int getItemColor(class_1799 stack, int layer) {
        if (layer == 0) {
            return -1;
        }
        class_2487 compoundTag = stack.method_7969();
        if (compoundTag != null && compoundTag.method_10545("targetBiomeColor")) {
            int i = compoundTag.method_10550("targetBiomeColor");
            return 0xFF000000 | i & 0xFFFFFF;
        }
        return 0;
    }

    public static class_1799 forStructure(class_3218 level, @Nullable class_6885<class_3195> tag) {
        class_1799 stack = QuarkCompat.CARTOGRAPHERS_QUILL.get().method_7854();
        if (tag != null) {
            String target = CartographersQuillItem.selectRandomTarget(level, tag);
            if (target == null) {
                return class_1799.field_8037;
            }
            stack.method_7948().method_10582(TAG_STRUCTURE, target);
        }
        return stack;
    }

    @Nullable
    private static String selectRandomTarget(class_3218 level, class_6862<class_3195> tag) {
        Optional targets = level.method_30349().method_30530(class_7924.field_41246).method_40266(tag);
        return targets.map(holders -> CartographersQuillItem.selectRandomTarget(level, (class_6885<class_3195>)holders)).orElse(null);
    }

    @Nullable
    private static String selectRandomTarget(class_3218 level, class_6885<class_3195> taggedStructures) {
        ArrayList<class_6880> reachable = new ArrayList<class_6880>();
        for (class_6880 s : taggedStructures) {
            class_7869 randomState = level.method_14178().method_46642();
            if (randomState.method_46708(s).isEmpty()) continue;
            reachable.add(s);
        }
        if (!reachable.isEmpty()) {
            class_6880 selected = (class_6880)reachable.get(level.field_9229.method_43048(reachable.size()));
            return ((class_5321)selected.method_40230().get()).method_29177().toString();
        }
        return null;
    }

    static {
        RESULTS = new ConcurrentHashMap<Key, class_1271<class_2338>>();
        COMPUTING = ConcurrentHashMap.newKeySet();
        COMPUTING_CHUNKPOS = ConcurrentHashMap.newKeySet();
    }

    private static final class State {
        private boolean waiting;
        private int radius;
        private int x;
        private int z;
        private int placementInd;

        private State(int lastRadius, int lastX, int lastZ, int index, boolean waiting) {
            this.radius = lastRadius;
            this.x = lastX;
            this.z = lastZ;
            this.placementInd = index;
            this.waiting = waiting;
        }

        public void save(class_2487 tag) {
            tag.method_10569(CartographersQuillItem.TAG_RADIUS, this.radius);
            tag.method_10569("searchPosX", this.x);
            tag.method_10569("searchPosZ", this.z);
            tag.method_10569(CartographersQuillItem.TAG_POS_INDEX, this.placementInd);
            tag.method_10556(CartographersQuillItem.TAG_WAITING, this.waiting);
        }

        @Nullable
        private static State get(class_2487 tag) {
            int radius = 0;
            if (tag.method_10545(CartographersQuillItem.TAG_RADIUS)) {
                radius = tag.method_10550(CartographersQuillItem.TAG_RADIUS);
            }
            int x = 0;
            if (tag.method_10545("searchPosX")) {
                x = tag.method_10550("searchPosX");
            }
            int z = 0;
            if (tag.method_10545("searchPosZ")) {
                z = tag.method_10550("searchPosZ");
            }
            int index = 0;
            if (tag.method_10545(CartographersQuillItem.TAG_POS_INDEX)) {
                index = tag.method_10550(CartographersQuillItem.TAG_POS_INDEX);
            }
            boolean waiting = false;
            if (tag.method_10545(CartographersQuillItem.TAG_WAITING)) {
                waiting = tag.method_10577(CartographersQuillItem.TAG_WAITING);
            }
            if (x > radius || z > radius) {
                return null;
            }
            return new State(radius, x, z, index, waiting);
        }
    }

    private record Key(class_4208 pos, class_2960 structure, int radius, boolean bool) {
    }
}

