/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.digest.BalticHash;
import net.szum123321.textile_backup.core.digest.Hash;
import net.szum123321.textile_backup.core.restore.AwaitThread;
import org.apache.commons.io.FileUtils;

public class Globals {
    public static final Globals INSTANCE = new Globals();
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    public static final DateTimeFormatter defaultDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");
    public static final Supplier<Hash> CHECKSUM_SUPPLIER = BalticHash::new;
    private ExecutorService executorService = null;
    public final AtomicBoolean globalShutdownBackupFlag = new AtomicBoolean(true);
    public boolean disableWatchdog = false;
    private boolean disableTMPFiles = false;
    private AwaitThread restoreAwaitThread = null;
    private Path lockedPath = null;
    private String combinedVersionString;

    private Globals() {
    }

    public ExecutorService getQueueExecutor() {
        return this.executorService;
    }

    public void resetQueueExecutor() {
        if (Objects.nonNull(this.executorService) && !this.executorService.isShutdown()) {
            return;
        }
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void shutdownQueueExecutor(long timeout) {
        if (this.executorService.isShutdown()) {
            return;
        }
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(timeout, TimeUnit.MICROSECONDS)) {
                log.error("Timeout occurred while waiting for currently running backups to finish!", new Object[0]);
                this.executorService.shutdownNow().stream().forEach(r -> log.error("Dropping: {}", r.toString()));
                if (!this.executorService.awaitTermination(1000L, TimeUnit.MICROSECONDS)) {
                    log.error("Couldn't shut down the executor!", new Object[0]);
                }
            }
        }
        catch (InterruptedException e) {
            log.error("An exception occurred!", e);
        }
    }

    public Optional<AwaitThread> getAwaitThread() {
        return Optional.ofNullable(this.restoreAwaitThread);
    }

    public void setAwaitThread(AwaitThread th) {
        this.restoreAwaitThread = th;
    }

    public Optional<Path> getLockedFile() {
        return Optional.ofNullable(this.lockedPath);
    }

    public void setLockedFile(Path p) {
        this.lockedPath = p;
    }

    public synchronized boolean disableTMPFS() {
        return this.disableTMPFiles;
    }

    public synchronized void updateTMPFSFlag(MinecraftServer server) {
        this.disableTMPFiles = false;
        Path tmp_dir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
        if (FileUtils.sizeOfDirectory((File)Utilities.getWorldFolder(server).toFile()) >= tmp_dir.toFile().getUsableSpace()) {
            log.error("Not enough space left in TMP directory! ({})", tmp_dir);
            this.disableTMPFiles = true;
        }
        if (!Files.isWritable(tmp_dir)) {
            log.error("TMP filesystem ({}) is read-only!", tmp_dir);
            this.disableTMPFiles = true;
        }
        if (this.disableTMPFiles) {
            log.error("Might cause: https://github.com/Szum123321/textile_backup/wiki/ZIP-Problems", new Object[0]);
        }
    }

    public String getCombinedVersionString() {
        return this.combinedVersionString;
    }

    public void setCombinedVersionString(String combinedVersionString) {
        this.combinedVersionString = combinedVersionString;
    }
}

