/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.commands.create.CleanupCommand;
import net.szum123321.textile_backup.commands.create.StartBackupCommand;
import net.szum123321.textile_backup.commands.manage.BlacklistCommand;
import net.szum123321.textile_backup.commands.manage.DeleteCommand;
import net.szum123321.textile_backup.commands.manage.ListBackupsCommand;
import net.szum123321.textile_backup.commands.manage.WhitelistCommand;
import net.szum123321.textile_backup.commands.restore.KillRestoreCommand;
import net.szum123321.textile_backup.commands.restore.RestoreBackupCommand;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.config.ConfigPOJO;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.create.BackupScheduler;
import net.szum123321.textile_backup.core.create.ExecutableBackup;

public class TextileBackup
implements ModInitializer {
    public static final String MOD_NAME = "Textile Backup";
    public static final String MOD_ID = "textile_backup";
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public void onInitialize() {
        Globals.INSTANCE.setCombinedVersionString(((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow()).getMetadata().getVersion().getFriendlyString() + ":" + ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow()).getMetadata().getVersion().getFriendlyString());
        log.info("Starting Textile Backup {} by Szum123321", Globals.INSTANCE.getCombinedVersionString());
        ConfigHelper.updateInstance((ConfigHolder<ConfigPOJO>)AutoConfig.register(ConfigPOJO.class, JanksonConfigSerializer::new));
        ServerTickEvents.END_SERVER_TICK.register(BackupScheduler::tick);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Globals.INSTANCE.resetQueueExecutor();
            Globals.INSTANCE.updateTMPFSFlag(server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            Globals.INSTANCE.shutdownQueueExecutor(60000L);
            if (TextileBackup.config.get().shutdownBackup && Globals.INSTANCE.globalShutdownBackupFlag.get()) {
                try {
                    ExecutableBackup.Builder.newBackupContextBuilder().setServer(server).setInitiator(ActionInitiator.Shutdown).setComment("shutdown").announce().build().call();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"backup").requires(ctx -> {
            try {
                return (TextileBackup.config.get().playerWhitelist.contains(ctx.method_9229().method_5820()) || ctx.method_9259(TextileBackup.config.get().permissionLevel)) && !TextileBackup.config.get().playerBlacklist.contains(ctx.method_9229().method_5820()) || ctx.method_9211().method_3724() && TextileBackup.config.get().alwaysSingleplayerAllowed;
            }
            catch (Exception ignored) {
                return true;
            }
        })).then(StartBackupCommand.register())).then(CleanupCommand.register())).then(WhitelistCommand.register())).then(BlacklistCommand.register())).then(RestoreBackupCommand.register())).then(ListBackupsCommand.register())).then(DeleteCommand.register())).then(KillRestoreCommand.register())));
    }
}

