/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.core.RestoreableFile;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.restore.RestoreHelper;

public final class FileSuggestionProvider
implements SuggestionProvider<class_2168> {
    private static final FileSuggestionProvider INSTANCE = new FileSuggestionProvider();

    public static FileSuggestionProvider Instance() {
        return INSTANCE;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        LinkedList<RestoreableFile> files = RestoreHelper.getAvailableBackups(((class_2168)ctx.getSource()).method_9211());
        for (RestoreableFile file : files) {
            String formattedCreationTime = file.getCreationTime().format(Globals.defaultDateTimeFormatter);
            if (!formattedCreationTime.startsWith(remaining)) continue;
            if (Utilities.wasSentByPlayer((class_2168)ctx.getSource())) {
                if (file.getComment().isPresent()) {
                    builder.suggest(formattedCreationTime, (Message)new LiteralMessage("Comment: " + file.getComment().get()));
                    continue;
                }
                builder.suggest(formattedCreationTime);
                continue;
            }
            if (file.getComment().isPresent()) {
                builder.suggest(file.getCreationTime() + "#" + file.getComment().get());
                continue;
            }
            builder.suggest(formattedCreationTime);
        }
        if ("latest".startsWith(remaining) && !files.isEmpty()) {
            builder.suggest("latest", (Message)new LiteralMessage(files.getLast().getCreationTime().format(Globals.defaultDateTimeFormatter) + files.getLast().getComment().map(s -> "#" + s).orElse("")));
        }
        return builder.buildFuture();
    }
}

