/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.commands.manage;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;

public class BlacklistCommand {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blacklist").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(BlacklistCommand::executeAdd)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(BlacklistCommand::executeRemove)))).then(class_2170.method_9247((String)"list").executes(ctx -> BlacklistCommand.executeList((class_2168)ctx.getSource())))).executes(ctx -> BlacklistCommand.help((class_2168)ctx.getSource()));
    }

    private static int help(class_2168 source) {
        log.sendInfo(source, "Available command are: add [player], remove [player], list.", new Object[0]);
        return 1;
    }

    private static int executeList(class_2168 source) {
        StringBuilder builder = new StringBuilder();
        builder.append("Currently on the blacklist are: ");
        for (String name : BlacklistCommand.config.get().playerBlacklist) {
            builder.append(name);
            builder.append(", ");
        }
        log.sendInfo(source, builder.toString(), new Object[0]);
        return 1;
    }

    private static int executeAdd(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(ctx, (String)"player");
        if (BlacklistCommand.config.get().playerBlacklist.contains(player.method_5820())) {
            log.sendInfo((class_2168)ctx.getSource(), "Player: {} is already blacklisted.", player.method_5820());
        } else {
            BlacklistCommand.config.get().playerBlacklist.add(player.method_5820());
            config.save();
            StringBuilder builder = new StringBuilder();
            builder.append("Player: ");
            builder.append(player.method_5820());
            builder.append(" added to the blacklist");
            if (BlacklistCommand.config.get().playerWhitelist.contains(player.method_5820())) {
                BlacklistCommand.config.get().playerWhitelist.remove(player.method_5820());
                config.save();
                builder.append(" and removed form the whitelist");
            }
            builder.append(" successfully.");
            ((class_2168)ctx.getSource()).method_9211().method_3734().method_9241(player);
            log.sendInfo((class_2168)ctx.getSource(), builder.toString(), new Object[0]);
        }
        return 1;
    }

    private static int executeRemove(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(ctx, (String)"player");
        if (!BlacklistCommand.config.get().playerBlacklist.contains(player.method_5820())) {
            log.sendInfo((class_2168)ctx.getSource(), "Player: {} newer was blacklisted.", player.method_5820());
        } else {
            BlacklistCommand.config.get().playerBlacklist.remove(player.method_5820());
            config.save();
            ((class_2168)ctx.getSource()).method_9211().method_3734().method_9241(player);
            log.sendInfo((class_2168)ctx.getSource(), "Player: {} removed from the blacklist successfully.", player.method_5820());
        }
        return 1;
    }
}

