/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.commands.manage;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.commands.CommandExceptions;
import net.szum123321.textile_backup.commands.FileSuggestionProvider;
import net.szum123321.textile_backup.core.RestoreableFile;
import net.szum123321.textile_backup.core.Utilities;

public class DeleteCommand {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)FileSuggestionProvider.Instance()).executes(ctx -> DeleteCommand.execute((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"file"))));
    }

    private static int execute(class_2168 source, String fileName) throws CommandSyntaxException {
        LocalDateTime dateTime;
        try {
            dateTime = LocalDateTime.from(Globals.defaultDateTimeFormatter.parse(fileName));
        }
        catch (DateTimeParseException e2) {
            throw CommandExceptions.DATE_TIME_PARSE_COMMAND_EXCEPTION_TYPE.create((Object)e2);
        }
        Path root = Utilities.getBackupRootPath(Utilities.getLevelName(source.method_9211()));
        RestoreableFile.applyOnFiles(root, Optional.empty(), e -> log.sendErrorAL(source, "An exception occurred while trying to delete a file!", e), stream -> stream.filter(f -> f.getCreationTime().equals(dateTime)).map(RestoreableFile::getFile).findFirst()).ifPresentOrElse(file -> {
            if (Globals.INSTANCE.getLockedFile().filter(p -> p == file).isEmpty()) {
                try {
                    Files.delete((Path)file);
                    log.sendInfo(source, "File {} successfully deleted!", file);
                    if (Utilities.wasSentByPlayer(source)) {
                        log.info("Player {} deleted {}.", source.method_44023().method_5477(), file);
                    }
                }
                catch (IOException e) {
                    log.sendError(source, "Something went wrong while deleting file!", new Object[0]);
                }
            } else {
                log.sendError(source, "Couldn't delete the file because it's being restored right now.", new Object[0]);
                log.sendHint(source, "If you want to abort restoration then use: /backup killR", new Object[0]);
            }
        }, () -> {
            log.sendInfo(source, "Couldn't find file by this name.", new Object[0]);
            log.sendInfo(source, "Maybe try /backup list", new Object[0]);
        });
        return 0;
    }
}

