/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import net.szum123321.textile_backup.core.restore.RestoreContext;

public record CompressionStatus(long treeHash, Map<String, Exception> brokenFiles, LocalDateTime date, long startTimestamp, long finishTimestamp, String version) implements Serializable
{
    public static final String DATA_FILENAME = "textile_status.data";

    public Optional<String> validate(long hash, RestoreContext ctx) throws RuntimeException {
        if (hash != this.treeHash) {
            return Optional.of("Tree Hash mismatch!\n  Expected: " + CompressionStatus.hex(this.treeHash) + ", got: " + CompressionStatus.hex(hash));
        }
        if (!this.brokenFiles.isEmpty()) {
            return Optional.of("Damaged files present! ^");
        }
        if (ctx.restoreableFile().getCreationTime().equals(this.date)) {
            return Optional.of("Creation date mismatch!\n   Expected: " + this.date.format(DateTimeFormatter.ISO_DATE_TIME) + ", got: " + ctx.restoreableFile().getCreationTime().format(DateTimeFormatter.ISO_DATE_TIME));
        }
        return Optional.empty();
    }

    public static Path resolveStatusFilename(Path directory) {
        return directory.resolve(DATA_FILENAME);
    }

    public static CompressionStatus readFromFile(Path directory) throws IOException, ClassNotFoundException {
        try (InputStream i = Files.newInputStream(directory.resolve(DATA_FILENAME), new OpenOption[0]);){
            CompressionStatus compressionStatus;
            try (ObjectInputStream obj = new ObjectInputStream(i);){
                compressionStatus = (CompressionStatus)obj.readObject();
            }
            return compressionStatus;
        }
    }

    public byte[] serialize() throws IOException {
        try (ByteArrayOutputStream bo = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream o = new ObjectOutputStream(bo);){
                o.writeObject(this);
                byArray = bo.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        builder.append("Hash: ").append(CompressionStatus.hex(this.treeHash)).append(", Date: ").append(this.date.format(DateTimeFormatter.ISO_DATE_TIME)).append(", Start timestamp: ").append(this.startTimestamp).append(", Finish timestamp: ").append(this.finishTimestamp).append(", Mod Version: ").append(this.version);
        builder.append(", Broken files: ");
        if (this.brokenFiles.isEmpty()) {
            builder.append("[]");
        } else {
            builder.append("[\n");
            for (String i : this.brokenFiles.keySet()) {
                builder.append(i).append(":");
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                this.brokenFiles.get(i).printStackTrace(new PrintStream(o));
                builder.append(o).append("\n");
            }
            builder.append("]");
        }
        builder.append(" }");
        return builder.toString();
    }

    private static String hex(long val) {
        return "0x" + Long.toHexString(val).toUpperCase();
    }
}

