/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.config.ConfigPOJO;
import net.szum123321.textile_backup.core.Utilities;
import org.jetbrains.annotations.NotNull;

public class RestoreableFile
implements Comparable<RestoreableFile> {
    private final Path file;
    private final ConfigPOJO.ArchiveFormat archiveFormat;
    private final LocalDateTime creationTime;
    private final String comment;

    private RestoreableFile(Path file, ConfigPOJO.ArchiveFormat archiveFormat, LocalDateTime creationTime, String comment) {
        this.file = file;
        this.archiveFormat = archiveFormat;
        this.creationTime = creationTime;
        this.comment = comment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T applyOnFiles(Path root, T def, Consumer<IOException> errorConsumer, Function<Stream<RestoreableFile>, T> streamConsumer) {
        try (Stream<Path> stream = Files.list(root);){
            Stream t = streamConsumer.apply(stream.flatMap(f -> RestoreableFile.build(f).stream()));
            return (T)t;
        }
        catch (IOException e) {
            errorConsumer.accept(e);
            return def;
        }
    }

    public static Optional<RestoreableFile> build(Path file) throws NoSuchElementException {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isRegularFile(file, new LinkOption[0])) {
            return Optional.empty();
        }
        String filename = file.getFileName().toString();
        ConfigPOJO.ArchiveFormat format = Arrays.stream(ConfigPOJO.ArchiveFormat.values()).filter(f -> filename.endsWith(f.getCompleteString())).findAny().orElse(null);
        if (Objects.isNull((Object)format)) {
            return Optional.empty();
        }
        int parsed_pos = filename.length() - format.getCompleteString().length();
        String comment = null;
        if (filename.contains("#")) {
            comment = filename.substring(filename.indexOf("#") + 1, parsed_pos);
            parsed_pos -= comment.length() + 1;
        }
        String time_string = filename.substring(0, parsed_pos);
        try {
            return Optional.of(new RestoreableFile(file, format, LocalDateTime.from(Utilities.getDateTimeFormatter().parse(time_string)), comment));
        }
        catch (Exception exception) {
            try {
                return Optional.of(new RestoreableFile(file, format, LocalDateTime.from(Globals.defaultDateTimeFormatter.parse(time_string)), comment));
            }
            catch (Exception exception2) {
                try {
                    FileTime fileTime = Files.readAttributes(file, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).creationTime();
                    return Optional.of(new RestoreableFile(file, format, LocalDateTime.ofInstant(fileTime.toInstant(), ZoneOffset.systemDefault()), comment));
                }
                catch (IOException iOException) {
                    return Optional.empty();
                }
            }
        }
    }

    public Path getFile() {
        return this.file;
    }

    public ConfigPOJO.ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public int compareTo(@NotNull RestoreableFile o) {
        return this.creationTime.compareTo(o.creationTime);
    }

    public String toString() {
        return this.getCreationTime().format(Globals.defaultDateTimeFormatter) + (String)(this.comment != null ? "#" + this.comment : "");
    }
}

