/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.create.BrokenFileHandler;
import net.szum123321.textile_backup.core.create.InputSupplier;
import net.szum123321.textile_backup.core.digest.FileTreeHashBuilder;
import net.szum123321.textile_backup.core.digest.HashingInputStream;

public record FileInputStreamSupplier(Path path, String name, FileTreeHashBuilder hashTreeBuilder, BrokenFileHandler brokenFileHandler) implements InputSupplier
{
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return new HashingInputStream(Files.newInputStream(this.path, new OpenOption[0]), this.path, this.hashTreeBuilder, this.brokenFileHandler);
        }
        catch (IOException e) {
            this.hashTreeBuilder.update(this.path, 0L, 0L);
            this.brokenFileHandler.handle(this.path, e);
            throw e;
        }
    }

    @Override
    public Optional<Path> getPath() {
        return Optional.of(this.path);
    }

    @Override
    public long size() throws IOException {
        return Files.size(this.path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public InputStream get() {
        try {
            return this.getInputStream();
        }
        catch (IOException e) {
            log.error("An exception occurred while trying to create an input stream from file: {}!", this.path.toString(), e);
            return null;
        }
    }
}

