/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.CompressionStatus;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.create.BrokenFileHandler;
import net.szum123321.textile_backup.core.create.ExecutableBackup;
import net.szum123321.textile_backup.core.create.FileInputStreamSupplier;
import net.szum123321.textile_backup.core.create.InputSupplier;
import net.szum123321.textile_backup.core.digest.FileTreeHashBuilder;

public abstract class AbstractCompressor {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createArchive(Path inputFile, Path outputFile, ExecutableBackup ctx, int coreLimit) throws IOException, ExecutionException, InterruptedException {
        Instant start = Instant.now();
        BrokenFileHandler brokenFileHandler = new BrokenFileHandler();
        try (OutputStream outStream = Files.newOutputStream(outputFile, new OpenOption[0]);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outStream);
             OutputStream arc = this.createArchiveOutputStream(bufferedOutputStream, ctx, coreLimit);
             Stream<Path> fileStream = Files.walk(inputFile, new FileVisitOption[0]);){
            List<Path> fileList = fileStream.filter(path -> !Utilities.isBlacklisted(inputFile.relativize((Path)path))).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
            FileTreeHashBuilder fileHashBuilder = new FileTreeHashBuilder(fileList.size());
            for (Path file : fileList) {
                try {
                    this.addEntry(new FileInputStreamSupplier(file, inputFile.relativize(file).toString(), fileHashBuilder, brokenFileHandler), arc);
                }
                catch (IOException e) {
                    brokenFileHandler.handle(file, e);
                    fileHashBuilder.update(file, 0L, 0L);
                    if (ConfigHelper.INSTANCE.get().integrityVerificationMode.isStrict()) {
                        throw e;
                    }
                    log.sendErrorAL(ctx, "An exception occurred while trying to compress: {}", inputFile.relativize(file).toString(), e);
                }
            }
            arc.flush();
            Instant now = Instant.now();
            long treeHash = fileHashBuilder.getValue(true);
            CompressionStatus status = new CompressionStatus(treeHash, brokenFileHandler.get(), ctx.startDate(), start.toEpochMilli(), now.toEpochMilli(), Globals.INSTANCE.getCombinedVersionString());
            this.addEntry(new StatusFileInputSupplier(status.serialize()), arc);
            this.finish(arc);
        }
        finally {
            this.close();
        }
        log.sendInfoAL(ctx, "Compression took: {} seconds.", Utilities.formatDuration(Duration.between(start, Instant.now())));
    }

    protected abstract OutputStream createArchiveOutputStream(OutputStream var1, ExecutableBackup var2, int var3) throws IOException;

    protected abstract void addEntry(InputSupplier var1, OutputStream var2) throws IOException;

    protected void finish(OutputStream arc) throws InterruptedException, ExecutionException, IOException {
    }

    protected void close() {
    }

    private record StatusFileInputSupplier(byte[] data) implements InputSupplier
    {
        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public Optional<Path> getPath() {
            return Optional.empty();
        }

        @Override
        public String getName() {
            return "textile_status.data";
        }

        @Override
        public long size() {
            return this.data.length;
        }

        public InputStream get() {
            return this.getInputStream();
        }
    }
}

