/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.NoSpaceLeftOnDeviceException;
import net.szum123321.textile_backup.core.create.ExecutableBackup;
import net.szum123321.textile_backup.core.create.InputSupplier;
import net.szum123321.textile_backup.core.create.compressors.ZipCompressor;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;

public class ParallelZipCompressor
extends ZipCompressor {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final SimpleStackTraceElement[] STACKTRACE_NO_SPACE_ON_LEFT_ON_DEVICE = new SimpleStackTraceElement[]{new SimpleStackTraceElement("sun.nio.ch.FileDispatcherImpl", "write0", true), new SimpleStackTraceElement("sun.nio.ch.FileDispatcherImpl", "write", false), new SimpleStackTraceElement("sun.nio.ch.IOUtil", "writeFromNativeBuffer", false), new SimpleStackTraceElement("sun.nio.ch.IOUtil", "write", false), new SimpleStackTraceElement("sun.nio.ch.FileChannelImpl", "write", false), new SimpleStackTraceElement("java.nio.channels.Channels", "writeFullyImpl", false), new SimpleStackTraceElement("java.nio.channels.Channels", "writeFully", false), new SimpleStackTraceElement("java.nio.channels.Channels$1", "write", false), new SimpleStackTraceElement("org.apache.commons.compress.parallel.FileBasedScatterGatherBackingStore", "writeOut", false)};
    private ParallelScatterZipCreator scatterZipCreator;

    public static ParallelZipCompressor getInstance() {
        return new ParallelZipCompressor();
    }

    @Override
    protected OutputStream createArchiveOutputStream(OutputStream stream, ExecutableBackup ctx, int coreLimit) {
        this.scatterZipCreator = new ParallelScatterZipCreator(Executors.newFixedThreadPool(coreLimit));
        return super.createArchiveOutputStream(stream, ctx, coreLimit);
    }

    @Override
    protected void addEntry(InputSupplier input, OutputStream arc) throws IOException {
        ZipArchiveEntry entry;
        if (input.getPath().isEmpty()) {
            entry = new ZipArchiveEntry(input.getName());
            entry.setMethod(0);
            entry.setSize(input.size());
        } else {
            Path file = input.getPath().get();
            entry = (ZipArchiveEntry)((ZipArchiveOutputStream)arc).createArchiveEntry(file, input.getName(), new LinkOption[0]);
            if (ZipCompressor.isDotDat(file.toString())) {
                entry.setMethod(0);
                entry.setSize(Files.size(file));
                entry.setCompressedSize(Files.size(file));
                entry.setCrc(ParallelZipCompressor.getCRC(file));
            } else {
                entry.setMethod(8);
            }
        }
        entry.setTime(System.currentTimeMillis());
        this.scatterZipCreator.addArchiveEntry(entry, (InputStreamSupplier)input);
    }

    @Override
    protected void finish(OutputStream arc) throws InterruptedException, IOException, ExecutionException {
        try {
            this.scatterZipCreator.writeTo((ZipArchiveOutputStream)arc);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause.getClass().equals(IOException.class)) {
                boolean match;
                boolean bl = match = cause.getStackTrace().length >= STACKTRACE_NO_SPACE_ON_LEFT_ON_DEVICE.length;
                if (match) {
                    for (int i = 0; i < STACKTRACE_NO_SPACE_ON_LEFT_ON_DEVICE.length && match; ++i) {
                        if (STACKTRACE_NO_SPACE_ON_LEFT_ON_DEVICE[i].matches(cause.getStackTrace()[i])) continue;
                        match = false;
                    }
                    if (match) {
                        throw new NoSpaceLeftOnDeviceException(cause);
                    }
                }
            }
            throw e;
        }
    }

    private record SimpleStackTraceElement(String className, String methodName, boolean isNative) {
        public boolean matches(StackTraceElement o) {
            return this.isNative == o.isNativeMethod() && Objects.equals(this.className, o.getClassName()) && Objects.equals(this.methodName, o.getMethodName());
        }
    }
}

