/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.zip.CRC32;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.create.ExecutableBackup;
import net.szum123321.textile_backup.core.create.InputSupplier;
import net.szum123321.textile_backup.core.create.compressors.AbstractCompressor;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipCompressor
extends AbstractCompressor {
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public static ZipCompressor getInstance() {
        return new ZipCompressor();
    }

    @Override
    protected OutputStream createArchiveOutputStream(OutputStream stream, ExecutableBackup ctx, int coreLimit) {
        ZipArchiveOutputStream arc = new ZipArchiveOutputStream(stream);
        arc.setMethod(8);
        arc.setUseZip64(Zip64Mode.AsNeeded);
        arc.setLevel(ZipCompressor.config.get().compression);
        arc.setComment("Created on: " + Utilities.getDateTimeFormatter().format(LocalDateTime.now()));
        return arc;
    }

    @Override
    protected void addEntry(InputSupplier input, OutputStream arc) throws IOException {
        try (InputStream fileInputStream = input.getInputStream();){
            if (input.getPath().isEmpty()) {
                ZipArchiveEntry entry = new ZipArchiveEntry(input.getName());
                byte[] buff = new byte[(int)input.size()];
                int len = input.getInputStream().read(buff);
                CRC32 sum = new CRC32();
                sum.update(buff, 0, len);
                entry.setCrc(sum.getValue());
                entry.setMethod(0);
                entry.setSize(input.size());
                ((ZipArchiveOutputStream)arc).putArchiveEntry((ArchiveEntry)entry);
                arc.write(buff, 0, len);
            } else {
                Path file = input.getPath().get();
                ZipArchiveEntry entry = (ZipArchiveEntry)((ZipArchiveOutputStream)arc).createArchiveEntry(file, input.getName(), new LinkOption[0]);
                if (ZipCompressor.isDotDat(file.toString())) {
                    entry.setMethod(0);
                    entry.setSize(Files.size(file));
                    entry.setCompressedSize(Files.size(file));
                    entry.setCrc(ZipCompressor.getCRC(file));
                } else {
                    entry.setMethod(8);
                }
                ((ZipArchiveOutputStream)arc).putArchiveEntry((ArchiveEntry)entry);
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)arc);
            }
            ((ZipArchiveOutputStream)arc).closeArchiveEntry();
        }
    }

    protected static boolean isDotDat(String filename) {
        String[] arr = filename.split("\\.");
        return arr[arr.length - 1].contains("dat");
    }

    protected static long getCRC(Path file) throws IOException {
        CRC32 sum = new CRC32();
        byte[] buffer = new byte[8192];
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            int len;
            while ((len = stream.read(buffer)) != -1) {
                sum.update(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new IOException("Error while calculating CRC of: " + file.toAbsolutePath(), e);
        }
        return sum.getValue();
    }
}

