/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.digest;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.digest.Hash;

public class FileTreeHashBuilder {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private final Object lock = new Object();
    private long hash = 0L;
    private long filesProcessed = 0L;
    private long filesTotalSize = 0L;
    private final CountDownLatch latch;

    public FileTreeHashBuilder(int filesToProcess) {
        this.latch = new CountDownLatch(filesToProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Path path, long newHash, long bytes) throws IOException {
        if (path.getFileName().toString().equals("textile_status.data")) {
            return;
        }
        this.latch.countDown();
        Object object = this.lock;
        synchronized (object) {
            this.hash ^= newHash;
            this.filesTotalSize += bytes;
            ++this.filesProcessed;
        }
    }

    public int getRemaining() {
        return (int)this.latch.getCount();
    }

    public long getValue(boolean lock) throws InterruptedException {
        long leftover = this.latch.getCount();
        if (lock) {
            this.latch.await();
        } else if (leftover != 0L) {
            log.warn("Finishing with {} files unprocessed!", leftover);
        }
        Hash hasher = Globals.CHECKSUM_SUPPLIER.get();
        log.debug("Closing: files: {}, bytes {}, raw hash {}", this.filesProcessed, this.filesTotalSize, this.hash);
        hasher.update(this.hash);
        hasher.update(this.filesProcessed);
        hasher.update(this.filesTotalSize);
        return hasher.getValue();
    }
}

