/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.digest;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.core.digest.FileTreeHashBuilder;
import net.szum123321.textile_backup.core.digest.Hash;
import org.jetbrains.annotations.NotNull;

public class HashingOutputStream
extends FilterOutputStream {
    private final Path path;
    private final Hash hash = Globals.CHECKSUM_SUPPLIER.get();
    private final FileTreeHashBuilder hashBuilder;
    private long bytesWritten = 0L;

    public HashingOutputStream(OutputStream out, Path path, FileTreeHashBuilder hashBuilder) {
        super(out);
        this.path = path;
        this.hashBuilder = hashBuilder;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.hash.update(b);
        ++this.bytesWritten;
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.hash.update(b, off, len);
        this.bytesWritten += (long)len;
    }

    @Override
    public void close() throws IOException {
        this.hash.update(this.path.getFileName().toString().getBytes(StandardCharsets.UTF_8));
        this.hashBuilder.update(this.path, this.hash.getValue(), this.bytesWritten);
        super.close();
    }
}

