/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore;

import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.Globals;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.RestoreableFile;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.restore.AwaitThread;
import net.szum123321.textile_backup.core.restore.RestoreBackupRunnable;
import net.szum123321.textile_backup.core.restore.RestoreContext;

public class RestoreHelper {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public static Optional<RestoreableFile> findFileAndLockIfPresent(LocalDateTime backupTime, MinecraftServer server) {
        Path root = Utilities.getBackupRootPath(Utilities.getLevelName(server));
        Optional optionalFile = RestoreableFile.applyOnFiles(root, Optional.empty(), e -> log.error("An exception occurred while trying to lock the file!", e), s -> s.filter(rf -> rf.getCreationTime().equals(backupTime)).findFirst());
        optionalFile.ifPresent(r -> Globals.INSTANCE.setLockedFile(r.getFile()));
        return optionalFile;
    }

    public static Optional<RestoreableFile> getLatestAndLockIfPresent(MinecraftServer server) {
        LinkedList<RestoreableFile> available = RestoreHelper.getAvailableBackups(server);
        if (available.isEmpty()) {
            return Optional.empty();
        }
        RestoreableFile latest = available.getLast();
        Globals.INSTANCE.setLockedFile(latest.getFile());
        return Optional.of(latest);
    }

    public static AwaitThread create(RestoreContext ctx) {
        if (ctx.initiator() == ActionInitiator.Player) {
            log.info("Backup restoration was initiated by: {}", ctx.commandSource().method_9214());
        } else {
            log.info("Backup restoration was initiated form Server Console", new Object[0]);
        }
        Utilities.notifyPlayers(ctx.server(), "Warning! The server is going to shut down in " + RestoreHelper.config.get().restoreDelay + " seconds!");
        return new AwaitThread(RestoreHelper.config.get().restoreDelay, (Runnable)new RestoreBackupRunnable(ctx));
    }

    public static LinkedList<RestoreableFile> getAvailableBackups(MinecraftServer server) {
        Path root = Utilities.getBackupRootPath(Utilities.getLevelName(server));
        return RestoreableFile.applyOnFiles(root, new LinkedList(), e -> log.error("Error while listing available backups", e), s -> s.sorted().collect(Collectors.toCollection(LinkedList::new)));
    }
}

