/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.restore.decompressors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.digest.FileTreeHashBuilder;
import net.szum123321.textile_backup.core.digest.HashingOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

public class ZipDecompressor {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static long decompress(Path inputFile, Path target) throws IOException {
        Instant start = Instant.now();
        FileTreeHashBuilder hashBuilder = new FileTreeHashBuilder(0);
        try (ZipFile zipFile = new ZipFile(inputFile.toFile());){
            Iterator it = zipFile.getEntries().asIterator();
            while (it.hasNext()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)it.next();
                Path file = target.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
                try (HashingOutputStream out = new HashingOutputStream(outputStream, file, hashBuilder);){
                    InputStream in = zipFile.getInputStream(entry);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                finally {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
        }
        log.info("Decompression took: {} seconds.", Utilities.formatDuration(Duration.between(start, Instant.now())));
        try {
            return hashBuilder.getValue(false);
        }
        catch (InterruptedException ignored) {
            return 0L;
        }
    }
}

