/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.at4j.comp.bzip2.BZip2EncoderExecutorService;
import org.at4j.comp.bzip2.BZip2EncoderExecutorServiceImpl;
import org.at4j.comp.bzip2.BZip2OutputStreamSettings;
import org.at4j.comp.bzip2.BlockOutputStream;
import org.at4j.comp.bzip2.EncodedBlockWriter;
import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.comp.bzip2.MultipleObserverErrorState;
import org.at4j.comp.bzip2.SingleObserverErrorState;
import org.at4j.support.io.LittleEndianBitOutputStream;

public class BZip2OutputStream
extends OutputStream
implements AutoCloseable {
    private static final byte[] EOS_MAGIC = new byte[]{23, 114, 69, 56, 80, -112};
    private static final AtomicInteger HASH_CODE_GENERATOR = new AtomicInteger(0);
    private final LittleEndianBitOutputStream m_wrapped;
    private final int m_blockSize;
    private final BlockOutputStream m_blockOutputStream;
    private final EncodedBlockWriter m_encodedBlockWriter;
    private final BZip2EncoderExecutorServiceImpl m_executorService;
    private final boolean m_iCreatedExecutor;
    private final int m_hashCode = HASH_CODE_GENERATOR.getAndIncrement();
    private boolean m_closed;
    private long m_pos = 0L;

    private static void writeFileHeader(OutputStream os, int blockSize) throws IOException {
        os.write(66);
        os.write(90);
        os.write(104);
        os.write(blockSize + 48);
    }

    public BZip2OutputStream(OutputStream wrapped) throws IOException {
        this(wrapped, new BZip2OutputStreamSettings());
    }

    public BZip2OutputStream(OutputStream wrapped, BZip2OutputStreamSettings settings) throws IOException {
        EncodingScratchpad sp;
        wrapped.getClass();
        settings.getClass();
        this.m_wrapped = new LittleEndianBitOutputStream(wrapped);
        this.m_blockSize = settings.getBlockSize() * 100 * 1000;
        BZip2OutputStream.writeFileHeader(wrapped, settings.getBlockSize());
        if (settings.getExecutorService() != null) {
            this.m_executorService = (BZip2EncoderExecutorServiceImpl)settings.getExecutorService();
            this.m_iCreatedExecutor = false;
            this.m_encodedBlockWriter = new EncodedBlockWriter(this.m_wrapped);
            sp = null;
        } else if (settings.getNumberOfEncoderThreads() > 0) {
            this.m_executorService = new BZip2EncoderExecutorServiceImpl(settings.getNumberOfEncoderThreads(), new SingleObserverErrorState());
            this.m_iCreatedExecutor = true;
            this.m_encodedBlockWriter = new EncodedBlockWriter(this.m_wrapped);
            sp = null;
        } else {
            this.m_executorService = null;
            this.m_iCreatedExecutor = false;
            sp = new EncodingScratchpad();
            this.m_encodedBlockWriter = null;
        }
        this.m_blockOutputStream = new BlockOutputStream(this.m_wrapped, this.m_blockSize, settings.getNumberOfHuffmanTreeRefinementIterations(), this.m_executorService, this, this.m_encodedBlockWriter, sp);
    }

    private void assertNotClosed() throws IOException {
        if (this.m_closed) {
            throw new IOException("This stream is closed");
        }
    }

    private void checkErrorState() throws IOException, RuntimeException {
        if (this.m_executorService != null) {
            this.m_executorService.getErrorState().checkAndClearErrors(this);
        }
    }

    private void debug(String msg) {
    }

    private void writeEosBlock() throws IOException {
        for (byte b : EOS_MAGIC) {
            this.m_wrapped.writeBitsLittleEndian(b & 0xFF, 8);
        }
        this.m_wrapped.writeBitsLittleEndian(this.m_blockOutputStream.getFileChecksum(), 32);
        this.m_wrapped.padToByteBoundary();
    }

    @Override
    public void write(int b) throws IOException {
        this.assertNotClosed();
        this.checkErrorState();
        ++this.m_pos;
        this.m_blockOutputStream.write(b & 0xFF);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.assertNotClosed();
        this.checkErrorState();
        this.m_pos += (long)data.length;
        this.m_blockOutputStream.write(data);
    }

    @Override
    public void write(byte[] data, int offset, int len) throws IOException, IndexOutOfBoundsException {
        this.assertNotClosed();
        this.checkErrorState();
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset: " + offset);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Length: " + len);
        }
        if (offset + len > data.length) {
            throw new IndexOutOfBoundsException("Offset: " + offset + " + Length: " + len + " > length of data: " + data.length);
        }
        this.m_pos += (long)len;
        this.m_blockOutputStream.write(data, offset, len);
    }

    @Override
    public void close() throws IOException {
        this.checkErrorState();
        if (!this.m_closed) {
            this.m_blockOutputStream.close();
            if (this.m_pos > 0L && this.m_encodedBlockWriter != null) {
                try {
                    this.m_encodedBlockWriter.waitFor();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted. The output file is most likely corrupted.");
                }
                this.checkErrorState();
            }
            this.writeEosBlock();
            this.m_wrapped.close();
            this.debug("Original size: " + this.m_pos + ", compressed size: " + this.m_wrapped.getNumberOfBytesWritten());
            if (this.m_iCreatedExecutor && this.m_executorService != null) {
                this.m_executorService.shutdown();
            }
            this.m_closed = true;
            super.close();
        }
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public static BZip2EncoderExecutorService createExecutorService(int noThreads) {
        return new BZip2EncoderExecutorServiceImpl(noThreads, new MultipleObserverErrorState());
    }

    public static BZip2EncoderExecutorService createExecutorService() {
        return BZip2OutputStream.createExecutorService(Runtime.getRuntime().availableProcessors());
    }
}

