/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.util.Arrays;
import org.at4j.comp.bzip2.BlockEncodedCallback;
import org.at4j.comp.bzip2.BurrowsWheelerEncoder;
import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.comp.bzip2.HighValueBranchHuffmanTree;
import org.at4j.support.comp.IntMoveToFront;
import org.at4j.support.io.BitOutput;

final class BlockEncoder {
    private static final byte[] BLOCK_MAGIC = new byte[]{49, 65, 89, 38, 83, 89};
    private static final int MAX_HUFFMAN_BIT_LENGTH = 17;
    private static final int RUNA_SYMBOL = 0;
    private static final int RUNB_SYMBOL = 1;
    private static final int MIN_NO_OF_HUFFMAN_TREES = 2;
    static final int MAX_NO_OF_HUFFMAN_TREES = 6;
    static final int MAX_NO_OF_MTF_SYMBOLS = 258;
    static final int NO_OF_SYMBOLS_PER_SEGMENT = 50;
    static final int[][] CATEGORY_PER_NO_OF_TREES_AND_PERCENTAGE = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}};
    private static final byte[] INITIAL_MTF_ALPHABET = new byte[258];
    private final byte[] m_block;
    private final int m_blockNo;
    private final int m_blockSize;
    private final int m_blockChecksum;
    private final boolean[] m_seenDifferentBytes;
    private final int m_numberOfSeenDifferentBytes;
    private final int m_numberOfHuffmanTreeRefinementIterations;
    private final BitOutput m_out;
    private final BlockEncodedCallback m_blockEncoderCallback;
    private EncodingScratchpad m_scratchpad;

    BlockEncoder(byte[] block, int blockNo, int blockSize, int blockChecksum, boolean[] seenDifferentBytes, int numberOfSeenDifferentBytes, int numberOfHuffmanTreeRefinementIterations, BitOutput out, BlockEncodedCallback bec) {
        this.m_block = block;
        this.m_blockNo = blockNo;
        this.m_blockSize = blockSize;
        this.m_blockChecksum = blockChecksum;
        this.m_seenDifferentBytes = seenDifferentBytes;
        this.m_numberOfSeenDifferentBytes = numberOfSeenDifferentBytes;
        this.m_numberOfHuffmanTreeRefinementIterations = numberOfHuffmanTreeRefinementIterations;
        this.m_out = out;
        this.m_blockEncoderCallback = bec;
    }

    void setScratchpad(EncodingScratchpad sp) {
        this.m_scratchpad = sp;
    }

    private byte[] getSeenByteValues() {
        byte[] res = new byte[this.m_numberOfSeenDifferentBytes];
        int j = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.m_seenDifferentBytes[i]) continue;
            res[j++] = (byte)(i & 0xFF);
        }
        assert (j == this.m_numberOfSeenDifferentBytes);
        return res;
    }

    static int addRunaAndRunb(int[] res, int outIndex, int no) {
        int noWritten = 0;
        while (no > 0) {
            switch (no % 2) {
                case 1: {
                    res[outIndex + noWritten++] = 0;
                    --no;
                    break;
                }
                case 0: {
                    res[outIndex + noWritten++] = 1;
                    no -= 2;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            no >>>= 1;
        }
        return noWritten;
    }

    private byte[] createSequenceMap(byte[] symbols) {
        byte[] res = this.m_scratchpad.m_sequenceMap;
        int index = 0;
        for (byte i : symbols) {
            int n = index;
            index = (byte)(index + 1);
            res[i & 0xFF] = n;
        }
        return res;
    }

    private MTFAndRLEResult moveToFrontAndRunLengthEncode(byte[] data, int dataLen, byte[] symbols) {
        boolean[] seenSymbols = new boolean[259];
        seenSymbols[0] = true;
        seenSymbols[1] = true;
        int noSeenSymbols = 2;
        byte[] mtfAlphabet = this.m_scratchpad.m_mtfAlphabet;
        System.arraycopy(INITIAL_MTF_ALPHABET, 0, mtfAlphabet, 0, mtfAlphabet.length);
        int[] encodedData = this.m_scratchpad.m_encodedData;
        byte[] sequenceMap = this.createSequenceMap(symbols);
        byte lastSymbolIndex = 0;
        int curOutArrayIndex = 0;
        int noSame = 0;
        for (int curInArrayIndex = 0; curInArrayIndex < dataLen; ++curInArrayIndex) {
            byte curSymbolIndex = sequenceMap[data[curInArrayIndex] & 0xFF];
            if (curSymbolIndex == lastSymbolIndex) {
                ++noSame;
                continue;
            }
            if (noSame > 0) {
                curOutArrayIndex += BlockEncoder.addRunaAndRunb(this.m_scratchpad.m_encodedData, curOutArrayIndex, noSame);
                noSame = 0;
            }
            int j = 0;
            byte lastMtf = mtfAlphabet[0];
            while (mtfAlphabet[++j] != curSymbolIndex) {
                byte nextLastMtf = mtfAlphabet[j];
                mtfAlphabet[j] = lastMtf;
                lastMtf = nextLastMtf;
            }
            mtfAlphabet[j] = lastMtf;
            mtfAlphabet[0] = curSymbolIndex;
            int symbolVal = j + 1;
            encodedData[curOutArrayIndex++] = symbolVal;
            if (!seenSymbols[symbolVal]) {
                seenSymbols[symbolVal] = true;
                ++noSeenSymbols;
            }
            lastSymbolIndex = curSymbolIndex;
        }
        if (noSame > 0) {
            curOutArrayIndex += BlockEncoder.addRunaAndRunb(encodedData, curOutArrayIndex, noSame);
        }
        return new MTFAndRLEResult(encodedData, curOutArrayIndex, noSeenSymbols);
    }

    private void encodeAllSegmentsWithAllTrees(int[] data, int dataLen, int[][] codeLengths, int numberOfHuffmanSegments, int numberOfDifferentSymbols, EncodeAllSegmentsResult res) throws IOException {
        int noTrees = codeLengths.length;
        int[][] encodingResults = this.m_scratchpad.m_encodingResults;
        int[] treesUsed = new int[numberOfHuffmanSegments];
        int shortestLength = Integer.MAX_VALUE;
        int longestLength = 0;
        for (int segmentNo = 0; segmentNo < numberOfHuffmanSegments; ++segmentNo) {
            int shortestLengthForSegment = Integer.MAX_VALUE;
            int bestTreeIndex = 0;
            int[] segmentEncodingResultPerTree = new int[noTrees];
            int segmentStart = segmentNo * 50;
            int segmentEnd = Math.min(segmentStart + 50, dataLen);
            for (int treeNo = 0; treeNo < noTrees; ++treeNo) {
                int[] curTreeCodeLengths = codeLengths[treeNo];
                int bitLen = 0;
                for (int j = segmentStart; j < segmentEnd; ++j) {
                    bitLen += curTreeCodeLengths[data[j]];
                }
                if (treeNo == 0) {
                    shortestLengthForSegment = bitLen;
                } else if (bitLen < shortestLengthForSegment) {
                    shortestLengthForSegment = bitLen;
                    bestTreeIndex = treeNo;
                }
                segmentEncodingResultPerTree[treeNo] = bitLen;
            }
            if (segmentNo == 0) {
                shortestLength = longestLength = shortestLengthForSegment;
            } else if (segmentNo < numberOfHuffmanSegments - 1 && shortestLengthForSegment < shortestLength) {
                shortestLength = shortestLengthForSegment;
            } else if (shortestLengthForSegment > longestLength) {
                longestLength = shortestLengthForSegment;
            }
            encodingResults[segmentNo] = segmentEncodingResultPerTree;
            treesUsed[segmentNo] = bestTreeIndex;
        }
        res.m_encodingResults = encodingResults;
        res.m_longestLength = longestLength;
        res.m_shortestLength = shortestLength;
        res.m_treesUsed = treesUsed;
    }

    private int[][] createNewTrees(int[] data, int dataLen, int eobSymbol, int numberOfHuffmanTrees, int numberOfSegments, EncodeAllSegmentsResult easr, int[] globallyOptimalTree) {
        int i;
        int[][] frequencies = this.m_scratchpad.m_frequencies2d;
        for (int i2 = 0; i2 < numberOfHuffmanTrees; ++i2) {
            Arrays.fill(frequencies[i2], 0);
        }
        int maxDistance = easr.m_longestLength - easr.m_shortestLength;
        if (maxDistance == 0) {
            return new int[][]{globallyOptimalTree};
        }
        int numberOfCategories = numberOfHuffmanTrees;
        int[] categoryPerSegment = this.m_scratchpad.m_categoriesPerSegment;
        int[] noSegmentsPerCategory = new int[numberOfCategories];
        int[] catArray = CATEGORY_PER_NO_OF_TREES_AND_PERCENTAGE[numberOfHuffmanTrees - 2];
        for (i = 0; i < numberOfSegments - 1; ++i) {
            int catNo;
            int segmentLen = easr.m_encodingResults[i][easr.m_treesUsed[i]];
            int percentage = 100 * (segmentLen - easr.m_shortestLength) / maxDistance;
            assert (percentage >= 0);
            assert (percentage <= 100);
            int n = catNo = catArray[percentage];
            noSegmentsPerCategory[n] = noSegmentsPerCategory[n] + 1;
            categoryPerSegment[i] = catNo;
        }
        for (i = 0; i < numberOfSegments; ++i) {
            int segmentStart = i * 50;
            int segmentEnd = Math.min(segmentStart + 50, dataLen);
            int[] curCatFreqs = frequencies[categoryPerSegment[i]];
            for (int j = segmentStart; j < segmentEnd; ++j) {
                int n = data[j];
                curCatFreqs[n] = curCatFreqs[n] + 1;
            }
        }
        int noNewTrees = 0;
        for (int i3 = 0; i3 < numberOfCategories; ++i3) {
            if (noSegmentsPerCategory[i3] <= 0) continue;
            ++noNewTrees;
        }
        assert (noNewTrees > 0);
        int[][] res = new int[noNewTrees][];
        int treeNo = 0;
        for (int i4 = 0; i4 < numberOfCategories; ++i4) {
            if (noSegmentsPerCategory[i4] <= 0) continue;
            res[treeNo++] = HighValueBranchHuffmanTree.createCodeLengths(frequencies[i4], eobSymbol + 1, 17, this.m_scratchpad);
        }
        return res;
    }

    private int[][] refineTreesBasedOnEncodingResults(int[] data, int dataLen, int[][] codeLengths, EncodeAllSegmentsResult easr, int eobSymbol) {
        int[][] frequencies = this.m_scratchpad.m_frequencies2d;
        for (int i = 0; i < codeLengths.length; ++i) {
            Arrays.fill(frequencies[i], 0);
        }
        int segmentNo = 0;
        int noInSegment = 0;
        int curTree = easr.m_treesUsed[segmentNo];
        for (int i = 0; i < dataLen; ++i) {
            int symbolVal = data[i];
            int[] nArray = frequencies[curTree];
            int n = symbolVal;
            nArray[n] = nArray[n] + 1;
            if (++noInSegment != 50) continue;
            if (++segmentNo < easr.m_treesUsed.length) {
                curTree = easr.m_treesUsed[segmentNo];
            }
            noInSegment = 0;
        }
        int[][] res = new int[codeLengths.length][];
        for (int i = 0; i < codeLengths.length; ++i) {
            res[i] = HighValueBranchHuffmanTree.createCodeLengths(frequencies[i], eobSymbol + 1, 17, this.m_scratchpad);
        }
        return res;
    }

    private byte getNumberOfHuffmanTrees(int noSegments) {
        if (noSegments < 200) {
            return 2;
        }
        if (noSegments < 600) {
            return 3;
        }
        if (noSegments < 1200) {
            return 4;
        }
        if (noSegments < 2400) {
            return 5;
        }
        return 6;
    }

    private int[] getMinAndMaxCodeLengths(int[] codeLengths) {
        int minLength = codeLengths[0];
        int maxLength = codeLengths[0];
        for (int i = 1; i < codeLengths.length; ++i) {
            if (codeLengths[i] < minLength) {
                minLength = codeLengths[i];
                continue;
            }
            if (codeLengths[i] <= maxLength) continue;
            maxLength = codeLengths[i];
        }
        return new int[]{minLength, maxLength};
    }

    private HuffmanTreesAndUsage createHuffmanTrees(int[] data, int dataLen, int noSymbolsUsed) throws IOException {
        HuffmanTreesAndUsage res = new HuffmanTreesAndUsage();
        res.m_noHuffmanSegments = (dataLen - 1 + 1) / 50 + 1;
        int[] frequencies = this.m_scratchpad.m_frequencies;
        Arrays.fill(frequencies, 0);
        int maxSymbolValue = 1;
        for (int j = 0; j < dataLen; ++j) {
            int symbolVal;
            int n = symbolVal = data[j];
            frequencies[n] = frequencies[n] + 1;
            if (symbolVal <= maxSymbolValue) continue;
            maxSymbolValue = symbolVal;
        }
        res.m_eobSymbol = maxSymbolValue + 1;
        frequencies[res.m_eobSymbol] = 1;
        data[dataLen] = res.m_eobSymbol;
        int dataLenIncEob = dataLen + 1;
        if (res.m_noHuffmanSegments < 2) {
            res.m_trees = new HighValueBranchHuffmanTree[2];
            int[] codeLengths = HighValueBranchHuffmanTree.createCodeLengths(frequencies, res.m_eobSymbol + 1, 17, this.m_scratchpad);
            int[] minAndMaxLength = this.getMinAndMaxCodeLengths(codeLengths);
            HighValueBranchHuffmanTree tree = new HighValueBranchHuffmanTree(codeLengths, minAndMaxLength[0], minAndMaxLength[1], true);
            for (int i = 0; i < 2; ++i) {
                res.m_trees[i] = tree;
            }
            res.m_treeUsage = new int[res.m_noHuffmanSegments];
        } else {
            int[][][] huffmanCodeLengths = new int[this.m_numberOfHuffmanTreeRefinementIterations + 1][][];
            int[] codeLengthsForGloballyOptimalTree = HighValueBranchHuffmanTree.createCodeLengths(frequencies, res.m_eobSymbol + 1, 17, this.m_scratchpad);
            EncodeAllSegmentsResult easr = new EncodeAllSegmentsResult();
            this.encodeAllSegmentsWithAllTrees(data, dataLen, new int[][]{codeLengthsForGloballyOptimalTree}, res.m_noHuffmanSegments, res.m_eobSymbol + 1, easr);
            huffmanCodeLengths[0] = this.createNewTrees(data, dataLen, res.m_eobSymbol, this.getNumberOfHuffmanTrees(res.m_noHuffmanSegments), res.m_noHuffmanSegments, easr, codeLengthsForGloballyOptimalTree);
            int bestIndex = -1;
            int bestLength = Integer.MAX_VALUE;
            int[] bestTreeUsage = null;
            for (int i = 0; i < huffmanCodeLengths.length; ++i) {
                if (i > 0) {
                    huffmanCodeLengths[i] = this.refineTreesBasedOnEncodingResults(data, dataLenIncEob, huffmanCodeLengths[i - 1], easr, res.m_eobSymbol);
                }
                this.encodeAllSegmentsWithAllTrees(data, dataLenIncEob, huffmanCodeLengths[i], res.m_noHuffmanSegments, res.m_eobSymbol + 1, easr);
                int totLen = 0;
                for (int j = 0; j < easr.m_treesUsed.length; ++j) {
                    totLen += easr.m_encodingResults[j][easr.m_treesUsed[j]];
                }
                if (totLen >= bestLength) continue;
                bestIndex = i;
                bestLength = totLen;
                bestTreeUsage = easr.m_treesUsed;
            }
            int noTrees = huffmanCodeLengths[bestIndex].length;
            if (noTrees < 2) {
                res.m_trees = new HighValueBranchHuffmanTree[2];
                int[] minAndMaxLength = this.getMinAndMaxCodeLengths(huffmanCodeLengths[bestIndex][0]);
                for (int i = 0; i < 2; ++i) {
                    res.m_trees[i] = new HighValueBranchHuffmanTree(huffmanCodeLengths[bestIndex][0], minAndMaxLength[0], minAndMaxLength[1], true);
                }
            } else {
                res.m_trees = new HighValueBranchHuffmanTree[huffmanCodeLengths[bestIndex].length];
                for (int i = 0; i < huffmanCodeLengths[bestIndex].length; ++i) {
                    int[] minAndMaxLengths = this.getMinAndMaxCodeLengths(huffmanCodeLengths[bestIndex][i]);
                    res.m_trees[i] = new HighValueBranchHuffmanTree(huffmanCodeLengths[bestIndex][i], minAndMaxLengths[0], minAndMaxLengths[1], true);
                }
            }
            res.m_treeUsage = bestTreeUsage;
        }
        return res;
    }

    static void encodeHuffmanTree(HighValueBranchHuffmanTree tree, int numberOfDifferentSymbols, BitOutput out) throws IOException {
        int len = tree.getBitLength(0);
        out.writeBitsLittleEndian(len, 5);
        for (int j = 0; j < numberOfDifferentSymbols; ++j) {
            int prevLen = len;
            len = tree.getBitLength(j);
            while (len != prevLen) {
                out.writeBit(true);
                if (prevLen < len) {
                    out.writeBit(false);
                    ++prevLen;
                    continue;
                }
                out.writeBit(true);
                --prevLen;
            }
            out.writeBit(false);
        }
    }

    private void writeBlockHeader(int blockChecksum, int bwFirstPointer, boolean[] seenDifferentBytes, MTFAndRLEResult mtfrle, HuffmanTreesAndUsage htau) throws IOException {
        int i;
        int i2;
        for (byte b : BLOCK_MAGIC) {
            this.m_out.writeBitsLittleEndian(b & 0xFF, 8);
        }
        this.m_out.writeBitsLittleEndian(blockChecksum, 32);
        this.m_out.writeBit(false);
        this.m_out.writeBitsLittleEndian(bwFirstPointer, 24);
        boolean[] segmentsWithData = new boolean[16];
        boolean[][] seenData = new boolean[16][16];
        for (i2 = 0; i2 < 256; ++i2) {
            if (!seenDifferentBytes[i2]) continue;
            segmentsWithData[i2 / 16] = true;
            seenData[i2 / 16][i2 % 16] = true;
        }
        for (i2 = 0; i2 < 16; ++i2) {
            this.m_out.writeBit(segmentsWithData[i2]);
        }
        for (i2 = 0; i2 < 16; ++i2) {
            if (!segmentsWithData[i2]) continue;
            for (int j = 0; j < 16; ++j) {
                this.m_out.writeBit(seenData[i2][j]);
            }
        }
        this.m_out.writeBits(htau.m_trees.length, 3);
        this.m_out.writeBitsLittleEndian(htau.m_noHuffmanSegments, 15);
        int[] mtfAlpha = new int[htau.m_trees.length];
        for (int i3 = 0; i3 < htau.m_trees.length; ++i3) {
            mtfAlpha[i3] = i3;
        }
        int[] treeUsageMtf = new int[htau.m_noHuffmanSegments];
        new IntMoveToFront(mtfAlpha).encode(htau.m_treeUsage, treeUsageMtf);
        for (i = 0; i < htau.m_noHuffmanSegments; ++i) {
            for (int val = 0; val < treeUsageMtf[i]; ++val) {
                this.m_out.writeBit(true);
            }
            this.m_out.writeBit(false);
        }
        for (i = 0; i < htau.m_trees.length; ++i) {
            BlockEncoder.encodeHuffmanTree(htau.m_trees[i], htau.m_eobSymbol + 1, this.m_out);
        }
    }

    void encode() throws IOException {
        int noToCopy;
        for (int noCopied = 0; noCopied < 20; noCopied += noToCopy) {
            noToCopy = Math.min(20 - noCopied, this.m_blockSize);
            System.arraycopy(this.m_block, 0, this.m_block, this.m_blockSize + noCopied, noToCopy);
        }
        BurrowsWheelerEncoder.BurrowsWheelerEncodingResult burrWhee = new BurrowsWheelerEncoder(this.m_block, this.m_blockSize, this.m_scratchpad).encode();
        MTFAndRLEResult rleMtfSymbols = this.moveToFrontAndRunLengthEncode(burrWhee.m_lastColumn, this.m_blockSize, this.getSeenByteValues());
        int[] encodedData = rleMtfSymbols.m_encodedData;
        HuffmanTreesAndUsage htau = this.createHuffmanTrees(rleMtfSymbols.m_encodedData, rleMtfSymbols.m_dataLen, rleMtfSymbols.m_noSeenDifferentSymbols);
        this.writeBlockHeader(this.m_blockChecksum, burrWhee.m_firstPointer, this.m_seenDifferentBytes, rleMtfSymbols, htau);
        int swapNo = 0;
        int noLeftUntilSwap = 1;
        HighValueBranchHuffmanTree curTree = null;
        for (int i = 0; i < rleMtfSymbols.m_dataLen + 1; ++i) {
            if (--noLeftUntilSwap == 0) {
                curTree = htau.m_trees[htau.m_treeUsage[swapNo++]];
                noLeftUntilSwap = 50;
            }
            curTree.write(this.m_out, encodedData[i]);
        }
        assert (swapNo == htau.m_noHuffmanSegments);
        if (this.m_blockEncoderCallback != null) {
            this.m_blockEncoderCallback.reportBlockDone();
        }
    }

    static {
        for (int i = 0; i < INITIAL_MTF_ALPHABET.length; ++i) {
            BlockEncoder.INITIAL_MTF_ALPHABET[i] = (byte)(i & 0xFF);
        }
    }

    private static class MTFAndRLEResult {
        private final int[] m_encodedData;
        private final int m_dataLen;
        private final int m_noSeenDifferentSymbols;

        private MTFAndRLEResult(int[] symbols, int dataLen, int noSeenDifferentSymbols) {
            this.m_encodedData = symbols;
            this.m_dataLen = dataLen;
            this.m_noSeenDifferentSymbols = noSeenDifferentSymbols;
        }
    }

    private static class EncodeAllSegmentsResult {
        private int m_shortestLength;
        private int m_longestLength;
        private int[][] m_encodingResults;
        private int[] m_treesUsed;

        private EncodeAllSegmentsResult() {
        }
    }

    private static class HuffmanTreesAndUsage {
        private HighValueBranchHuffmanTree[] m_trees;
        private int m_noHuffmanSegments;
        private int[] m_treeUsage;
        private int m_eobSymbol;

        private HuffmanTreesAndUsage() {
        }
    }
}

