/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import org.at4j.comp.bzip2.BlockEncoder;
import org.at4j.comp.bzip2.EncodingThread;

final class BlockEncoderRunnable
implements Runnable {
    private final BlockEncoder m_encoder;
    private final Object m_errorOwner;

    BlockEncoderRunnable(BlockEncoder be, Object errorOwner) {
        this.m_encoder = be;
        this.m_errorOwner = errorOwner;
    }

    @Override
    public void run() {
        try {
            this.m_encoder.setScratchpad(((EncodingThread)Thread.currentThread()).getScratchpad());
            this.m_encoder.encode();
        }
        catch (IOException | Error | RuntimeException e) {
            ((EncodingThread)Thread.currentThread()).getErrorState().registerError(e, this.m_errorOwner);
        }
    }
}

