/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.util.Arrays;
import org.at4j.comp.bzip2.EncodingScratchpad;

final class ThreeWayRadixQuicksort {
    static final int DATA_OVERSHOOT = 20;
    private static final int QUICKSORT_DEPTH_THRESHOLD = 18;
    static final int SORT_STACK_SIZE = 100;
    private static final int[] SHELL_SORT_INCREMENTS = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private final byte[] m_data;
    private final int m_length;
    private final int m_minLengthForQuicksort;
    private final EncodingScratchpad m_scratchpad;
    private final int[] m_sortCache;
    private final QuickSortRangeInfo[] m_sortStack;
    private int m_sortStackPointer = -1;
    final int[] m_ptr;

    ThreeWayRadixQuicksort(byte[] data, int length, int minLengthForQuicksort, EncodingScratchpad sp) throws IllegalArgumentException {
        assert (data.length >= length + 20);
        if (length > data.length) {
            throw new IllegalArgumentException("Invalid data length " + length + ". It must be <= the length of the data array (" + data.length + ")");
        }
        if (minLengthForQuicksort < 3) {
            throw new IllegalArgumentException("Invalid minimum length for Quicksort " + minLengthForQuicksort + ". It must be >= 3");
        }
        this.m_data = data;
        this.m_length = length;
        this.m_minLengthForQuicksort = minLengthForQuicksort;
        this.m_scratchpad = sp;
        this.m_sortStack = this.m_scratchpad.m_sortStack;
        this.m_sortCache = this.m_scratchpad.m_sortCache;
        Arrays.fill(this.m_sortCache, 0);
        this.m_ptr = this.m_scratchpad.m_ptrs;
    }

    private int getDataAt(int pos) {
        return this.m_data[pos] & 0xFF;
    }

    int[] radixSort() {
        int i;
        int[] frequencies = this.m_scratchpad.m_twoByteFrequencies;
        Arrays.fill(frequencies, 0);
        int val = this.getDataAt(0) << 8;
        for (i = this.m_length - 1; i >= 0; --i) {
            int n = val = val >>> 8 | this.getDataAt(i) << 8;
            frequencies[n] = frequencies[n] + 1;
        }
        for (i = 1; i < 65536; ++i) {
            int n = i;
            frequencies[n] = frequencies[n] + frequencies[i - 1];
        }
        val = this.getDataAt(0) << 8;
        i = this.m_length - 1;
        while (i >= 0) {
            int n = val = val >>> 8 | this.getDataAt(i) << 8;
            int n2 = frequencies[n] - 1;
            frequencies[n] = n2;
            int pos = n2;
            this.m_ptr[pos] = i--;
        }
        return frequencies;
    }

    private int med3(int pos1, int pos2, int pos3, int depth) {
        int v2;
        int v1 = this.getDataAt(this.m_ptr[pos1] + depth);
        if (v1 == (v2 = this.getDataAt(this.m_ptr[pos2] + depth))) {
            return pos1;
        }
        int v3 = this.getDataAt(this.m_ptr[pos3] + depth);
        if (v3 == v1 || v3 == v2) {
            return pos3;
        }
        return v1 < v2 ? (v2 < v3 ? pos2 : (v1 < v3 ? pos3 : pos1)) : (v2 > v3 ? pos2 : (v1 < v3 ? pos1 : pos3));
    }

    private int selectPivot(QuickSortRangeInfo qsri) {
        int pos1 = qsri.m_bucketStartPos;
        int pos3 = pos1 + qsri.m_bucketLen - 1;
        int pos2 = (pos1 + pos3) / 2;
        if (qsri.m_bucketLen > 500) {
            int d = qsri.m_bucketLen / 8;
            pos1 = this.med3(pos1, pos1 + d, pos1 + 2 * d, qsri.m_depth);
            pos2 = this.med3(pos2 - d, pos2, pos2 + d, qsri.m_depth);
            pos3 = this.med3(pos3 - 2 * d, pos3 - d, pos3, qsri.m_depth);
        }
        return this.med3(pos1, pos2, pos3, qsri.m_depth);
    }

    private void swap(int pos1, int pos2) {
        int v1 = this.m_ptr[pos1];
        this.m_ptr[pos1] = this.m_ptr[pos2];
        this.m_ptr[pos2] = v1;
    }

    void shellSortRange(QuickSortRangeInfo qsri) {
        int len = qsri.m_bucketLen;
        int depth = qsri.m_depth;
        int startPos = qsri.m_bucketStartPos;
        int endPos = startPos + len;
        int incMax = 1;
        while (SHELL_SORT_INCREMENTS[incMax] < len) {
            ++incMax;
        }
        for (int incrementPtr = incMax - 1; incrementPtr >= 0; --incrementPtr) {
            int startIter;
            int increment = SHELL_SORT_INCREMENTS[incrementPtr];
            block2: for (int i = startIter = startPos + increment; i < endPos; ++i) {
                for (int j = i; j >= startIter; j -= increment) {
                    int curPos2;
                    int curPos1;
                    block7: {
                        block8: {
                            block9: {
                                block10: {
                                    block11: {
                                        block12: {
                                            block13: {
                                                block14: {
                                                    block15: {
                                                        block16: {
                                                            block17: {
                                                                block18: {
                                                                    block19: {
                                                                        block20: {
                                                                            block21: {
                                                                                block22: {
                                                                                    int curDepth = depth;
                                                                                    curPos1 = this.m_ptr[j - increment] + depth - 1;
                                                                                    curPos2 = this.m_ptr[j] + depth - 1;
                                                                                    while (true) {
                                                                                        if (curPos1 >= this.m_length) {
                                                                                            curPos1 -= this.m_length;
                                                                                            continue;
                                                                                        }
                                                                                        while (curPos2 >= this.m_length) {
                                                                                            curPos2 -= this.m_length;
                                                                                        }
                                                                                        if (this.getDataAt(++curPos1) != this.getDataAt(++curPos2)) break block7;
                                                                                        if (this.m_sortCache[curPos1] != this.m_sortCache[curPos2]) break block8;
                                                                                        if (this.getDataAt(++curPos1) != this.getDataAt(++curPos2)) break block9;
                                                                                        if (this.m_sortCache[curPos1] != this.m_sortCache[curPos2]) break block10;
                                                                                        if (this.getDataAt(++curPos1) != this.getDataAt(++curPos2)) break block11;
                                                                                        if (this.m_sortCache[curPos1] != this.m_sortCache[curPos2]) break block12;
                                                                                        if (this.getDataAt(++curPos1) != this.getDataAt(++curPos2)) break block13;
                                                                                        if (this.m_sortCache[curPos1] != this.m_sortCache[curPos2]) break block14;
                                                                                        if (this.getDataAt(++curPos1) != this.getDataAt(++curPos2)) break block15;
                                                                                        if (this.m_sortCache[curPos1] != this.m_sortCache[curPos2]) break block16;
                                                                                        if (this.getDataAt(++curPos1) != this.getDataAt(++curPos2)) break block17;
                                                                                        if (this.m_sortCache[curPos1] != this.m_sortCache[curPos2]) break block18;
                                                                                        if (this.getDataAt(++curPos1) != this.getDataAt(++curPos2)) break block19;
                                                                                        if (this.m_sortCache[curPos1] != this.m_sortCache[curPos2]) break block20;
                                                                                        if (this.getDataAt(++curPos1) != this.getDataAt(++curPos2)) break block21;
                                                                                        if (this.m_sortCache[curPos1] != this.m_sortCache[curPos2]) break block22;
                                                                                        if ((curDepth += 8) >= this.m_length) break;
                                                                                    }
                                                                                    continue block2;
                                                                                }
                                                                                if (this.m_sortCache[curPos1] < this.m_sortCache[curPos2]) continue block2;
                                                                                this.swap(j - increment, j);
                                                                                continue;
                                                                            }
                                                                            if (this.getDataAt(curPos1) < this.getDataAt(curPos2)) continue block2;
                                                                            this.swap(j - increment, j);
                                                                            continue;
                                                                        }
                                                                        if (this.m_sortCache[curPos1] < this.m_sortCache[curPos2]) continue block2;
                                                                        this.swap(j - increment, j);
                                                                        continue;
                                                                    }
                                                                    if (this.getDataAt(curPos1) < this.getDataAt(curPos2)) continue block2;
                                                                    this.swap(j - increment, j);
                                                                    continue;
                                                                }
                                                                if (this.m_sortCache[curPos1] < this.m_sortCache[curPos2]) continue block2;
                                                                this.swap(j - increment, j);
                                                                continue;
                                                            }
                                                            if (this.getDataAt(curPos1) < this.getDataAt(curPos2)) continue block2;
                                                            this.swap(j - increment, j);
                                                            continue;
                                                        }
                                                        if (this.m_sortCache[curPos1] < this.m_sortCache[curPos2]) continue block2;
                                                        this.swap(j - increment, j);
                                                        continue;
                                                    }
                                                    if (this.getDataAt(curPos1) < this.getDataAt(curPos2)) continue block2;
                                                    this.swap(j - increment, j);
                                                    continue;
                                                }
                                                if (this.m_sortCache[curPos1] < this.m_sortCache[curPos2]) continue block2;
                                                this.swap(j - increment, j);
                                                continue;
                                            }
                                            if (this.getDataAt(curPos1) < this.getDataAt(curPos2)) continue block2;
                                            this.swap(j - increment, j);
                                            continue;
                                        }
                                        if (this.m_sortCache[curPos1] < this.m_sortCache[curPos2]) continue block2;
                                        this.swap(j - increment, j);
                                        continue;
                                    }
                                    if (this.getDataAt(curPos1) < this.getDataAt(curPos2)) continue block2;
                                    this.swap(j - increment, j);
                                    continue;
                                }
                                if (this.m_sortCache[curPos1] < this.m_sortCache[curPos2]) continue block2;
                                this.swap(j - increment, j);
                                continue;
                            }
                            if (this.getDataAt(curPos1) < this.getDataAt(curPos2)) continue block2;
                            this.swap(j - increment, j);
                            continue;
                        }
                        if (this.m_sortCache[curPos1] < this.m_sortCache[curPos2]) continue block2;
                        this.swap(j - increment, j);
                        continue;
                    }
                    if (this.getDataAt(curPos1) < this.getDataAt(curPos2)) continue block2;
                    this.swap(j - increment, j);
                }
            }
        }
    }

    private int getPositionOfFirstDifferingValue(int bucketStartPos, int bucketLen, int depth) {
        assert (depth <= 20);
        int c0 = this.getDataAt(this.m_ptr[bucketStartPos] + depth);
        int upperBound = bucketStartPos + bucketLen;
        for (int i = bucketStartPos + 1; i < upperBound; ++i) {
            if (this.getDataAt(this.m_ptr[i] + depth) == c0) continue;
            return i;
        }
        return -1;
    }

    private void swapRanges(int r1Start, int r2Start, int len) {
        assert (r1Start + len <= r2Start);
        if (this.m_scratchpad.m_tempArea.length < len) {
            this.m_scratchpad.m_tempArea = new int[len + 100];
        }
        System.arraycopy(this.m_ptr, r1Start, this.m_scratchpad.m_tempArea, 0, len);
        System.arraycopy(this.m_ptr, r2Start, this.m_ptr, r1Start, len);
        System.arraycopy(this.m_scratchpad.m_tempArea, 0, this.m_ptr, r2Start, len);
    }

    private void addRangeToStack(int bucketStartPos, int bucketLen, int depth) {
        if (bucketLen >= 2) {
            this.m_sortStack[++this.m_sortStackPointer] = new QuickSortRangeInfo(bucketStartPos, bucketLen, depth);
        }
    }

    void quickSortRange(QuickSortRangeInfo qsri) {
        int hiRangeLen;
        int hiPtr;
        int pivot = this.selectPivot(qsri);
        this.swap(qsri.m_bucketStartPos, pivot);
        int sortDepth = qsri.m_depth;
        assert (sortDepth < 20);
        int posAtFirstDifferingValue = this.getPositionOfFirstDifferingValue(qsri.m_bucketStartPos, qsri.m_bucketLen, sortDepth);
        while (posAtFirstDifferingValue == -1) {
            if (sortDepth == this.m_length) {
                return;
            }
            if (++sortDepth < 18) {
                posAtFirstDifferingValue = this.getPositionOfFirstDifferingValue(qsri.m_bucketStartPos, qsri.m_bucketLen, sortDepth);
                continue;
            }
            this.shellSortRange(qsri);
            return;
        }
        int lowPtr = posAtFirstDifferingValue;
        int lowPivotRangePtr = posAtFirstDifferingValue;
        int hiPivotRangePtr = hiPtr = qsri.m_bucketStartPos + qsri.m_bucketLen - 1;
        int pivotVal = this.getDataAt(this.m_ptr[qsri.m_bucketStartPos] + sortDepth);
        while (true) {
            int curData;
            if (lowPtr <= hiPtr && (curData = this.getDataAt(this.m_ptr[lowPtr] + sortDepth)) <= pivotVal) {
                if (curData == pivotVal) {
                    this.swap(lowPtr, lowPivotRangePtr++);
                }
                ++lowPtr;
                continue;
            }
            while (lowPtr <= hiPtr && (curData = this.getDataAt(this.m_ptr[hiPtr] + sortDepth)) >= pivotVal) {
                if (curData == pivotVal) {
                    this.swap(hiPtr, hiPivotRangePtr--);
                }
                --hiPtr;
            }
            if (lowPtr > hiPtr) break;
            this.swap(lowPtr++, hiPtr--);
        }
        int lowRangeLen = lowPtr - lowPivotRangePtr;
        int rlen = Math.min(lowPivotRangePtr - qsri.m_bucketStartPos, lowRangeLen);
        if (rlen > 0) {
            this.swapRanges(qsri.m_bucketStartPos, lowPtr - rlen, rlen);
        }
        if ((rlen = Math.min(qsri.m_bucketStartPos + qsri.m_bucketLen - hiPivotRangePtr - 1, hiRangeLen = hiPivotRangePtr - hiPtr)) > 0) {
            this.swapRanges(lowPtr, qsri.m_bucketStartPos + qsri.m_bucketLen - rlen, rlen);
        }
        int pivotRangeLen = qsri.m_bucketLen - lowRangeLen - hiRangeLen;
        this.addRangeToStack(qsri.m_bucketStartPos, lowRangeLen, sortDepth);
        this.addRangeToStack(qsri.m_bucketStartPos + lowRangeLen, pivotRangeLen, sortDepth + 1);
        this.addRangeToStack(qsri.m_bucketStartPos + lowRangeLen + pivotRangeLen, hiRangeLen, sortDepth);
    }

    void sortBucket(int bucketStartPos, int bucketLen, int depth) {
        if (bucketLen < 2) {
            return;
        }
        assert (this.m_sortStackPointer == -1);
        this.m_sortStack[++this.m_sortStackPointer] = new QuickSortRangeInfo(bucketStartPos, bucketLen, depth);
        while (this.m_sortStackPointer >= 0) {
            QuickSortRangeInfo qsri = this.m_sortStack[this.m_sortStackPointer--];
            if (qsri.m_bucketLen < this.m_minLengthForQuicksort || qsri.m_depth > 18) {
                this.shellSortRange(qsri);
                continue;
            }
            this.quickSortRange(qsri);
        }
    }

    private int[] establishSortOrder(int[] bucketStartPositions) {
        int[] sortOrder = this.m_scratchpad.m_sortOrder;
        for (int i = 0; i < 256; ++i) {
            sortOrder[i] = i;
        }
        for (int incPtr = 4; incPtr >= 0; --incPtr) {
            int increment;
            for (int i = increment = SHELL_SORT_INCREMENTS[incPtr]; i < sortOrder.length; ++i) {
                int so2;
                int so1;
                for (int j = i; j >= increment && bucketStartPositions[(so1 = sortOrder[j - increment]) * 256 + 255] - bucketStartPositions[so1 * 256] > bucketStartPositions[(so2 = sortOrder[j]) * 256 + 255] - bucketStartPositions[so2 * 256]; j -= increment) {
                    sortOrder[j] = so1;
                    sortOrder[j - increment] = so2;
                }
            }
        }
        return sortOrder;
    }

    int[] sort() {
        if (this.m_length == 0) {
            return new int[0];
        }
        int[] bucketStartPositions = this.radixSort();
        bucketStartPositions[65536] = this.m_length;
        boolean[] sortedLargeBuckets = this.m_scratchpad.m_sortedLargeBuckets;
        Arrays.fill(sortedLargeBuckets, false);
        boolean[] sortedSmallBuckets = this.m_scratchpad.m_sortedSmallBuckets;
        Arrays.fill(sortedSmallBuckets, false);
        int[] copyStart = this.m_scratchpad.m_copyStart;
        int[] copyEnd = this.m_scratchpad.m_copyEnd;
        int[] sortOrder = this.establishSortOrder(bucketStartPositions);
        for (int largeBucketIndex = 0; largeBucketIndex < 256; ++largeBucketIndex) {
            int index;
            int m;
            int k;
            int i;
            int m2;
            int largeBucketNo = sortOrder[largeBucketIndex];
            for (int smallBucketNo = 0; smallBucketNo < 256; ++smallBucketNo) {
                int bucketIndex;
                if (smallBucketNo == largeBucketNo || sortedSmallBuckets[bucketIndex = largeBucketNo * 256 + smallBucketNo]) continue;
                int bucketStartPos = bucketStartPositions[bucketIndex];
                int bucketLen = bucketStartPositions[bucketIndex + 1] - bucketStartPos;
                if (bucketLen > 1) {
                    this.sortBucket(bucketStartPos, bucketLen, 2);
                }
                sortedSmallBuckets[bucketIndex] = true;
            }
            for (m2 = 0; m2 < 256; ++m2) {
                copyStart[m2] = bucketStartPositions[m2 * 256 + largeBucketNo];
                copyEnd[m2] = bucketStartPositions[m2 * 256 + largeBucketNo + 1] - 1;
            }
            for (i = bucketStartPositions[largeBucketNo * 256]; i < copyStart[largeBucketNo]; ++i) {
                k = this.m_ptr[i] - 1;
                if (k < 0) {
                    k += this.m_length;
                }
                if (sortedLargeBuckets[m = this.getDataAt(k)]) continue;
                int n = m;
                copyStart[n] = copyStart[n] + 1;
                if (index >= this.m_length) {
                    index -= this.m_length;
                }
                this.m_ptr[index] = k;
            }
            for (i = bucketStartPositions[(largeBucketNo + 1) * 256] - 1; i > copyEnd[largeBucketNo]; --i) {
                k = this.m_ptr[i] - 1;
                if (k < 0) {
                    k += this.m_length;
                }
                if (sortedLargeBuckets[m = this.getDataAt(k)]) continue;
                int n = m;
                copyEnd[n] = copyEnd[n] - 1;
                if (index < 0) {
                    index += this.m_length;
                }
                this.m_ptr[index] = k;
            }
            for (m2 = 0; m2 < 256; ++m2) {
                sortedSmallBuckets[m2 * 256 + largeBucketNo] = true;
            }
            sortedLargeBuckets[largeBucketNo] = true;
            if (largeBucketIndex == 255) continue;
            int largeBucketStart = bucketStartPositions[largeBucketNo * 256];
            int largeBucketEnd = largeBucketNo < 255 ? bucketStartPositions[(largeBucketNo + 1) * 256] : this.m_length;
            int largeBucketSize = largeBucketEnd - largeBucketStart;
            assert (largeBucketSize >= 0);
            int shifts = 0;
            while (largeBucketSize >>> shifts > 65534) {
                ++shifts;
            }
            for (int i2 = largeBucketSize - 1; i2 >= 0; --i2) {
                int qval;
                int sptr = this.m_ptr[largeBucketStart + i2];
                this.m_sortCache[sptr] = qval = i2 >>> shifts;
                if (sptr >= 20) continue;
                this.m_sortCache[this.m_length + sptr] = qval;
            }
        }
        return this.m_ptr;
    }

    static class QuickSortRangeInfo {
        private final int m_bucketStartPos;
        private final int m_bucketLen;
        private final int m_depth;

        QuickSortRangeInfo(int bucketStartPos, int bucketLen, int depth) {
            this.m_bucketStartPos = bucketStartPos;
            this.m_bucketLen = bucketLen;
            this.m_depth = depth;
        }
    }
}

