/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

public class SignedInteger
implements Comparable<SignedInteger> {
    public static final SignedInteger ZERO = new SignedInteger(0);
    public static final SignedInteger ONE = new SignedInteger(1);
    private final int m_value;

    private SignedInteger(int value) {
        this.m_value = value;
    }

    public static SignedInteger valueOf(int value) {
        if (value == 0) {
            return ZERO;
        }
        if (value == 1) {
            return ONE;
        }
        return new SignedInteger(value);
    }

    public long intValue() {
        return this.m_value;
    }

    public byte[] getBigEndianByteArray() {
        byte[] res = new byte[]{(byte)this.m_value, (byte)(this.m_value >> 8), (byte)(this.m_value >> 16), (byte)(this.m_value >> 24)};
        return res;
    }

    public static SignedInteger fromBigEndianByteArray(byte[] barr) throws IllegalArgumentException {
        if (barr.length != 4) {
            throw new IllegalArgumentException("Illegal size of supplied byte array: " + barr.length + ". It must be four bytes long");
        }
        int value = barr[0] & 0xFF;
        value = (int)((long)value + (((long)barr[1] & 0xFFL) << 8));
        value = (int)((long)value + (((long)barr[2] & 0xFFL) << 16));
        value = (int)((long)value + (((long)barr[3] & 0xFFL) << 24));
        return SignedInteger.valueOf(value);
    }

    public byte[] getLittleEndianByteArray() {
        byte[] res = new byte[]{(byte)(this.m_value >> 24), (byte)(this.m_value >> 16), (byte)(this.m_value >> 8), (byte)this.m_value};
        return res;
    }

    public static SignedInteger fromLittleEndianByteArray(byte[] barr) throws IllegalArgumentException {
        if (barr.length != 4) {
            throw new IllegalArgumentException("Illegal size of supplied byte array: " + barr.length + ". It must be four bytes long");
        }
        int value = barr[3] & 0xFF;
        value = (int)((long)value + (((long)barr[2] & 0xFFL) << 8));
        value = (int)((long)value + (((long)barr[1] & 0xFFL) << 16));
        value = (int)((long)value + (((long)barr[0] & 0xFFL) << 24));
        return SignedInteger.valueOf(value);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof SignedInteger) {
            return this.m_value == ((SignedInteger)o).m_value;
        }
        return false;
    }

    public int hashCode() {
        return this.m_value;
    }

    @Override
    public int compareTo(SignedInteger l2) {
        return Integer.valueOf(this.m_value).compareTo(l2.m_value);
    }

    public String toString() {
        return "" + this.m_value;
    }
}

