/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

import java.io.Serializable;

public final class UnsignedByte
implements Serializable,
Comparable<UnsignedByte> {
    private static final long serialVersionUID = 1L;
    public static final short MAX_VALUE = 255;
    public static final short MIN_VALUE = 0;
    public static final UnsignedByte ZERO = new UnsignedByte(0);
    public static final UnsignedByte ONE = new UnsignedByte(1);
    private final byte m_value;

    private UnsignedByte(byte value) {
        this.m_value = value;
    }

    public static UnsignedByte valueOf(byte value) {
        switch (value) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
        }
        return new UnsignedByte(value);
    }

    private static UnsignedByte valueOfSafe(int value) {
        return UnsignedByte.valueOf((byte)(value & 0xFF));
    }

    public static UnsignedByte valueOf(short value) throws IllegalArgumentException {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Illegal unsigned byte value " + value + ". It must be between 0 and 255 (inclusive)");
        }
        return UnsignedByte.valueOf((byte)(value & 0xFF));
    }

    public static UnsignedByte valueOf(int value) throws IllegalArgumentException {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Illegal unsigned byte value " + value + ". It must be between 0 and 255 (inclusive)");
        }
        return UnsignedByte.valueOf((byte)(value & 0xFF));
    }

    public int intValue() {
        return this.m_value & 0xFF;
    }

    public short shortValue() {
        return (short)(this.m_value & 0xFF);
    }

    public byte byteValue() {
        return this.m_value;
    }

    public boolean isBitSet(int no) throws IllegalArgumentException {
        if (no < 0 || no > 7) {
            throw new IllegalArgumentException("Invalid bit number " + no + ". It must be between 0 and 7 (inclusive)");
        }
        return (this.m_value & 1 << no) > 0;
    }

    public boolean equals(Object o) {
        return o instanceof UnsignedByte && ((UnsignedByte)o).m_value == this.m_value;
    }

    public int hashCode() {
        return this.m_value;
    }

    @Override
    public int compareTo(UnsignedByte b2) {
        return this.intValue() - b2.intValue();
    }

    public String toString() {
        return Short.toString((short)(this.m_value & 0xFF));
    }
}

