/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.support.lang;

import java.io.Serializable;

public final class UnsignedInteger
implements Serializable,
Comparable<UnsignedInteger> {
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 4;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final int MIN_VALUE = 0;
    public static final UnsignedInteger ZERO = new UnsignedInteger(0);
    public static final UnsignedInteger ONE = new UnsignedInteger(1);
    private final int m_value;

    private UnsignedInteger(int value) {
        this.m_value = value;
    }

    public static UnsignedInteger valueOf(int value) {
        switch (value) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
        }
        return new UnsignedInteger(value);
    }

    public static UnsignedInteger valueOf(long value) throws IllegalArgumentException {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal unsigned integer value " + value + ". It must be between 0 and 4294967295 (inclusive)");
        }
        return UnsignedInteger.valueOf((int)(value & 0xFFFFFFFFFFFFFFFFL));
    }

    public long longValue() {
        return (long)this.m_value & 0xFFFFFFFFL;
    }

    public int intValue() {
        return this.m_value;
    }

    public byte[] getBigEndianByteArray() {
        byte[] res = new byte[]{(byte)(this.m_value & 0xFF), (byte)(this.m_value >>> 8 & 0xFF), (byte)(this.m_value >>> 16 & 0xFF), (byte)(this.m_value >>> 24 & 0xFF)};
        return res;
    }

    public static UnsignedInteger fromBigEndianByteArray(byte[] barr) throws IllegalArgumentException {
        if (barr.length != 4) {
            throw new IllegalArgumentException("The supplied byte array must be four bytes long");
        }
        return UnsignedInteger.fromBigEndianByteArray(barr, 0);
    }

    public static UnsignedInteger fromBigEndianByteArray(byte[] barr, int offset) throws ArrayIndexOutOfBoundsException {
        return UnsignedInteger.valueOf((barr[offset] & 0xFF) + ((barr[offset + 1] & 0xFF) << 8) + ((barr[offset + 2] & 0xFF) << 16) + ((barr[offset + 3] & 0xFF) << 24));
    }

    public static long fromBigEndianByteArrayToLong(byte[] barr, int offset) throws ArrayIndexOutOfBoundsException {
        return (barr[offset] & 0xFF) + ((barr[offset + 1] & 0xFF) << 8) + ((barr[offset + 2] & 0xFF) << 16) + ((barr[offset + 3] & 0xFF) << 24);
    }

    public static long fromLittleEndianByteArrayToLong(byte[] barr, int offset) throws ArrayIndexOutOfBoundsException {
        return (barr[offset + 3] & 0xFF) + ((barr[offset + 2] & 0xFF) << 8) + ((barr[offset + 1] & 0xFF) << 16) + ((barr[offset] & 0xFF) << 24);
    }

    public boolean equals(Object o) {
        return o instanceof UnsignedInteger && ((UnsignedInteger)o).m_value == this.m_value;
    }

    public int hashCode() {
        return this.m_value;
    }

    @Override
    public int compareTo(UnsignedInteger i2) {
        return Long.valueOf(this.longValue()).compareTo(i2.longValue());
    }

    public String toString() {
        return Long.toString((long)this.m_value & 0xFFFFFFFFL);
    }
}

