/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwindct;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import ru.aiefu.timeandwindct.HashMapOf;
import ru.aiefu.timeandwindct.TimeAndWindCT;
import ru.aiefu.timeandwindct.config.ModConfig;
import ru.aiefu.timeandwindct.config.SystemTimeConfig;
import ru.aiefu.timeandwindct.config.TimeDataStorage;

public class ConfigurationManager {
    public static final Gson gson_pretty = new GsonBuilder().setPrettyPrinting().create();

    public static void genTimeData() {
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/time-data.json");){
            gson_pretty.toJson(new HashMapOf<String, TimeDataStorage>("minecraft:overworld", new TimeDataStorage()), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateSysTimeCfg() {
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/system-time-data-global.json");){
            gson_pretty.toJson((Object)new SystemTimeConfig("5:00", "20:00", "3:00"), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateMapSysTime() {
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/system-time-data.json");){
            gson_pretty.toJson(new HashMapOf<String, SystemTimeConfig>("minecraft:overworld", new SystemTimeConfig("5:00", "20:00", "3:00")), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateModConfig(ModConfig config) {
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/config.json");){
            gson_pretty.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateMapSysTime(String worldId, String sunrise, String sunset, String timeZone) {
        TimeAndWindCT.sysTimeMap.put(worldId, new SystemTimeConfig(sunrise, sunset, timeZone));
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/system-time-data.json");){
            gson_pretty.toJson(TimeAndWindCT.sysTimeMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateGlobalSysTimeCfg(String sunrise, String sunset, String timezone) {
        TimeAndWindCT.systemTimeConfig = new SystemTimeConfig(sunrise, sunset, timezone);
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/system-time-data-global.json");){
            gson_pretty.toJson((Object)TimeAndWindCT.systemTimeConfig, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SystemTimeConfig readGlobalSysTimeCfg() {
        SystemTimeConfig config;
        try {
            config = (SystemTimeConfig)gson_pretty.fromJson((Reader)new FileReader("./config/time-and-wind/system-time-data-global.json"), SystemTimeConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            config = new SystemTimeConfig("7:00", "19:00", "local");
        }
        return config;
    }

    public static HashMap<String, SystemTimeConfig> readSysTimeCfg() {
        HashMapOf<String, SystemTimeConfig> map;
        try {
            map = (HashMapOf<String, SystemTimeConfig>)gson_pretty.fromJson((Reader)new FileReader("./config/time-and-wind/system-time-data.json"), new TypeToken<HashMap<String, SystemTimeConfig>>(){}.getType());
        }
        catch (IOException e) {
            e.printStackTrace();
            map = new HashMapOf<String, SystemTimeConfig>("minecraft:overworld", new SystemTimeConfig("5:00", "20:00", "3:00"));
        }
        return map;
    }

    public static void generateModConfig() {
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/config.json");){
            gson_pretty.toJson((Object)new ModConfig(false, false, false, false, 30), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ModConfig readModConfig() {
        ModConfig config;
        block10: {
            try {
                config = (ModConfig)gson_pretty.fromJson((Reader)new FileReader("./config/time-and-wind/config.json"), ModConfig.class);
                if (config.config_ver >= 3) break block10;
                config = ConfigurationManager.patchModConfigV1(config);
                try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/config.json");){
                    gson_pretty.toJson((Object)config, (Appendable)writer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                config = new ModConfig(true, false, false, true, 30);
            }
        }
        return config;
    }

    public static ModConfig patchModConfigV1(ModConfig config) {
        return new ModConfig(config.patchSkyAngle, config.syncWithSystemTime, false, true, 30);
    }

    public static void updateTimeData(String id, int dayD, int nightD) {
        TimeAndWindCT.timeDataMap.put(id, new TimeDataStorage(dayD, nightD));
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/time-data.json");){
            gson_pretty.toJson(TimeAndWindCT.timeDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateTimeData() {
        try (FileWriter writer = ConfigurationManager.getFileWriter("./config/time-and-wind/time-data.json");){
            gson_pretty.toJson(TimeAndWindCT.timeDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int readTimeData() {
        int result;
        HashMapOf<String, TimeDataStorage> timeDataMap;
        try {
            timeDataMap = (HashMapOf<String, TimeDataStorage>)gson_pretty.fromJson((Reader)new FileReader("./config/time-and-wind/time-data.json"), new TypeToken<HashMap<String, TimeDataStorage>>(){}.getType());
            result = 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            timeDataMap = new HashMapOf<String, TimeDataStorage>("minecraft:overworld", new TimeDataStorage());
            result = 0;
        }
        TimeAndWindCT.timeDataMap = timeDataMap;
        return result;
    }

    public static FileWriter getFileWriter(String path) throws IOException {
        return new FileWriter(path);
    }
}

