/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwindct.config;

import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;

public class SystemTimeConfig {
    public String sunrise;
    public String sunset;
    public String timeZone;

    public SystemTimeConfig(String sunrise, String sunset, String timeZone) {
        this.sunrise = sunrise;
        this.sunset = sunset;
        this.timeZone = timeZone;
    }

    public int getSunriseMs() {
        return this.parseTime(this.sunrise);
    }

    public int getSunsetMs() {
        return this.parseTime(this.sunset);
    }

    public int getTimeOffset() {
        return this.parseTimeZone(this.timeZone);
    }

    private int parseTime(String s) {
        try {
            long timeMs;
            int i = s.indexOf(":");
            if (i != -1) {
                long hour = Long.parseLong(s.substring(0, i)) * 3600000L;
                timeMs = hour + Long.parseLong(s.substring(i + 1)) * 60000L;
            } else {
                timeMs = Long.parseLong(s) * 3600000L;
            }
            return (int)timeMs;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return OffsetDateTime.now().get(ChronoField.OFFSET_SECONDS) * 1000;
        }
    }

    private int parseTimeZone(String timeZone) {
        if (timeZone.equalsIgnoreCase("local")) {
            return OffsetDateTime.now().get(ChronoField.OFFSET_SECONDS) * 1000;
        }
        return this.parseTime(timeZone);
    }
}

