/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwindct.mixin;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5838;
import net.minecraft.class_6880;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.aiefu.timeandwindct.ITimeOperations;
import ru.aiefu.timeandwindct.NetworkPacketsID;
import ru.aiefu.timeandwindct.TimeAndWindCT;
import ru.aiefu.timeandwindct.config.TimeDataStorage;
import ru.aiefu.timeandwindct.tickers.DefaultTicker;
import ru.aiefu.timeandwindct.tickers.SystemTimeTicker;
import ru.aiefu.timeandwindct.tickers.Ticker;
import ru.aiefu.timeandwindct.tickers.TimeTicker;

@Mixin(value={class_3218.class})
public abstract class ServerWorldMixins
extends class_1937
implements ITimeOperations {
    @Shadow
    @Final
    private class_5838 field_28859;
    @Shadow
    @Final
    List<class_3222> field_18261;
    @Unique
    protected Ticker timeTicker;
    @Unique
    private boolean shouldUpdate = true;
    @Unique
    private boolean skipState = false;

    protected ServerWorldMixins(class_5269 writableLevelData, class_5321<class_1937> resourceKey, class_5455 registryAccess, class_6880<class_2874> holder, Supplier<class_3695> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @Shadow
    public abstract void method_29199(long var1);

    @Shadow
    protected abstract void method_23660();

    @Shadow
    protected abstract void method_14195();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void attachTimeDataTAW(MinecraftServer minecraftServer, Executor executor, class_32.class_5143 levelStorageAccess, class_5268 serverLevelData, class_5321<class_1937> resourceKey, class_5363 levelStem, class_3949 chunkProgressListener, boolean bl, long l, List<class_5304> list, boolean bl2, class_8565 randomSequences, CallbackInfo ci) {
        String worldId = resourceKey.method_29177().toString();
        if (((class_2874)levelStem.comp_1012().comp_349()).method_29960()) {
            this.timeTicker = new DefaultTicker();
        } else if (TimeAndWindCT.CONFIG.syncWithSystemTime) {
            this.timeTicker = TimeAndWindCT.CONFIG.systemTimePerDimensions && TimeAndWindCT.sysTimeMap != null && TimeAndWindCT.sysTimeMap.containsKey(worldId) ? new SystemTimeTicker(this, TimeAndWindCT.sysTimeMap.get(worldId)) : new SystemTimeTicker(this, TimeAndWindCT.systemTimeConfig);
        } else if (TimeAndWindCT.timeDataMap != null && TimeAndWindCT.timeDataMap.containsKey(worldId)) {
            TimeDataStorage storage = TimeAndWindCT.timeDataMap.get(worldId);
            this.timeTicker = new TimeTicker(storage.dayDuration, storage.nightDuration, this);
        } else {
            this.timeTicker = new DefaultTicker();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="net/minecraft/server/players/SleepStatus.areEnoughDeepSleeping (ILjava/util/List;)Z", ordinal=0), slice=@Slice(from=@At(value="INVOKE", target="net/minecraft/server/level/ServerLevel.advanceWeatherCycle ()V", ordinal=0), to=@At(value="INVOKE", target="net/minecraft/server/level/ServerLevel.wakeUpAllPlayers ()V", ordinal=0)))
    private boolean blockSleepCheckTAW(class_5838 instance, int i, List<class_3222> list) {
        return !TimeAndWindCT.CONFIG.syncWithSystemTime && !TimeAndWindCT.CONFIG.enableNightSkipAcceleration;
    }

    @Inject(method={"updateSleepingPlayerList"}, at={@At(value="TAIL")})
    private void syncSkipStateTAW(CallbackInfo ci) {
        int i = this.method_8450().method_8356(class_1928.field_28357);
        if (this.canAccelerate()) {
            if (this.field_28859.method_33812(i)) {
                if (!this.skipState) {
                    this.skipState = true;
                    if (this.shouldUpdate) {
                        this.broadcastSkipState(true);
                    }
                }
            } else if (this.skipState) {
                this.skipState = false;
                if (this.shouldUpdate) {
                    this.broadcastSkipState(false);
                }
            }
        }
    }

    @Inject(method={"addPlayer"}, at={@At(value="HEAD")})
    private void onPlayerJoin(class_3222 player, CallbackInfo ci) {
        if (this.canAccelerate()) {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeBoolean(this.skipState);
            buf.writeInt(TimeAndWindCT.CONFIG.accelerationSpeed);
            ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkPacketsID.NIGHT_SKIP_INFO, (class_2540)buf);
        }
    }

    @Redirect(method={"tickTime"}, at=@At(value="INVOKE", target="net/minecraft/server/level/ServerLevel.setDayTime(J)V"))
    private void customTickerTAW(class_3218 world, long timeOfDay) {
        this.timeTicker.tick(this);
        if (this.skipState) {
            this.timeTicker.accelerate((class_1937)((class_3218)this), TimeAndWindCT.CONFIG.accelerationSpeed);
            if (this.method_8530()) {
                this.skipState = false;
                this.shouldUpdate = false;
                this.broadcastSkipState(false);
                this.method_23660();
                this.method_14195();
                this.shouldUpdate = true;
            }
        }
    }

    @Unique
    private void broadcastSkipState(boolean bl) {
        this.field_18261.forEach(p -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeBoolean(bl);
            buf.writeInt(TimeAndWindCT.CONFIG.accelerationSpeed);
            ServerPlayNetworking.send((class_3222)p, (class_2960)NetworkPacketsID.NIGHT_SKIP_INFO, (class_2540)buf);
        });
    }

    @Unique
    private boolean canAccelerate() {
        return TimeAndWindCT.CONFIG.enableNightSkipAcceleration && !TimeAndWindCT.CONFIG.syncWithSystemTime;
    }

    @Override
    public void time_and_wind_custom_ticker$wakeUpAllPlayersTAW() {
        this.method_23660();
    }

    @Override
    public Ticker time_and_wind_custom_ticker$getTimeTicker() {
        return this.timeTicker;
    }

    @Override
    public void time_and_wind_custom_ticker$setTimeTicker(Ticker timeTicker) {
        this.timeTicker = timeTicker;
    }

    @Override
    public void time_and_wind_custom_ticker$setTimeOfDayTAW(long time) {
        this.method_29199(time);
    }

    @Override
    public long time_and_wind_custom_ticker$getTimeTAW() {
        return this.field_9232.method_188();
    }

    @Override
    public long time_and_wind_custom_ticker$getTimeOfDayTAW() {
        return this.field_9232.method_217();
    }

    @Override
    public boolean time_and_wind_custom_ticker$isClient() {
        return this.method_8608();
    }

    @Override
    public void time_and_wind_custom_ticker$setSkipState(boolean bl) {
    }

    @Override
    public void time_and_wind_custom_ticker$setSpeed(int speed) {
    }
}

