/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwindct.tickers;

import java.util.function.LongSupplier;
import net.minecraft.class_1937;
import ru.aiefu.timeandwindct.ITimeOperations;
import ru.aiefu.timeandwindct.TimeAndWindCT;
import ru.aiefu.timeandwindct.config.SystemTimeConfig;
import ru.aiefu.timeandwindct.tickers.Ticker;

public class SystemTimeTicker
implements Ticker {
    protected long timeZoneOffset;
    protected final LongSupplier systemTime = () -> System.currentTimeMillis() + this.timeZoneOffset;
    protected int tickMod;
    protected int dayMod;
    protected int nightMod;
    protected int ticks = 0;
    long dayD;
    long nightD;
    int dayF;
    int nightF;
    int sunrise;
    int sunset;

    public SystemTimeTicker(ITimeOperations world, SystemTimeConfig config) {
        this.sunrise = config.getSunriseMs();
        this.sunset = config.getSunsetMs();
        this.timeZoneOffset = config.getTimeOffset();
        if (this.sunrise < this.sunset) {
            this.dayD = this.sunset - this.sunrise;
            this.nightD = 86400000L - this.dayD;
        } else {
            this.nightD = this.sunrise - this.sunset;
            this.dayD = 86400000L - this.nightD;
        }
        this.dayF = (int)(this.dayD / 12000L);
        this.nightF = (int)(this.nightD / 12000L);
        this.dayMod = this.dayF / 50;
        this.nightMod = this.nightF / 50;
        int startingTick = this.calculateCurrentTick();
        world.time_and_wind_custom_ticker$setTimeOfDayTAW(this.unwrapTime(startingTick, world.time_and_wind_custom_ticker$getTimeOfDayTAW()));
    }

    @Override
    public void tick(ITimeOperations world) {
        ++this.ticks;
        long time = world.time_and_wind_custom_ticker$getTimeOfDayTAW();
        int n = this.tickMod = time % 24000L < 12000L ? this.dayMod : this.nightMod;
        if (this.ticks % this.tickMod == 0) {
            world.time_and_wind_custom_ticker$setTimeOfDayTAW(time + 1L);
        }
        if (!world.time_and_wind_custom_ticker$isClient() && this.ticks % 6000 == 0) {
            TimeAndWindCT.LOGGER.info("Checking if time corrections is needed...");
            int targetTicks = this.calculateCurrentTick();
            int timeTicks = (int)(time % 24000L);
            if (targetTicks != timeTicks) {
                world.time_and_wind_custom_ticker$setTimeOfDayTAW(this.unwrapTime(targetTicks, time));
                TimeAndWindCT.LOGGER.info("Time corrected");
            } else {
                TimeAndWindCT.LOGGER.info("Skipping correction");
            }
        }
    }

    @Override
    public void accelerate(class_1937 level, int speed) {
    }

    public void updateTime(ITimeOperations world) {
        world.time_and_wind_custom_ticker$setTimeOfDayTAW(this.unwrapTime(this.calculateCurrentTick(), world.time_and_wind_custom_ticker$getTimeOfDayTAW()));
    }

    private int calculateCurrentTick() {
        long time = this.calculateElapsedTimeWithShift();
        int returnVal = time < this.dayD ? (int)(time / (long)this.dayF) : (int)(12000L + (time - this.dayD) / (long)this.nightF);
        return returnVal;
    }

    private long calculateElapsedTimeWithShift() {
        long currentTime = this.systemTime.getAsLong() % 86400000L;
        int val = (int)(currentTime - (long)this.sunrise);
        if (val < 0) {
            val = (int)(86400000L - ((long)this.sunrise - currentTime));
        }
        return val;
    }

    private long unwrapTime(int targetTime, long timeOfDay) {
        long zeroPoint = timeOfDay - timeOfDay % 24000L;
        return zeroPoint + (long)targetTime;
    }

    public int getSunrise() {
        return this.sunrise;
    }

    public int getSunset() {
        return this.sunset;
    }

    public int getDayMod() {
        return this.dayMod;
    }

    public int getNightMod() {
        return this.nightMod;
    }

    public long getDayD() {
        return this.dayD;
    }

    public long getNightD() {
        return this.nightD;
    }
}

