/*
 * Decompiled with CFR 0.152.
 */
package ru.aiefu.timeandwindct.tickers;

import net.minecraft.class_1937;
import ru.aiefu.timeandwindct.ITimeOperations;
import ru.aiefu.timeandwindct.tickers.Ticker;

public class TimeTicker
implements Ticker {
    private final int dayD;
    private int dayMod;
    private float dayFraction;
    private int dayTicksToAdd;
    private boolean dayAction;
    private final int nightD;
    private int nightMod;
    private float nightFraction;
    private int nightTicksToAdd;
    private boolean nightAction;
    private final ITimeOperations timeLevel;
    private float fraction;

    public TimeTicker(int dayD, int nightD, class_1937 level) {
        this.timeLevel = (ITimeOperations)level;
        this.dayD = dayD;
        this.nightD = nightD;
        boolean dayB = dayD < 12000;
        boolean nightB = nightD < 12000;
        float dayF = this.getFactor(dayD, dayB);
        float nightF = this.getFactor(nightD, nightB);
        int dayWhole = (int)dayF;
        int nightWhole = (int)nightF;
        float dayFraction = dayF - (float)dayWhole;
        float nightFraction = nightF - (float)nightWhole;
        this.finishSetup(dayB, nightB, dayWhole, nightWhole, dayFraction, nightFraction);
    }

    @Override
    public void tick(ITimeOperations world) {
        if (this.isDay()) {
            if (this.timeLevel.time_and_wind_custom_ticker$getTimeTAW() % (long)this.dayMod == 0L) {
                this.update(this.dayTicksToAdd, this.dayFraction, this.dayAction);
            }
        } else if (this.timeLevel.time_and_wind_custom_ticker$getTimeTAW() % (long)this.nightMod == 0L) {
            this.update(this.nightTicksToAdd, this.nightFraction, this.nightAction);
        }
    }

    @Override
    public void accelerate(class_1937 level, int speed) {
        this.timeLevel.time_and_wind_custom_ticker$setTimeOfDayTAW(this.timeLevel.time_and_wind_custom_ticker$getTimeOfDayTAW() + (long)speed);
    }

    public boolean isDay() {
        return this.timeLevel.time_and_wind_custom_ticker$getTimeOfDayTAW() % 24000L < 12001L;
    }

    public void update(int ticksToAdd, float fraction, boolean skip) {
        this.fraction += fraction;
        if (this.fraction > 1.0f) {
            this.fraction -= 1.0f;
            if (skip) {
                return;
            }
            ++ticksToAdd;
        }
        this.timeLevel.time_and_wind_custom_ticker$setTimeOfDayTAW(this.timeLevel.time_and_wind_custom_ticker$getTimeOfDayTAW() + (long)ticksToAdd);
    }

    private float getFactor(int duration, boolean bl) {
        return bl ? 12000.0f / (float)duration : (float)duration / 12000.0f;
    }

    public void finishSetup(boolean day, boolean night, int dayWhole, int nightWhole, float dayFraction, float nightFraction) {
        this.dayFraction = dayFraction;
        this.nightFraction = nightFraction;
        if (day) {
            this.dayMod = 1;
            this.dayTicksToAdd = dayWhole;
            this.dayAction = false;
        } else {
            this.dayMod = dayWhole;
            this.dayTicksToAdd = 1;
            this.dayAction = true;
        }
        if (night) {
            this.nightMod = 1;
            this.nightTicksToAdd = nightWhole;
            this.nightAction = false;
        } else {
            this.nightMod = nightWhole;
            this.nightTicksToAdd = 1;
            this.nightAction = true;
        }
    }

    public long getDayD() {
        return this.dayD;
    }

    public long getNightD() {
        return this.nightD;
    }

    public int getDayMod() {
        return this.dayMod;
    }

    public int getNightMod() {
        return this.nightMod;
    }

    public double getDayRoundingError() {
        return this.dayFraction;
    }

    public double getNightRoundingError() {
        return this.nightFraction;
    }
}

